/*
Navicat MySQL Data Transfer

Source Server         : test2
Source Server Version : 50516
Source Host           : localhost:3306
Source Database       : sitebmpad3_db

Target Server Type    : MYSQL
Target Server Version : 50516
File Encoding         : 65001

Date: 2014-06-27 14:22:55
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `y43zw_assets`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_assets`;
CREATE TABLE `y43zw_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_assets
-- ----------------------------
INSERT INTO `y43zw_assets` VALUES ('1', '0', '1', '219', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
INSERT INTO `y43zw_assets` VALUES ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}');
INSERT INTO `y43zw_assets` VALUES ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `y43zw_assets` VALUES ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `y43zw_assets` VALUES ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}');
INSERT INTO `y43zw_assets` VALUES ('7', '1', '13', '18', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('8', '1', '19', '168', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('9', '1', '169', '170', '1', 'com_cpanel', 'com_cpanel', '{}');
INSERT INTO `y43zw_assets` VALUES ('10', '1', '171', '172', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}');
INSERT INTO `y43zw_assets` VALUES ('11', '1', '173', '174', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('12', '1', '175', '176', '1', 'com_login', 'com_login', '{}');
INSERT INTO `y43zw_assets` VALUES ('13', '1', '177', '178', '1', 'com_mailto', 'com_mailto', '{}');
INSERT INTO `y43zw_assets` VALUES ('14', '1', '179', '180', '1', 'com_massmail', 'com_massmail', '{}');
INSERT INTO `y43zw_assets` VALUES ('15', '1', '181', '182', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('16', '1', '183', '184', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('17', '1', '185', '186', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `y43zw_assets` VALUES ('18', '1', '187', '188', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('19', '1', '189', '192', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('20', '1', '193', '194', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('21', '1', '195', '196', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}');
INSERT INTO `y43zw_assets` VALUES ('22', '1', '197', '198', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}');
INSERT INTO `y43zw_assets` VALUES ('23', '1', '199', '200', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('24', '1', '201', '204', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('25', '1', '205', '208', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('26', '1', '209', '210', '1', 'com_wrapper', 'com_wrapper', '{}');
INSERT INTO `y43zw_assets` VALUES ('27', '8', '20', '27', '2', 'com_content.category.2', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('29', '7', '14', '15', '2', 'com_contact.category.4', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('30', '19', '190', '191', '2', 'com_newsfeeds.category.5', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('31', '25', '206', '207', '2', 'com_weblinks.category.6', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `y43zw_assets` VALUES ('32', '24', '202', '203', '1', 'com_users.category.7', 'Non catégorisé', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('33', '1', '211', '212', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('34', '1', '213', '214', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('198', '8', '28', '37', '2', 'com_content.category.18', 'News flash', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
INSERT INTO `y43zw_assets` VALUES ('199', '198', '33', '34', '3', 'com_content.article.154', 'Monetisation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('200', '198', '31', '32', '3', 'com_content.article.155', 'Prix riz', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('201', '198', '29', '30', '3', 'com_content.article.156', 'News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('255', '8', '38', '47', '2', 'com_content.category.21', 'Featured', '');
INSERT INTO `y43zw_assets` VALUES ('256', '8', '48', '167', '2', 'com_content.category.22', 'Articles', '');
INSERT INTO `y43zw_assets` VALUES ('257', '255', '39', '40', '3', 'com_content.article.208', 'Say Hello To The World', '');
INSERT INTO `y43zw_assets` VALUES ('258', '255', '41', '42', '3', 'com_content.article.209', 'Blog To Build Relations', '');
INSERT INTO `y43zw_assets` VALUES ('259', '255', '43', '44', '3', 'com_content.article.210', 'What is a Blog?', '');
INSERT INTO `y43zw_assets` VALUES ('260', '255', '45', '46', '3', 'com_content.article.211', 'Billet', '');
INSERT INTO `y43zw_assets` VALUES ('261', '256', '49', '50', '3', 'com_content.article.212', 'Accueil', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('262', '256', '51', '52', '3', 'com_content.article.213', 'Historique', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('263', '256', '53', '54', '3', 'com_content.article.214', 'Mission', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('264', '256', '55', '56', '3', 'com_content.article.215', 'Monétisation', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('265', '256', '57', '58', '3', 'com_content.article.216', 'Monétisation en cours', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('266', '256', '59', '60', '3', 'com_content.article.217', 'Partenaires', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('267', '256', '61', '62', '3', 'com_content.article.218', 'Accords Bilatéraux', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('268', '256', '63', '64', '3', 'com_content.article.219', 'Etats-Unis', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('269', '256', '65', '66', '3', 'com_content.article.220', 'Japon', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('270', '256', '67', '68', '3', 'com_content.article.221', 'Espagne', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('271', '256', '69', '70', '3', 'com_content.article.222', 'France', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('272', '256', '71', '72', '3', 'com_content.article.223', 'Italie', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('273', '256', '73', '74', '3', 'com_content.article.224', 'Vénézuela', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('274', '256', '75', '76', '3', 'com_content.article.225', 'Vietnam', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('275', '256', '77', '78', '3', 'com_content.article.226', 'Accords Multilatéraux', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('276', '256', '79', '80', '3', 'com_content.article.227', 'PRODEP', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('277', '256', '81', '82', '3', 'com_content.article.228', 'PRODEPUR', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('278', '256', '83', '84', '3', 'com_content.article.229', 'PUGRD', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('279', '256', '85', '86', '3', 'com_content.article.230', 'PTDT', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('280', '256', '87', '88', '3', 'com_content.article.231', 'PRODEPPAP / CDD URBAIN', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('281', '256', '89', '90', '3', 'com_content.article.232', 'PetroCaribe', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('282', '256', '91', '92', '3', 'com_content.article.233', 'Les Fonds PetroCaribe', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('283', '256', '93', '94', '3', 'com_content.article.234', 'Mécanisme de décaissement', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('284', '256', '95', '96', '3', 'com_content.article.235', 'Video PetroCaribe-Haiti Fr', '');
INSERT INTO `y43zw_assets` VALUES ('285', '256', '97', '98', '3', 'com_content.article.236', 'Video PetroCaribe-Haiti Es', '');
INSERT INTO `y43zw_assets` VALUES ('286', '256', '99', '100', '3', 'com_content.article.237', 'Passation de Marchés', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('287', '256', '101', '102', '3', 'com_content.article.238', 'Utilité', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('288', '256', '103', '104', '3', 'com_content.article.239', 'Dossiers d\'appel d\'offres DAO', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('289', '256', '105', '106', '3', 'com_content.article.240', 'Méthodes d\'évaluation des offres', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('290', '256', '107', '108', '3', 'com_content.article.241', 'Procédures de sélection de consultants', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('291', '256', '109', '110', '3', 'com_content.article.242', 'Contrats', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('292', '256', '111', '112', '3', 'com_content.article.243', 'Avis de recrutement', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('293', '322', '154', '155', '4', 'com_content.article.244', 'Projets', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('294', '322', '150', '151', '4', 'com_content.article.245', 'Critères d\'éligibilité des Projets', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('295', '322', '156', '157', '4', 'com_content.article.246', 'Projets priorisés', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('296', '322', '152', '153', '4', 'com_content.article.247', 'Exécution des projets', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('297', '322', '158', '159', '4', 'com_content.article.248', 'Programme à Impact Communal', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('298', '322', '148', '149', '4', 'com_content.article.249', 'Programme Appui aux Communes', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('299', '322', '160', '161', '4', 'com_content.article.250', 'Programme Investissement Public', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('300', '256', '113', '114', '3', 'com_content.article.251', 'Plan du site', '');
INSERT INTO `y43zw_assets` VALUES ('301', '256', '115', '116', '3', 'com_content.article.252', 'Photos', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('302', '256', '117', '118', '3', 'com_content.article.253', 'Blog', '');
INSERT INTO `y43zw_assets` VALUES ('303', '256', '119', '120', '3', 'com_content.article.254', 'A propos de BMPAD', '');
INSERT INTO `y43zw_assets` VALUES ('304', '256', '121', '122', '3', 'com_content.article.255', 'News', '');
INSERT INTO `y43zw_assets` VALUES ('305', '256', '123', '124', '3', 'com_content.article.256', 'Info1', '');
INSERT INTO `y43zw_assets` VALUES ('306', '256', '125', '126', '3', 'com_content.article.257', 'Info2', '');
INSERT INTO `y43zw_assets` VALUES ('307', '256', '127', '128', '3', 'com_content.article.258', 'Publications', '');
INSERT INTO `y43zw_assets` VALUES ('308', '256', '129', '130', '3', 'com_content.article.259', 'Etudes et Réalisations', '');
INSERT INTO `y43zw_assets` VALUES ('309', '256', '131', '132', '3', 'com_content.article.260', 'Appels d\'offre', '');
INSERT INTO `y43zw_assets` VALUES ('310', '256', '133', '134', '3', 'com_content.article.261', 'Avis de recrutement', '');
INSERT INTO `y43zw_assets` VALUES ('311', '256', '135', '136', '3', 'com_content.article.262', 'Documents à télécharger', '');
INSERT INTO `y43zw_assets` VALUES ('312', '256', '137', '138', '3', 'com_content.article.263', 'Multimédia', '');
INSERT INTO `y43zw_assets` VALUES ('313', '256', '139', '140', '3', 'com_content.article.264', 'Actualités', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('314', '256', '141', '142', '3', 'com_content.article.265', 'Contacts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('316', '1', '215', '216', '1', 'com_phocadownload', 'com_phocadownload', '{}');
INSERT INTO `y43zw_assets` VALUES ('317', '198', '35', '36', '3', 'com_content.article.266', 'Monétisation en cours news', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('318', '7', '16', '17', '2', 'com_contact.category.23', 'Contact_BMPAD', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
INSERT INTO `y43zw_assets` VALUES ('319', '256', '143', '144', '3', 'com_content.article.267', 'PREKAD', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('320', '256', '145', '146', '3', 'com_content.article.268', 'PRODEPUR Habitat', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('321', '1', '217', '218', '1', 'com_xmap', 'com_xmap', '{}');
INSERT INTO `y43zw_assets` VALUES ('322', '256', '147', '162', '3', 'com_content.category.24', 'Les projets', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
INSERT INTO `y43zw_assets` VALUES ('323', '27', '25', '26', '3', 'com_content.article.269', 'Projets Infrastructures Scolaires', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('324', '27', '23', '24', '3', 'com_content.article.270', 'Projets Communaux', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('325', '27', '21', '22', '3', 'com_content.article.271', 'Projets BMPAD', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}');
INSERT INTO `y43zw_assets` VALUES ('326', '256', '163', '164', '3', 'com_content.article.272', 'JSDF', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `y43zw_assets` VALUES ('327', '256', '165', '166', '3', 'com_content.article.273', 'Qui sommes-nous ?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');

-- ----------------------------
-- Table structure for `y43zw_associations`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_associations`;
CREATE TABLE `y43zw_associations` (
  `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_associations
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_banners`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_banners`;
CREATE TABLE `y43zw_banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_banners
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_banner_clients`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_banner_clients`;
CREATE TABLE `y43zw_banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_banner_clients
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_banner_tracks`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_banner_tracks`;
CREATE TABLE `y43zw_banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_banner_tracks
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_categories`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_categories`;
CREATE TABLE `y43zw_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_categories
-- ----------------------------
INSERT INTO `y43zw_categories` VALUES ('1', '0', '0', '0', '23', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '0', '2009-10-18 16:07:09', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('2', '27', '1', '1', '2', '1', 'non-categorise', 'com_content', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:26:37', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('3', '28', '1', '3', '4', '1', 'non-categorise', 'com_banners', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:35', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('4', '29', '1', '5', '6', '1', 'non-categorise', 'com_contact', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:27:57', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('5', '30', '1', '7', '8', '1', 'non-categorise', 'com_newsfeeds', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:15', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('6', '31', '1', '9', '10', '1', 'non-categorise', 'com_weblinks', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('7', '32', '1', '11', '12', '1', 'non-categorise', 'com_users', 'Non catégorisé', 'non-categorise', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '42', '2010-06-28 13:28:33', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('18', '198', '1', '13', '14', '1', 'news-flash', 'com_content', 'News flash', 'news-flash', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '69', '2014-04-19 00:52:28', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('21', '255', '1', '15', '16', '1', 'featured', 'com_content', 'Featured', 'featured', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"robots\":\"\",\"author\":\"\",\"tags\":\"\"}', '69', '2014-05-26 13:31:57', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('22', '256', '1', '17', '20', '1', 'articles', 'com_content', 'Articles', 'articles', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"robots\":\"\",\"author\":\"\",\"tags\":\"\"}', '69', '2014-05-26 13:31:57', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('23', '318', '1', '21', '22', '1', 'contact-bmpad', 'com_contact', 'Contact_BMPAD', 'contact-bmpad', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '69', '2014-06-09 19:09:42', '0', '0000-00-00 00:00:00', '0', '*');
INSERT INTO `y43zw_categories` VALUES ('24', '322', '22', '18', '19', '2', 'articles/les-projets', 'com_content', 'Les projets', 'les-projets', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '69', '2014-06-23 20:23:53', '0', '0000-00-00 00:00:00', '0', '*');

-- ----------------------------
-- Table structure for `y43zw_contact_details`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_contact_details`;
CREATE TABLE `y43zw_contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_contact_details
-- ----------------------------
INSERT INTO `y43zw_contact_details` VALUES ('1', 'Bureau de Monétisation  des Programmes d\'Aide au Développement', 'bureau-monetisation-programmes-aide-developpement', '', 'Blvd. Harry Truman\r\nBoite postale 2488\r\n', 'Port-au-Prince', '', 'Haiti', '', '(509) 2940-8625 \\  2940-8031', '', '<p><span style=\"color: #2e7684; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; background-color: #8ac9d6;\">Nous serions ravis de vous aider à matérialiser votre projet. </span><span style=\"color: #2e7684; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; background-color: #8ac9d6;\">N\'hésitez pas à prendre contact avec nous : </span></p>\r\n<p><iframe src=\"https://mapsengine.google.com/map/embed?mid=zgSMwYtvnsKU.kZlLrQrtT-Hg\" width=\"720\" height=\"480\"></iframe> <br /><small>Afficher <a href=\"https://www.google.fr/maps/ms?ll=18.545331,-72.338276&amp;spn=0.033526,0.055747&amp;t=m&amp;z=15&amp;msa=0&amp;msid=211721672410309478491.0004fb6dc3bd59e91a845&amp;source=embed\" target=\"_blank\" style=\"color: #0000ff; text-align: left;\">BMPAD</a> sur une carte plus grande</small></p>', 'images/template-content/BMPAD.png', null, 'info@bmpad.gouv.ht', '0', '1', '0', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"1\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"jgorival@bmpad.gouv.ht\"}', '0', '23', '1', '(509) 2813-0933 \\  2813-1967', 'http://www.bmpad.gouv.ht', '', '', '', '*', '2014-06-09 19:14:19', '69', '', '2014-06-22 02:56:23', '69', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- ----------------------------
-- Table structure for `y43zw_content`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_content`;
CREATE TABLE `y43zw_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `sectionid` int(10) unsigned NOT NULL DEFAULT '0',
  `mask` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_content
-- ----------------------------
INSERT INTO `y43zw_content` VALUES ('154', '199', 'Monetisation', 'monetisation', '', '<p><a id=\"divNewsObjectlink\" href=\"../pl480_7fev07/monetisation_encours.htm\" target=\"_self\" style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><strong><span style=\"color: #3300ff;\">LA MONETISATION DU RIZ VIETNAMIEN \"10 SOU 10\"</span><br /><br />Au 18 décembre 2013, date d\'arrivée de la quatrième cargaison de 18,000 ™ (720,000 sacs de 25 kg)...</strong></a></p>', '', '1', '0', '0', '18', '2014-04-19 00:57:13', '69', '', '2014-04-19 01:00:35', '69', '0', '0000-00-00 00:00:00', '2014-04-19 00:57:13', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '1', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('155', '200', 'Prix riz', 'prix-riz', '', '<p><a id=\"divNewsObjectlink\" href=\"../pl480_7fev07/partenaire_bilateraux_vietnam.htm\" target=\"_self\" style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><strong><span style=\"color: #3300ff;\">RIZ VIETNAMIEN<br />RECEPTION<br />STRUCTURE DE PRIX<br />VENTES ET DISTRIBUTION</span><br /><br /></strong></a><strong style=\"color: #efefef; font-family: arial, helvetiva; font-size: 12px;\"><a href=\"../pl480_7fev07/pip/Presentation_BMPAD_RIZ_10sou10.pdf\"><span style=\"color: #ff0066;\">(A TELECHARGER)</span></a></strong></p>', '', '1', '0', '0', '18', '2014-04-19 00:58:59', '69', '', '2014-05-29 13:32:42', '69', '0', '0000-00-00 00:00:00', '2014-04-19 00:58:59', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', '0', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('156', '201', 'News', 'news', '', '<p><strong style=\"color: #efefef; font-family: arial, helvetiva; font-size: 12px;\"><span style=\"color: #ff0066;\"><strong style=\"font-family: arial, helvetiva; font-size: 12px; font-weight: normal; color: #000000;\"><a id=\"divNewsObjectlink\" href=\"petrocaribe.html\" target=\"_self\" style=\"font-family: arial, helvetiva; font-size: 12px; font-weight: normal; color: #000000;\">Au 31 mai 2014,<br /><span style=\"color: #0099ff;\">environ 30 millions de barils de produits pétroliers ont été recus en Haïti dans le cadre de l\'Accord PetroCaribe.</span></a><br /></strong></span></strong></p>\r\n<p><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #ff0066;\">Appel d\'offres en cours pour la c</span></strong><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #ff0066;\">onstruction du lycée Lathème de Mirebalais.  DAO à récupérer au BMPAD jusqu\'au 4 juillet 2014.</span></strong></p>\r\n<p><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #0099ff;\">Construction du Lycée Sténio Vincent de Cerca-la-Source et Lycée national de Thomassique financés par le Japon en cours de lancement.</span></strong></p>', '', '0', '0', '0', '18', '2014-04-19 00:59:27', '69', '', '2014-06-26 21:19:44', '69', '0', '0000-00-00 00:00:00', '2014-04-19 00:59:27', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/news.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"right\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"3\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"1\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '23', '0', '0', '', '', '1', '33', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('208', '257', 'Say Hello To The World', 'article', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <p>Dui ut posuere mollis non sed ante in quis amet eleifend enim morbi semper in et magna rhoncus phasellus vestibulum rutrum sit non tristique nulla consequat risus pretium quam nec at quis elit pellentesque in ligula in mi natoque per ipsum et vestibulum sed placerat hendrerit lobortis nunc et dolor faucibus nonummy feugiat ante lacus dictumst vestibulum aliquam auctor in suspendisse ut.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '', '-2', '0', '0', '21', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('209', '258', 'Blog To Build Relations', 'article-1', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <p> laoreet tellus a rhoncus lorem amet turpis eget vitae. Mi sed vestibulum cras pretium nulla quis condimentum mollis urna sodales malesuada nunc eget aptent curabitur. Magnis et volutpat aenean arcu non felis velit varius habitant id. Odio semper vitae ligula id. In nisi nisl nisl ut ut libero per suscipit in tortor mi quis ac.  Sagittis vehicula phasellus quam curabitur.', '  Habitasse libero orci potenti  ultrices adipiscing nulla aliquam et orci. Ut curae primis est hendrerit mi posuere ultrices dui. </p><p>Cras rhoncus lacus pharetra quisque. Mauris posuere leo dui. Faucibus quam id curabitur fusce enim blandit nulla mattis mauris a at et.  Condimentum faucibus at mollis egestas sit nec praesent nec. Rutrum sagittis convallis ligula. Praesent turpis velit nunc nisl. Hendrerit elit sed dui. Tortor sagittis urna nisl cras id quis et. Luctus tellus vehicula.</p><p>Taciti pellentesque  eros turpis dignissim ut. Nisl erat ipsum in velit viverra cras. Fusce ut nec varius nec platea eget malesuada fringilla quis.  Praesent quis netus sagittis purus at accumsan. Euismod vel ligula hac ipsum dolor phasellus.  Nibh vel lacus et vitae condimentum. Non auctor posuere in sit orci curabitur mollis velit leo eros ipsum.  Lobortis  eget ante pretium a consectetuer. Et quis velit tortor  tortor id ac volutpat. Sit quam turpis cras dignissim dictumst ligula leo. Non magna sed ante iaculis. Eu arcu purus et orci ullamcorper.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '-2', '0', '0', '21', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('210', '259', 'What is a Blog?', 'article-2', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <p><img alt=\"\" width=\"360\" height=\"240\" src=\"images/template-content/shutterstock_10015342.jpg\" style=\"float: left;\"></p><p><span style=\"font-weight: bold;\">Habitant egestas eros tellus aliquam vel sagittis eget odio adipiscing placerat in suspendisse id iaculis urna fames nulla pede nec et vel lacus faucibus tempor.</span></p><p>Suspendisse libero felis lorem ut phasellus risus enim. Arcu quisque ligula pellentesque fusce nec et non faucibus ut nam sed ut bibendum tortor erat nisl condimentum.</p><p>Lorem mi egestas eros sit et vestibulum mauris per sem pede in at. Lobortis fermentum felis et.', ' Ac leo  euismod ipsum diam  sed. </p><p>Egestas suscipit non sit ligula lobortis dui. Pellentesque montes accumsan elit nisi a congue varius dolor quis erat.  Odio semper nullam et a sed integer dui hendrerit nunc. Neque enim nec ipsum sed vestibulum. Eros pellentesque amet. Ipsum sed curabitur hendrerit penatibus nunc faucibus rutrum purus id nisl. Posuere sed proin nunc libero aenean praesent est cras eget. Blandit et nibh mattis proin non. Ac ac ligula lacinia quis magna. Tristique id fermentum. Tortor quis vitae torquent rhoncus libero. Vestibulum ligula nunc.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '-2', '0', '0', '21', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('211', '260', 'Billet', 'article-3', '', '\n            <p>gngnn</p>\n        \n        ', '', '-2', '0', '0', '21', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('212', '261', 'Accueil', 'accueil', '', '<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le Programme d\'Alimentation pour le Développement, Bureau de Gestion PL-480/Titre III organisme autonome à caractere administratif, a été institué par arrêté présidentiel le 5 juin 1985.  Placée sous la tutelle du Ministère de la Planification, cette structure devait, à cette époque, gérer l\'aide américaine. </p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/tmpFE6A.png\" border=\"0\" width=\"400\" height=\"121\" style=\"border: 0;\" /></td>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Grâce à son dynamisme et à sa performance, ce bureau s\'est vu confier, au fil des ans, la gestion de fonds de cinq (5) autres bailleurs.  Il s’agit du Canada, de l’Espagne, de l’Italie, de la France et du Japon. Actuellement, le Bureau de Gestion gère également des projets de la Banque Mondiale pour lesquels il joue le rôle d’Agence Nationale d’Exécution.  Il a aussi la responsabilité de la mise en œuvre de l’Accord Pétrocaribe passé entre la République d’Haïti et la République Bolivarienne du Vénézuela.</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le plan d’action et l’orientation stratégique des opérations du Bureau de Gestion sont définis par un Conseil d’Administration de sept (7) membres, tous des ministres, et de son Directeur Général qui assure le rôle de Secrétaire Exécutif.  Pour la gestion quotidienne de l’institution, quatre directions et unités soutiennent la Direction Générale.</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le programme PL-480/Titre III ayant été complètement achevé, il s’avérait nécessaire de changer les statuts du Bureau de Gestion.  Aussi, en août 2006, un nouveau cadre légal a été présenté au Parlement pour ratification.</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La loi créant le Bureau de Monétisation des Programmes d’Aide au Développement a été promulguée le 27 décembre 2007 et publiée au journal officiel Le Moniteur du 4 janvier 2008. Ce bureau désormais remplace le Bureau de Gestion PL-480/Titre III; tous les biens et actifs de ce dernier deviennent le patrimoine de départ du Bureau de Monétisation des Programmes d’Aide au Développement. Les acquis institutionnels de l’ancienne structure sont préservés de manière à garantir la poursuite de la mise en œuvre des projets financés par le Japon, les Etats-Unis d’Amérique, la France, l’Italie, l\'Espagne et  la Banque Mondiale, et de la gestion des programmes de monétisation, en nature ou en espèces, de provenance de l\'aide bilatérale ou multilatérale.</p>\r\n<table style=\"margin-right: auto; margin-left: auto;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=218&amp;catid=22&amp;Itemid=288\">Accords Bilatéraux</a><br /><iframe src=\"http://www.youtube.com/embed/B3a19xuaZhU?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"245\"></iframe></td>\r\n<td style=\"text-align: center; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=225&amp;catid=22&amp;Itemid=295\">Vietnam</a><br /><iframe src=\"http://www.youtube.com/embed/YQkz73XWhyw?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"245\"></iframe></td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=268&amp;catid=22&amp;Itemid=383\">PRODEPUR Habitat</a><br /><iframe src=\"http://www.youtube.com/embed/SnlQUL9lT00?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"245\"></iframe></td>\r\n<td style=\"text-align: center; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=250&amp;catid=22&amp;Itemid=320\">Programme investissement public</a><br /><iframe src=\"http://www.youtube.com/embed/VT7ANsoo7HQ?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"245\"></iframe></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p> </p>\r\n<p style=\"text-align: left;\"> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:04:07', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '10', '0', '47', '', '', '1', '504', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('213', '262', 'Historique', 'historique', '', '<p>\r\n<script type=\"text/javascript\">// <![CDATA[\r\n/*Artisteer scripts*/\r\njQuery(function ($) {\r\n    \'use strict\';\r\n    if ($.fn.slider) {\r\n        $(\".bmpad-slidecontainershutterstock_17150008\").each(function () {\r\n            var slideContainer = $(this), tmp;\r\n            var inner = $(\".bmpad-slider-inner\", slideContainer);\r\n            var helper = null;\r\n            \r\n            if ($.support.transition) {\r\n                helper = new BackgroundHelper();\r\n                helper.init(\"fade\", \"next\", $(\".bmpad-slide-item\", inner).first().css($.support.transition.prefix + \"transition-duration\"));\r\n                inner.children().each(function () {\r\n                    helper.processSlide($(this));\r\n                });\r\n\r\n                \r\n            } else if (browser.ie && browser.version <= 8) {\r\n                var slidesInfo = {\r\n\".bmpad-slideshutterstock_171500080\": {\r\n    \"bgimage\" : \"url(\'images/template-content/slideshutterstock_171500080.jpg\')\",\r\n    \"bgposition\": \"0 0\",\r\n    \"images\": \"\",\r\n    \"positions\": \"\"\r\n},\r\n\".bmpad-slideshutterstock_171500081\": {\r\n    \"bgimage\" : \"url(\'images/template-content/slideshutterstock_171500081.jpg\')\",\r\n    \"bgposition\": \"0 0\",\r\n    \"images\": \"\",\r\n    \"positions\": \"\"\r\n},\r\n\".bmpad-slideshutterstock_171500082\": {\r\n    \"bgimage\" : \"url(\'images/template-content/slideshutterstock_171500082.jpg\')\",\r\n    \"bgposition\": \"0 0\",\r\n    \"images\": \"\",\r\n    \"positions\": \"\"\r\n}\r\n                };\r\n                $.each(slidesInfo, function(selector, info) {\r\n                    processElementMultiplyBg(slideContainer.find(selector), info);\r\n                });\r\n            }\r\n\r\n            inner.children().eq(0).addClass(\"active\");\r\n            slideContainer.slider({\r\n                pause: 2600,\r\n                speed: 600,\r\n                repeat: true,\r\n                animation: \"fade\",\r\n                direction: \"next\",\r\n                navigator: slideContainer.siblings(\".bmpad-slidenavigatorshutterstock_17150008\"),\r\n                helper: helper\r\n            });\r\n            \r\n                        \r\n        });\r\n    }\r\n});\r\n// ]]></script>\r\n<script type=\"text/javascript\">// <![CDATA[\r\ndocument.write(\'<style>.bmpad-slidecontainershutterstock_17150008 {    position: relative;        width: 300px;    height: 203px;        }.default-responsive .bmpad-header .bmpad-slidecontainershutterstock_17150008,.responsive .bmpad-header .bmpad-slidecontainershutterstock_17150008{  position: absolute !important;}.responsive .bmpad-pageslider .bmpad-slidecontainershutterstock_17150008 {  position: absolute !important;}.bmpad-slidecontainershutterstock_17150008 .bmpad-slide-item{    -webkit-transform: rotate(0);    -moz-transform: rotate(0);    transform: rotate(0);}.bmpad-slidecontainershutterstock_17150008 .bmpad-slide-item {    -webkit-transition: 600ms ease-in-out opacity;    -moz-transition: 600ms ease-in-out opacity;    -ms-transition: 600ms ease-in-out opacity;    -o-transition: 600ms ease-in-out opacity;    transition: 600ms ease-in-out opacity;    position: absolute !important;    display: none;	left: 0;	top: 0;	opacity: 0;    width:  100%;    height: 100%;}.bmpad-slidecontainershutterstock_17150008 .active, .bmpad-slidecontainershutterstock_17150008 .next, .bmpad-slidecontainershutterstock_17150008 .prev {    display: block;}.bmpad-slidecontainershutterstock_17150008 .active {    opacity: 1;}.bmpad-slidecontainershutterstock_17150008 .next, .bmpad-slidecontainershutterstock_17150008 .prev {    width: 100%;}.bmpad-slidecontainershutterstock_17150008 .next.forward, .bmpad-slidecontainershutterstock_17150008 .prev.back {    opacity: 1;}.bmpad-slidecontainershutterstock_17150008 .active.forward {    opacity: 0;}.bmpad-slidecontainershutterstock_17150008 .active.back {    opacity: 0;}.bmpad-slideshutterstock_171500080 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500080.jpg\\\');        /* background-size:  auto auto; */        background-position:  center center;    background-repeat: no-repeat;}/* special setup for header/pageslider */.responsive .bmpad-header .bmpad-slideshutterstock_171500080 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500080.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.responsive .bmpad-pageslider .bmpad-slideshutterstock_171500080 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500080.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.default-responsive .bmpad-header .bmpad-slideshutterstock_171500080 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500080.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.default-responsive .bmpad-pageslider .bmpad-slideshutterstock_171500080 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500080.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.bmpad-slideshutterstock_171500081 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500081.jpg\\\');        /* background-size:  auto auto; */        background-position:  center center;    background-repeat: no-repeat;}/* special setup for header/pageslider */.responsive .bmpad-header .bmpad-slideshutterstock_171500081 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500081.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.responsive .bmpad-pageslider .bmpad-slideshutterstock_171500081 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500081.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.default-responsive .bmpad-header .bmpad-slideshutterstock_171500081 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500081.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.default-responsive .bmpad-pageslider .bmpad-slideshutterstock_171500081 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500081.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.bmpad-slideshutterstock_171500082 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500082.jpg\\\');        /* background-size:  auto auto; */        background-position:  center center;    background-repeat: no-repeat;}/* special setup for header/pageslider */.responsive .bmpad-header .bmpad-slideshutterstock_171500082 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500082.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.responsive .bmpad-pageslider .bmpad-slideshutterstock_171500082 {    background-image:  url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500082.jpg\\\');    background-size: auto auto;    background-position:  center center;    background-repeat: no-repeat;}.default-responsive .bmpad-header .bmpad-slideshutterstock_171500082 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500082.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.default-responsive .bmpad-pageslider .bmpad-slideshutterstock_171500082 {    background-image: url(\\\'/sitebmpad3/images/template-content/slideshutterstock_171500082.jpg\\\');    background-size: auto auto;    background-position: center center;    background-repeat: no-repeat;}.bmpad-slidenavigatorshutterstock_17150008 {  display: inline-block;  position: absolute;  direction: ltr !important;  top: 174px;  left: 0%;  z-index: 101;  line-height: 0 !important;  -webkit-background-origin: border !important;  -moz-background-origin: border !important;  background-origin: border-box !important;  -webkit-box-sizing: border-box;  -moz-box-sizing: border-box;  box-sizing: border-box;  text-align: center;    white-space: nowrap;      right: 0px;  }.bmpad-slidenavigatorshutterstock_17150008{background: #B0E080;background: transparent;background: transparent;background: transparent;background: transparent;-svg-background: transparent;background: transparent;padding:7px;}.bmpad-slidenavigatorshutterstock_17150008 > a{background: #619C26;background: #619C26;background: #619C26;background: #619C26;background: #619C26;-svg-background: #619C26;background: #619C26;-webkit-border-radius:30%;-moz-border-radius:30%;border-radius:30%;margin:0 10px 0 0;width: 15px;height: 15px;}.bmpad-slidenavigatorshutterstock_17150008 > a.active{background: #EDEA40;background: #EDEA40;background: #EDEA40;background: #EDEA40;background: #EDEA40;-svg-background: #EDEA40;background: #EDEA40;-webkit-border-radius:30%;-moz-border-radius:30%;border-radius:30%;border:1px solid #E9E616;margin:0 10px 0 0;width: 15px;height: 15px;}.bmpad-slidenavigatorshutterstock_17150008 > a:hover{background: #E9E616;background: #E9E616;background: #E9E616;background: #E9E616;background: #E9E616;-svg-background: #E9E616;background: #E9E616;-webkit-border-radius:30%;-moz-border-radius:30%;border-radius:30%;border:1px solid #EDEA40;margin:0 10px 0 0;width: 15px;height: 15px;}</style>\');\r\n// ]]></script>\r\n</p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 30%; border-width: 0px;\">\r\n<div id=\"shutterstock_17150008\" style=\"position: relative; display: inline-block; z-index: 0; margin: 10px; border-style: solid; border-color: #000000; border-width: 1px;\" class=\"bmpad-collage\">\r\n<div class=\"bmpad-slider bmpad-slidecontainershutterstock_17150008\" data-width=\"300\" data-height=\"203\">\r\n<div class=\"bmpad-slider-inner\">\r\n<div class=\"bmpad-slide-item bmpad-slideshutterstock_171500080\"></div>\r\n<div class=\"bmpad-slide-item bmpad-slideshutterstock_171500081\"></div>\r\n<div class=\"bmpad-slide-item bmpad-slideshutterstock_171500082\"></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-slidenavigator bmpad-slidenavigatorshutterstock_17150008\" data-left=\"0\" data-top=\"1\"><a class=\"bmpad-slidenavigatoritem\" href=\"#\"> </a><a class=\"bmpad-slidenavigatoritem\" href=\"#\"> </a><a class=\"bmpad-slidenavigatoritem\" href=\"#\"> </a></div>\r\n</div>\r\n</td>\r\n<td style=\"width: 60%; border-width: 0px;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le Programme d\'Alimentation pour le Développement, Bureau de Gestion PL-480/Titre III organisme autonome à caractère administratif, a été institué par arrêté présidentiel le 5 juin 1985.  Placée sous la tutelle du Ministère de la Planification, cette structure devait, à cette époque, gérer l\'aide américaine. </p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Grâce à son dynamisme et à sa performance, ce bureau s\'est vu confier, au fil des ans, la gestion de fonds d\'autres bailleurs comme le Canada, l’Espagne, l’Italie, la France, le Japon, la Banque Mondiale ainsi que la responsabilité de la mise en œuvre de l’Accord PétroCaribe passé entre la République d’Haïti et la République Bolivarienne du Vénézuela.<br /><br />Le programme PL-480/Titre III ayant été complètement achevé, il s’avérait nécessaire de changer les statuts du Bureau de Gestion.  Aussi, en août 2006, un nouveau cadre légal a été présenté au Parlement pour ratification.</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-size: 12px;\">La loi créant le Bureau de Monétisation des Programmes d’Aide au Développement a été promulguée le 27 décembre 2007 et publiée au journal officiel Le Moniteur du 4 janvier 2008. Ce bureau désormais remplace le Bureau de Gestion PL-480/Titre III; tous les biens et actifs de ce dernier sont devenus le patrimoine de départ du Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD). Les acquis institutionnels de l’ancienne structure sont préservés de manière à garantir la poursuite de la mise en œuvre des projets financés par les bailleurs, et de la gestion des programmes de monétisation, en nature ou en espèces, de provenance de l\'aide bilatérale ou multilatérale.</span></p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:02:29', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '14', '0', '46', '', '', '1', '117', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('214', '263', 'Mission', 'mission', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 100%;\"></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row responsive-layout-row-2\">\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 50%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Le Bureau de Monétisation des Programmes d’Aide au Développement, ci-devant Bureau de Gestion PL-480/Titre III, a pour mission de veiller, en liaison avec les organismes nationaux et internationaux intéressés, tant publics que privés, à l’application des conventions, protocoles d’entente, accords de don et/ou de prêt conclus entre le Gouvernement haïtien et un donateur ou bailleur de fonds dans le cadre des programmes d’assistance au développement d’Haïti et dont la gestion lui est confiée.</span></p>\r\n', '\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\">Il  est le bras opérationnel du gouvernement pour la mise en place et la gestion des projets de développement de l’Etat haïtien en promouvant les objectifs stratégiques selon les directives de son conseil d’Administration.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Les ressources générées par la monétisation (commercialisation sur le marché local des denrées et des produits reçus dans le cadre des accords de don ou de prêt) sont utilisées pour le financement de projets de développement prioritairement dans les secteurs de l’Agriculture, des Travaux publics, de la Santé, de l’Education, de l’Environnement, etc.</span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 50%; margin-top: 50px;\"><img src=\"images/template-content/lafito.jpg\" border=\"0\" width=\"350\" height=\"260\" style=\"border: 0; float: right; margin-top: 35px; margin-bottom: 0px;\" />\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row responsive-layout-row-2\">\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 50%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span style=\"color: #5c9424; font-size: 14px;\" lang=\"FR-HT\">Vision</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Contribuer au renforcement de l’Etat dans ses fonctions de mise en place du cadre règlementaire de suivi et d’évaluation des programmes de développement confiés au Bureau de Monétisation.</span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 50%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify; padding-left: 20px;\"><strong><span style=\"font-size: 14px; color: #5c9424;\" lang=\"FR-HT\">Valeur</span></strong><span style=\"font-size: 13px; text-align: left;\"> </span></p>\r\n<ul>\r\n<li style=\"text-align: justify;\"><span style=\"color: #2a3215;\">Appliquer avec rigueur les procédures de gestion et de passation de marchés ;</span></li>\r\n<li style=\"text-align: justify;\"><span style=\"color: #2a3215;\">Contribuer à travailler avec professionnalisme et transparence.</span></li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell layout-item-old-0\" style=\"width: 100%;\">\r\n<p><strong style=\"text-align: justify; font-size: 13px;\"><span style=\"color: #5c9424;\" lang=\"FR-HT\">Attributions</span></strong></p>\r\n<ul>\r\n<li style=\"text-align: justify;\">Veiller à l’application des dispositions des accords dont il a à assumer la gestion ;</li>\r\n<li style=\"text-align: justify;\">Gérer les fonds de contrepartie par la vente des produits mis au profit d’Haïti ;</li>\r\n<li style=\"text-align: justify;\">Gérer les fonds de contrepartie et de tout autre programme de financement pour le développement issu d’accords bilatéraux et multilatéraux confiés à sa gestion ;</li>\r\n<li style=\"text-align: justify;\">Assurer la programmation et le suivi des projets financés par l’institution ;</li>\r\n<li style=\"text-align: justify;\">Assurer la mise en œuvre de l’Accord PetroCaribe qui permet à l’Etat haïtien d’acquérir avec des facilités de paiement des produits pétroliers du Venezuela.</li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-26 23:16:22', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/japon\\/DSCN3742.JPG\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '65', '0', '45', '', '', '1', '201', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('215', '264', 'Monétisation', 'monetisation', '', '<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Définition</span></h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La <span style=\"color: #000000;\">monétisation </span>consiste en la commercialisation, sur le marché local, des denrées et des produits reçus dans le cadre des accords de don ou de prêt intervenus entre le gouvernement haïtien et le pays donateur ou le bailleur.<span style=\"font-size: 12px;\"> </span></p>\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Objectifs</span></h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La monétisation effectuée par le Bureau de Monétisation vise particulièrement à :</p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"1\" start=\"1\">\r\n<li><span style=\"color: #000000;\">permettre la réalisation de projets de développement au bénéfice de la population haïtienne, à partir des fonds générés par la vente des produits  ;</span></li>\r\n<li><span style=\"color: #000000;\">combler le déficit céréalier en produits alimentaires et autres;</span></li>\r\n<li><span style=\"color: #000000;\"><span style=\"color: #000000;\">donner du travail à une catégorie de gens (débardeurs, camionneurs, etc.) qui constituent un maillon important de la chaîne de distribution.</span></span></li>\r\n</ol>\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #3c7c03; font-weight: bold;\">Conditions de participation à la vente</span></h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le processus de vente est ouvert à tous ceux qui ont les qualités requises pour y participer. Par voie de presse, le Bureau de Monétisation informe les acheteurs potentiels qui sont :</p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"1\" start=\"1\">\r\n<li><span style=\"color: #000000;\">les commerçants, importateurs et grossistes,</span></li>\r\n<li><span style=\"color: #000000;\">les programmes des ministères concernés,</span></li>\r\n<li><span style=\"color: #000000;\">les organisations non gouvernementales travaillant dans la distribution <span style=\"color: #000000;\">alimentaire</span>.</span></li>\r\n</ol>\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Conditions d’éligibilité pour l’acquisition des denrées</span></h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La vente se fait en général par appel d\'offres.  Les soumissionnaires doivent répondre aux critères définis dans le document d’appel d’offres et fournir les pièces suivantes : carte d’identité professionnelle (CIP), certificat de patente et carte d’immatriculation fiscale (CIF)</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Ils doivent aussi faire preuve d\'une certaine expérience dans le commerce des produits destinés à la vente, disposer d’installation de stockage adéquate et être en mesure de prendre livraison des produits aux dates assignées par le Bureau de Monétisation.</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Selon les conditions du marché la vente peut se faire aussi par prix administrés.</p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:00:50', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '0', '44', '', '', '1', '104', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('216', '265', 'Monétisation en cours', 'monetisation-en-cours', '', '<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: center;\"><span style=\"color: #365615; font-size: 14px;\">  <span style=\"color: #4a771d; font-weight: bold;\">LA MONETISATION DU RIZ  </span></span><a href=\"index.php?option=com_content&amp;view=article&amp;id=225&amp;Itemid=295\" style=\"font-size: 12px;\">VIETNAMIEN \"10 SOU 10\"</a></h2>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 75%; border-width: 0px;\">\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Un montant de Vingt Millions de dollars américains, à partir des fonds <a href=\"index.php?option=com_content&amp;view=article&amp;id=232&amp;Itemid=302\">PetroCaribe</a>, a été alloué au Programme de stabilisation des prix, permettant ainsi l\'acquisition de produits de première nécessité, notamment le riz vietnamien. </span></span></p>\r\n', '\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le riz 10 SOU 10 a contribué, de mars 2013 à cette date, à stabiliser les prix de cette denrée sur le marché et a permis de lutter contre \"la vie chère\".</span></span></p>\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le Bureau de Monétisation des Programmes d\'Aide au Développement (BMPAD) a déjà reçu quatre commandes du riz vietnamien 10 SOU 10, totalisant 66 000 TM</span><span style=\"color: black; font-family: Arial, sans-serif; font-size: 9pt; line-height: 115%; text-align: left;\">, soit un total de 2 640 000 sacs de 25 kg</span><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: inherit;\">. Les deux premières commandes étaient de 15 000 TM chacune (récolte 2012/2013). La troisième et la quatrième de 18 000 TM chacune (récolte 2013). Les troisième et quatrième cargaisons ont été reçues respectivement le 18 octobre 2013 et le 18 décembre 2013. </span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les prix de vente pratiqués pour les deux (2) catégories des acheteurs ont été comme suit:</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>De 20 000 @ 30 000 sacs : 726 gdes/sac de 25kg<span style=\"font-size: 9.0pt; line-height: 115%; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"> </span></li>\r\n<li>De 5 000  @ 10 000 sacs  : 751 gdes/sac de 25kg</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 75%; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/LOGODURIZ.jpg\" border=\"0\" alt=\"\" width=\"198\" height=\"291\" style=\"float: right;\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Il est à noter que les valeurs C &amp; F des 4 cargaisons sont les suivantes:</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>1ère : US$ 509.00/TM</li>\r\n<li>2ème : US$ 504.00/TM</li>\r\n<li>3ème : US$ 493.00/TM</li>\r\n<li>4ème : US$ 475.00/TM</li>\r\n</ul>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"color: #365615; font-size: 14px;\">Les ventes</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le produit des ventes de 452,170 sacs provenant de la 3<sup>ème</sup> cargaison, se chiffre à 325,168,250.00 gourdes. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Réception 4ème cargaison</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Au 18 décembre 2013, date d\'arrivée de la quatrième cargaison de 18,000 ™ (720 000 sacs de 25 kg), il existait une balance théorique non vendue de 267 830 sacs provenant de la troisième cargaison.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Situation de mévente</span></h3>\r\n<p style=\"text-align: justify;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La lenteur dans les livraisons et une situation de mévente généralisée ont été notées à partir de la commercialisation de la 3<sup>ème</sup> cargaison du riz 10 SOU 10. Ceci est dû, selon les enquêtes menées auprès des commerçants, par : </span></p>\r\n<p class=\"MsoNormal\" style=\"margin: 0in 0in 6pt 0.5in; text-indent: -0.25in;\"><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: Arial; color: black; mso-ansi-language: FR;\">a)<span style=\"font-size: 7pt; font-family: \'Times New Roman\';\">     </span></span><!--[endif]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR;\">le changement de stratégie de vente du BMPAD qui a vendu le produit aux grossistes au lieu des importateurs, comme cela avait été fait pour les 2 premières cargaisons;</span></p>\r\n<p class=\"MsoNormal\" style=\"margin: 0in 0in 6pt 0.5in; text-indent: -0.25in;\"><!--[if !supportLists]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: Arial; color: black; mso-ansi-language: FR;\">b)<span style=\"font-size: 7pt; font-family: \'Times New Roman\';\">     </span></span><!--[endif]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR;\">une augmentation de la quantité de riz disponible sur le marché local. </span><span style=\"font-size: 9.0pt; mso-bidi-font-size: 11.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR;\">;</span></p>\r\n<p class=\"MsoNormal\" style=\"margin: 0in 0in 6pt 0.5in; text-indent: -0.25in;\"><!--[if !supportLists]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: Arial; color: black; mso-ansi-language: FR;\">c)<span style=\"font-size: 7pt; font-family: \'Times New Roman\';\">     </span></span><!--[endif]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR;\"> une baisse générale de prix enregistrée dès la mi-octobre au niveau des différentes marques de riz sur le marché local;</span><span style=\"text-align: justify;\"> </span></p>\r\n<p class=\"MsoNormal\" style=\"margin: 0in 0in 6pt 0.5in; text-indent: -0.25in;\"><!--[if !supportLists]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: Arial; color: black; mso-ansi-language: FR;\">d)<span style=\"font-size: 7pt; font-family: \'Times New Roman\';\">     </span></span><!--[endif]--><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: black; mso-ansi-language: FR;\"> la qualité du riz vietnamien provenant de la troisième cargaison jugée inférieure à celle des deux premières cargaisons.</span></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Réactions du BMPAD pour améliorer les ventes</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Vu la quantité de sacs non encore écoulée, le BMPAD décida, pour améliorer la situation des ventes, de réduire le prix de vente du riz de la 3ème cargaison. Ce prix de vente passa de 726 gdes le sac de 25 kg à 710 gdes. Les acheteurs ont eu à bénéficier d\'une compensation en sacs proportionnelle aux quantités qu\'ils avaient achetées. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le BMPAD a repris depuis la fin du mois de décembre une publicité agressive avec les stations de radio sur le riz 10 SOU 10 en vue de \"booster\" les ventes.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 9.0pt; font-family: \'Arial\',\'sans-serif\'; mso-fareast-font-family: \'Times New Roman\'; color: #17365d; mso-ansi-language: FR;\">        </span><span style=\"color: #4a771d; font-size: 14px; font-weight: bold; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif;\">Taxes portuaires et droits de douane</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-family: Arial, sans-serif; font-size: 9pt;\">L’Etat haïtien a perçu 297,821,221.59 gourdes pour les 4 cargaisons du riz 10 SOU 10, soit l’équivalent de US$ 6,531,167.14.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"> </p>\r\n<p> </p>\r\n<p style=\"text-align: center;\"><iframe src=\"http://www.youtube.com/embed/YQkz73XWhyw?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"650\" height=\"345\"></iframe></p>', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:02:42', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/template-content\\/monetisation10.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '24', '0', '43', '', '', '1', '81', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('217', '266', 'Partenaires', 'partenaires', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p style=\"text-align: left;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les principaux partenaires du Bureau de Monétisation sont les différents bailleurs avec lesquels des accords de don et /ou  de prêt ont été signés dans le cadre de la coopération internationale au développement.</span></p>\r\n', '\r\n<p style=\"text-align: left;\"> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"color: #1e240f; background: #FBFAD5; width: 50%;\">\r\n<table style=\"margin-right: auto; margin-left: auto;\" width=\"180\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"border-width: 0px;\" width=\"30\">\r\n<div align=\"center\"><a href=\"partenaires/accords-multilateraux.html\"><img src=\"images/template-content/bm3.gif\" border=\"0\" alt=\"\" width=\"49\" height=\"49\" /></a></div>\r\n</td>\r\n<td style=\"border-width: 0px;\">\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-multilateraux.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Banque Mondiale</span></a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"partenaires/accords-bilateraux/etats-unis.html\"><img src=\"images/template-content/USA.jpg\" border=\"0\" alt=\"\" width=\"53\" height=\"32\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/etats-unis.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Etats-Unis</span></a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"partenaires/accords-bilateraux/japon.html\"><img src=\"images/template-content/japon.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"32\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/japon.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Japon</span></a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"partenaires/accords-bilateraux/italie.html\"><img src=\"images/template-content/ialie.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/italie.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Italie</span></a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<br />\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"color: #1e240f; background: #FBFAD5; width: 50%;\">\r\n<table style=\"margin-right: auto; margin-left: auto;\" width=\"180\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"border-width: 0px;\">\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><img src=\"images/template-content/france.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/france.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">France</span></a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td style=\"border-width: 0px;\">\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\" style=\"text-align: left;\"><img src=\"images/template-content/espagne.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/espagne.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Espagne</span></a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><img src=\"images/template-content/venezuela.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/Venezuela.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Vénézuela</span></a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\" style=\"text-align: left;\"><img src=\"images/template-content/vietnam.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/Vietnam.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\"><span style=\"color: #4a771d;\">Vietnam</span></a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: left; border-width: 0px;\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<br />\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<p>{gallery width=100 height=70 count=6 lightbox=none}drapo{/gallery}</p>', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:02:51', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/japon\\/DSCN3810.JPG\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '31', '0', '42', '', '', '1', '189', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('218', '267', 'Accords Bilatéraux', 'accords-bilateraux', '', '<div class=\"bmpad-content-layout-wrapper\" style=\"margin-bottom: 5px;\">\r\n<div class=\"bmpad-content-layout\" style=\"color: #1e240f; background: #FBFAD5; border-spacing: 10px 10px; border-collapse: separate;\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"color: #1e240f; padding-right: 10px; padding-left: 10px; width: 100%; border-width: 1px; border-color: #F4F28A; border-style: solid;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">Les principaux bailleurs bilatéraux du Bureau de Monétisation sont actuellement :</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: left;\">Etats-Unis</li>\r\n<li style=\"text-align: left;\">Japon</li>\r\n<li style=\"text-align: left;\">Espagne</li>\r\n<li style=\"text-align: left;\">France</li>\r\n<li style=\"text-align: left;\">Italie</li>\r\n<li style=\"text-align: left;\">Vénézuela</li>\r\n<li style=\"text-align: left;\">Vietnam</li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout-wrapper\" style=\"margin-bottom: 5px;\">\r\n<div class=\"bmpad-content-layout\" style=\"color: #2a3215; border-spacing: 10px 0px; border-collapse: separate;\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"color: #2a3215; padding-right: 10px; padding-left: 10px; vertical-align: middle; width: 50%;\">\r\n<table style=\"margin-right: auto; margin-left: auto;\" width=\"180\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td> </td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"partenaires/accords-bilateraux/etats-unis.html\"><img src=\"images/template-content/USA.jpg\" border=\"0\" alt=\"\" width=\"45\" height=\"27\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"partenaires/accords-bilateraux/etats-unis.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Etats-Unis</a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=220&amp;Itemid=290\"><img src=\"images/template-content/japon.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"32\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=220&amp;Itemid=290\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Japon</a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=223&amp;Itemid=293\"><img src=\"images/template-content/ialie.jpg\" border=\"0\" alt=\"\" width=\"44\" height=\"29\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=223&amp;Itemid=293\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Italie</a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<br />\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"color: #2a3215; padding-right: 10px; padding-left: 10px; width: 50%;\">\r\n<table width=\"180\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=222&amp;Itemid=292\"><img src=\"images/template-content/france.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=222&amp;Itemid=292\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">France</a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=221&amp;Itemid=291\"><img src=\"images/template-content/espagne.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=221&amp;Itemid=291\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Espagne</a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=224&amp;Itemid=294\"><img src=\"images/template-content/venezuela.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=224&amp;Itemid=294\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Vénézuela</a></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">\r\n<div align=\"center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=225&amp;Itemid=295\"><img src=\"images/template-content/vietnam.jpg\" border=\"0\" alt=\"\" width=\"50\" height=\"33\" /></a></div>\r\n</td>\r\n<td>\r\n<div align=\"left\" id=\"liste\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000066; height: 24px; margin-top: 2px;\"><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=225&amp;Itemid=295\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066;\">Vietnam</a></div>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td bgcolor=\"#DBB25E\"> </td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<br />\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:03:02', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '0', '41', '', '', '1', '84', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('219', '268', 'Etats-Unis', 'etats-unis', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p style=\"text-align: justify;\"><strong style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; text-align: justify;\"><span style=\"font-size: 14px; color: #2a286b;\"><span style=\"color: #4a771d;\">Aide Alimentaire Américaine</span></span></strong><strong style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d;\"> </span></strong></p>\r\n<p style=\"text-align: justify;\"><strong style=\"font-family: Arial, Helvetica, sans-serif; text-align: justify;\"><span style=\"color: #4a771d; font-size: 14px;\"><br /></span></strong><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Dans le cadre du Programme Titre II, le gouvernement américain a octroyé, au cours de l’exercice 2009-2010, une quantité de 19 000 tonnes métriques de farine de blé, aux fins de monétisation, à trois agences caritatives opérant en Haïti notamment World Vision-Haïti, CRS-Haïti et ACDI-Voca. Les fonds générés par la vente du produit devaient supporter les activités approuvées dans la proposition « Multi Year Assistance Program (MYAP) 2008-2012 » réalisée par lesdites agences. La World Vision-Haïti pour l’exercice 2009-2010 agissant en son nom et en celui des deux autres agences, a la responsabilité d’acquérir le produit, de coordonner avec son agent d’expédition et le Bureau de Monétisation les formalités relatives à la fourniture des denrées et d’accuser réception des recettes recouvrées par ledit bureau pour les différentes agences bénéficiaires.</span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<p style=\"text-align: center;\"><img src=\"images/template-content/USA-2.jpg\" border=\"0\" alt=\"\" width=\"200\" height=\"122\" /></p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:03:22', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '40', '', '', '1', '28', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('220', '269', 'Japon', 'japon', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; -webkit-border-horizontal-spacing: 2px; -webkit-border-vertical-spacing: 2px;\">La coopération avec le Japon a commencé depuis l’année 1995.   Ce pays est l’un des plus anciens et des plus réguliers bailleurs du Bureau de Monétisation.</span></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\"><br />Les domaines d’activités priorisées par le Japon sont :</p>\r\n<ul>\r\n<li>Infrastructures Routières, Portuaires et Hospitalières</li>\r\n<li>Infrastructures Urbaines</li>\r\n<li>Adoquinage de rues</li>\r\n<li>Réhabilitation de Places Publiques</li>\r\n<li>Equipements Sociocommunautaires</li>\r\n<li>Réhabilitation de Marchés</li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: center;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/japon-2.jpg\" border=\"0\" alt=\"\" width=\"130\" height=\"85\" /></p>\r\n{phocadownload view=file|id=28|target=s} {phocadownload view=file|id=29|target=s} {phocadownload view=file|id=30|target=s}</div>\r\n</div>\r\n</div>\r\n<h3>Financement Japon - Lycée Belladères</h3>\r\n<p>{gallery count=3}/sampledata/rea_bmpad/japon_lycee_belladeres{/gallery}</p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:00:39', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '39', '', '', '1', '73', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('221', '270', 'Espagne', 'espagne', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">L’aide est fournie de manière directe (en espèces) dans le cadre de la coopération avec l’Espagne.  Les principaux projets éligibles par cette coopération se retrouvent dans le domaine de :</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p> </p>\r\n<ul>\r\n<li>Agriculture\r\n<ul>\r\n<li>Lacs Collinaires</li>\r\n<li>Réhabilitation de Bassins Versants</li>\r\n</ul>\r\n</li>\r\n<li>Création de Boutiques d’Intrants Agricoles</li>\r\n<li>Equipements Sociocommunautaires\r\n<ul>\r\n<li>Construction / Réhabilitation de Marchés</li>\r\n<li>Construction / Aménagement d’Ecoles</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<p style=\"text-align: center;\"><img src=\"images/template-content/espagne-2.jpg\" border=\"0\" alt=\"\" width=\"124\" height=\"82\" /></p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:01:16', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '38', '', '', '1', '25', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('222', '271', 'France', 'france', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les projets financés dans le cadre de la coopération française visent:</p>\r\n<ul>\r\n<li style=\"text-align: left;\">l’amélioration de la sécurité alimentaire</li>\r\n<li style=\"text-align: left;\">l’agriculture et le développement rural</li>\r\n</ul>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<p style=\"text-align: center;\"><img src=\"images/template-content/france-2.jpg\" border=\"0\" alt=\"\" width=\"119\" height=\"79\" /></p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:03:11', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '37', '', '', '1', '23', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('223', '272', 'Italie', 'italie', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les projets financés par la coopération italienne sont des :</p>\r\n<ul>\r\n<li style=\"text-align: left;\">Petits Projets d’Adduction d’Eau Potable</li>\r\n<li style=\"text-align: left;\">Projets de Cantines Scolaires</li>\r\n<li style=\"text-align: left;\">Activités socio-économiques</li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<p style=\"text-align: center;\"><img src=\"images/template-content/ialie-2.jpg\" border=\"0\" alt=\"\" width=\"120\" height=\"79\" /></p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:00:25', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '36', '', '', '1', '15', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('224', '273', 'Vénézuela', 'venezuela', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-weight: bold; font-size: 16px; color: #365615;\">Accord PetroCaribe</span></h3>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<h3 style=\"margin-top: 15px; margin-left: 20px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Généralités</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">A travers l’Accord de Coopération  Energétique <a href=\"index.php?option=com_content&amp;view=article&amp;id=232&amp;Itemid=302\">PetroCaribe</a>, le Venezuela s\'est engagé à garantir aux pays de la Caraïbe et de l’Amérique Centrale un approvisionnement pétrolier à des conditions préférentielles. Le 15 mai 2006 la République d’Haïti s’est jointe aux treize (13) pays qui avaient souscrit audit Accord lors de la création de <a href=\"index.php?option=com_content&amp;view=article&amp;id=232&amp;Itemid=302\">PetroCaribe</a> le 29 juin 2005. Le Honduras est devenu en décembre 2007 le tout dernier pays membre, le dix-septième, ayant adhéré à ce programme.</p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 50%;\">\r\n<h3 style=\"margin-top: 15px; margin-left: 20px; font-family: Arial, Helvetica, sans-serif; line-height: normal; text-align: center;\"><img src=\"images/template-content/venezuela-2.jpg\" border=\"0\" alt=\"\" width=\"200\" height=\"135\" /><span style=\"color: #4a771d; font-size: 14px; font-weight: bold;\"><br /></span></h3>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<h3 style=\"margin-top: 15px; margin-left: 20px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-size: 14px; font-weight: bold;\">Importance pour Haïti</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La mise en œuvre de l\'Accord <a href=\"index.php?option=com_content&amp;view=article&amp;id=232&amp;Itemid=302\">PetroCaribe</a> permet à l’Etat haïtien, à travers le Bureau de Monétisation, d’acquérir avec des facilités de paiement des produits pétroliers du Vénézuéla, principal fournisseur du marché local depuis plus de 20 ans, pour être revendus aux compagnies pétrolières locales, en vue de satisfaire la consommation interne du pays (14,000 barils par jour).</p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:03:34', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '35', '', '', '1', '24', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('225', '274', 'Vietnam', 'vietnam', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p style=\"text-align: justify;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">L\'une des 12 mesures préconisées par la Commission de stabilisation des prix, est la mise en vente par l\'Etat de certains produits de première nécessité afin de combattre l\'insécurité alimentaire et faire baisser le prix du riz, cette denrée représentant représentant 30% du panier alimentaire. C\'est ainsi qu\'un protocole d\'entente a été passé entre les Gouvernements haitien et vietnamien pour l\'achat de 250,000 TM du riz vietnamien, longs grains, 5% de brisures maximum et répondant au goût de l\'haïtien. Il faut noter que le riz vietnamien en sacs coûte (CFR) près de US$160.00 moins cher la tonne métrique que le riz américain, généralement reçu en vrac.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Il avait été indiqué lors des réunions de la commission susmentionnée qu\'avec le riz vietnamien, la chaine normale de distribution allait être respectée, puisque l\'Etat ne peut à lui seul se substituer aux importateurs et aux grossistes qui ont la logistique, la clientèle et le savoir-faire pour la distribution du riz jusqu\'au consommateur final.</span><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\"><br /></span></p>\r\n<p style=\"text-align: left;\"> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000;\">La première cargaison de 600,000 sacs de 25 Kg (soit 15,000 TM) du riz produit au Vietnam et identifié sous le label 10 SOU 10, est arrivée au port de l\'APN le 19 mars 2013. </span></p>\r\n<p><span style=\"text-align: justify;\"><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">Les prix de vente, devant être pratiqués par les importateurs, les grossistes et les détaillants, avaient été publiés dans la presse écrite et parlée avant l\'arrivage de cette denrée.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\" /></span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: top; width: 50%;\">\r\n<p style=\"text-align: center;\"><img src=\"images/template-content/vietnam-2.jpg\" border=\"0\" alt=\"\" width=\"150\" height=\"99\" /></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p style=\"text-align: justify;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">Une quantité de 460,000 sacs a été vendue au 1er avril 2013. Le prix de vente moyen de la petite marmite dans les différents marchés de la capitale est de 20.00 gourdes, alors que pour les autres marques, le prix moyen est de 27 gourdes.</span></p>\r\n<p style=\"text-align: justify;\"><a href=\"../pl480_7fev07/pip/Presentation_BMPAD_RIZ_10sou10.pdf\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px;\"><span style=\"color: #ff0033; font-size: medium;\"><strong><span style=\"color: #365615;\">RIZ VIETNAMIEN</span></strong></span></a></p>\r\n<ul>\r\n<li><a href=\"phocadownload/all_fichiers/presentation_bmpad_riz_10sou10.pdf\" target=\"_blank\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">RECEPTION - STRUCTURE DE PRIX - VENTES ET DISTRIBUTION</a></li>\r\n</ul>\r\n<a href=\"../pl480_7fev07/monetisation_encours.htm\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px;\"> </a>\r\n<ul>\r\n<li><a href=\"index.php?option=com_content&amp;view=article&amp;id=216&amp;Itemid=286\">SITUATION ACTUELLE DE LA VENTE</a></li>\r\n</ul>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 16:59:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '9', '0', '34', '', '', '1', '40', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('226', '275', 'Accords Multilatéraux', 'accords-multilateraux', '', '<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h3 style=\"margin-top: 15px; margin-right: 0px; margin-bottom: 0px; margin-left: 20px; font-size: 20px; font-family: Arial, Helvetica, sans-serif; font-weight: normal; font-style: normal; line-height: 24px; color: #2a286b; padding: 0px;\"><a href=\"http://www.banquemondiale.org\" target=\"_blank\" title=\"Banque Mondiale\"><span style=\"color: #365615; font-size: 16px; font-weight: bold;\">Banque Mondiale</span></a></h3>\r\n<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">Pour cette institution financière internationale, le BMPAD est présentement responsable du suivi de l’exécution des projets suivants ou de certaines de leurs composantes :</div>\r\n<div style=\"padding-left: 40px;\">\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/prekad.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px;\"><span style=\"color: #5c9424;\">Projet de Reconstruction des Quartiers Défavorisés de Port-au-Prince (PREKAD)</span></a></li>\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/prodepur-habitat-bm.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px;\"><span style=\"color: #5c9424;\">Projet de Developpement Communautaire Participatif en Milieu Urbain - Financement additionnel (PRODEPUR Habitat)</span></a></li>\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/prodepur.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px;\"><span style=\"color: #5c9424;\">Projet de Développement Communautaire Participatif en Milieu Urbain (PRODEPUR)</span></a></li>\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/prodep.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px; cursor: text;\"><span style=\"color: #5c9424;\">Projet National de Développement Communautaire Participatif (PRODEP)</span></a></li>\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/prodeppap-cdd-urbain.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px;\"><span style=\"color: #5c9424;\">Projet Pilote de Développement Communautaire Participatif à Port-au-Prince (PRODEPPAP/ CDD Urbain)</span></a></li>\r\n<li style=\"font-family: \'Times New Roman\'; color: #000000; font-size: medium;\"><a id=\"link\" name=\"link\" href=\"partenaires/accords-multilateraux/jsdf.html\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000066; font-size: 12.5px;\"><span style=\"color: #5c9424;\">Projet Communautaire d\'Urgence Cash-for-work (JSDF)</span></a></li>\r\n</ul>\r\n<span style=\"color: #000000; font-family: \'Times New Roman\'; font-size: medium;\"><br /></span></div>\r\n</div>\r\n<p> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:03:52', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '17', '0', '33', '', '', '1', '198', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('227', '276', 'PRODEP', 'prodep', '', '<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h4 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 25px; text-align: left;\"><span style=\"color: #4a771d; font-size: 14px; font-weight: bold; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; text-align: justify;\">Projet National de Développement Communautaire Participatif (PRODEP)</span><span style=\"font-size: 14px; color: #365615;\"> </span><span style=\"color: #0079db; font-size: 14px;\"><a href=\"http://www.prodep.bureaudegestion.gouv.ht/\">Site en ligne</a></span></h4>\r\n<h4 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 25px;\"> </h4>\r\n</div>\r\n<table id=\"des_proj\" style=\"width: 762px;\" width=\"408\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n<tbody>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Objectif du PRODEP</strong> :</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Contribuer à la réduction de la pauvreté par une amélioration de l’accès des populations rurales et périurbaines aux services sociaux de base, la création d’opportunités de revenus et le renforcement de la cohésion sociale.</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"130\">\r\n<div align=\"right\"><strong>Coût </strong>:</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"247\">71,000,000.00 US$</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<div align=\"right\"><strong>Durée</strong><em> </em>:</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Sept (7) ans</td>\r\n</tr>\r\n<tr bgcolor=\"#E1E1EA\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Financement</strong> :</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<p>Association Internationale de Développement (IDA/Banque Mondiale)    Réf. Projet IDA 093640-HA  - Accord de Dons No. H-1810-HA / H-4450-HT / H-5850-HT</p>\r\n<p>Banque Caribéenne de Développement (CDB)  Réf. Don GA10/HAI</p>\r\n</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<div align=\"right\"><strong>Bénéficiaires cibles</strong> :</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Population du milieu rural et du milieu périurbain pauvre</td>\r\n</tr>\r\n<tr bgcolor=\"#E1E1EA\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<div align=\"right\"><strong>Zones d’intervention</strong> :</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Dix (10) départements géographiques</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<div align=\"right\"><strong>Statut du PRODEP</strong> :</div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Achevé</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:04:25', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '12', '0', '32', '', '', '1', '67', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('228', '277', 'PRODEPUR', 'prodepur', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\"><span style=\"font-size: 14px;\" lang=\"EN-US\"><span style=\"font-weight: bold; color: #4a771d;\">Projet National de Développement Communautaire Participatif en Milieu Urbain (PRODEPUR)</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\" lang=\"EN-US\">Le PRODEPUR est un projet de l’État haïtien financé par la Banque Mondiale et la Banque Caribéenne de Développement (CDB). Mis en œuvre par le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD) pour l’État haïtien, il est exécuté sur le terrain par des prestataires de services appelés Maîtres d’Ouvrage Délégués.</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout-wrapper layout-item-0\">\r\n<div class=\"bmpad-content-layout layout-item-1\">\r\n<div class=\"bmpad-content-layout-row responsive-layout-row-2\">\r\n<div class=\"bmpad-layout-cell layout-item-2\" style=\"width: 40%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span style=\"font-size: 14px; color: #4a771d;\" lang=\"FR-HT\">Objectif du PRODEPUR</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span lang=\"EN-US\">Contribuer à la réduction de la pauvreté par une amélioration de l’accès des populations bénéficiaires aux services de base, à la création de revenus et au renforcement de la cohésion sociale.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span lang=\"EN-US\">Appuyer les populations des quartiers vulnérables urbains et périurbains dans six (6) communes et trois (3) départements du pays.</span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell layout-item-2\" style=\"width: 60%;\">\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px;\" lang=\"EN-US\"><span style=\"font-weight: bold;\">Durée</span> : 6 ans</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px;\" lang=\"EN-US\"><span style=\"font-weight: bold;\">Coût :</span> Le projet a été cofinancé à plus de 20 millions de dollars américains, 15.7 millions par la Banque Mondiale et 5 millions par la Banque Caribéenne de Développement.</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-weight: bold;\" lang=\"EN-US\">Zones d’intervention: <br /></span><span style=\"font-size: 12px;\">Département de l’Ouest : Delmas, Port-au-Prince et Cité Soleil<br /></span><span style=\"font-size: 12px;\">Département de l’Artibonite : Saint Marc et Gonaïves<br /></span><span style=\"font-size: 12px;\">Département du Nord : Cap-Haïtien</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<p style=\"text-align: justify;\"><span style=\"border-collapse: collapse; font-size: 12px; font-weight: bold; -webkit-border-horizontal-spacing: 15px;\"> </span></p>\r\n<p>{phocadownload view=file|id=3|target=s} {phocadownload view=file|id=16|target=s}</p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:05:06', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '18', '0', '31', '', '', '1', '62', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('229', '278', 'PUGRD', 'pugrd', '', '<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; margin-top: 15px; margin-left: 20px;\"> </h3>\r\n<h4 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 25px; text-align: left;\"><span style=\"font-size: 14px;\"><span style=\"font-weight: bold; color: #4a771d;\">Projet d\'Urgence et de Gestion des Risques et Désastres (PUGRD) - Composantes 1 &amp; 3<br /></span><br /></span></h4>\r\n</div>\r\n<table id=\"des_proj\" style=\"width: 650px; margin-right: auto; margin-left: auto;\" width=\"408\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n<tbody>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" width=\"145\">\r\n<div align=\"right\"><strong>Objectif du PUGRD :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"><img src=\"http://www.bureaudegestion.gouv.ht/gif/spacer.gif\" border=\"0\" width=\"10\" height=\"10\" /></td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify; border-width: 0px;\" width=\"251\">Réduire la vulnérabilité des communautés par le biais d’activités d’atténuation de risques et le renforcement des capacités institutionnelles et opérationnelles des entités dédiées à la gestion des risques et des désastres.</td>\r\n</tr>\r\n<tr bgcolor=\"#E1E1EA\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Coût  composantes 1 &amp; 3:</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">8.000.000,00 US$</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Composante 1 :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Reconstruction et réduction des risques<strong> </strong>dans les régions de Fonds-Verrettes, de Belle-Anse et des Gonaïves touchées par les dernières inondations.</td>\r\n</tr>\r\n<tr bgcolor=\"#E1E1EA\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Composante 3 :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Gestion locale des risques par la création, la consolidation et l’intégration de comités communaux de protection civile (CCPC) dans les zones les plus exposées aux risques.</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Durée :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Quatre (4) ans</td>\r\n</tr>\r\n<tr bgcolor=\"#E1E1EA\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Financement :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">Association Internationale de Développement (IDA/Banque Mondiale)<br />Réf. : Projet IDA 090159-HA – Accord de Don No. H-143-0-HA</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Zones d’intervention :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">49 communes des départements Sud, Grand’Anse, Nippes et Artibonite et 5 communes du département de l’Ouest (Pétion-Ville, Carrefour, Delmas, Port-au-Prince et Tabarre).</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"padding-left: 20px;\"> </p>', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:04:37', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '30', '', '', '1', '16', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('230', '279', 'PTDT', 'ptdt', '', '<div class=\"contenu\" style=\"margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h1><span style=\"color: #4a771d; font-size: 14px; font-weight: bold; line-height: 26px; font-family: Arial;\">Projet de Transport et de Développement Territorial (PTDT) -Composantes 2 &amp; 3.2<br /><br /></span></h1>\r\n</div>\r\n<table id=\"des_proj\" style=\"width: 650px; margin-right: auto; margin-left: auto;\" width=\"408\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n<tbody>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\" width=\"161\">\r\n<div align=\"right\"><strong>Objectif du PTDT :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\"><img src=\"http://www.bureaudegestion.gouv.ht/gif/spacer.gif\" border=\"0\" width=\"10\" height=\"10\" /></td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"235\">\r\n<div align=\"justify\" style=\"padding-right: 3px;\">\r\n<p>Appuyer le Gouvernement dans sa poursuite de croissance économique en levant les contraintes liées aux transports et la mise en marché qui entravent la mobilisation du potentiel productif en zone rurale.En d’autres termes, le PTDT vise à :</p>\r\n</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\">\r\n<div align=\"justify\">\r\n<ul>\r\n<li style=\"text-align: justify;\">faciliter la mobilisation du potentiel productif des microrégions retenues en fournissant, de manière coordonnée avec les projets existants ou programmés, un paquet d’infrastructures et de services au niveau intercommunal où il est possible de bénéficier des économies d’échelle voulues ;</li>\r\n<li style=\"text-align: justify;\">intégrer des régions rurales isolées à la communauté nationale.</li>\r\n</ul>\r\n</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<div align=\"right\"><strong>Coût composantes 2 &amp; 3.2 :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">\r\n<div align=\"justify\">3,5 millions de dollars (3.500.000$US)</div>\r\n</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Durée :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<div align=\"justify\">trois (3) ans</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<div align=\"right\"><strong>Financement :</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">Association Internationale de Développement (IDA/Banque Mondiale)<br />Réf. Projet 34938-HT - Accord de Don No. H-213-0-HA</td>\r\n</tr>\r\n<tr bgcolor=\"#ECECF2\">\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\">\r\n<div align=\"right\"><strong>Zones d’intervention:</strong></div>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\">\r\n<p>(1) microrégion Dondon-St Raphaël couvrant cinq communes du département du Nord reliées à Cap-Haïtien : Tronçon Carrefour La Mort - Carrefour Jean Bernard – St Raphaël (38.8 Km)</p>\r\n(2) microrégion Thiotte - Anse-à-Pîtres couvrant quatre communes du département du Sud’Est localisées le long de la frontière avec la République Dominicaine : Tronçon Forêt des Pins – Thiotte – Anse-à-Pîtres (63 Km).</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p> </p>', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:04:51', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '0', '29', '', '', '1', '15', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('231', '280', 'PRODEPPAP / CDD URBAIN', 'prodeppap-cdd-urbain', '', '<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h4 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 25px;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Projet Pilote de Développement Communautaire Participatif à Port-au-Prince (PRODEPPAP/ CDD Urbain)</span></h4>\r\n</div>\r\n<p>      </p>\r\n<table id=\"des_proj\" style=\"width: 650px; margin-right: auto; margin-left: auto;\" width=\"408\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n<tbody>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\" width=\"136\">\r\n<div align=\"right\"><strong>Objectif du PRODEPPAP:</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\"><img src=\"http://www.bureaudegestion.gouv.ht/gif/spacer.gif\" border=\"0\" width=\"1\" height=\"1\" /></td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"262\">Conduire un projet pilote suivant la méthodologie du PRODEP en vue de mitiger la violence et les conflits tout en supportant la stabilisation des zones touchées par :<br />(a)  la fourniture rapide d’un meilleur accès aux services de base et des opportunités de générations de revenus au profit des groupes communautaires et des associations dans les secteurs ciblés; et ;<br />(b  le renforcement de la cohésion sociale et du capital social de ces communautés.</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<div align=\"right\"><strong>Coût :</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">1,250,000.00US$</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\">\r\n<div align=\"right\"><strong>Durée :</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\">Dix-huit (18) mois</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<div align=\"right\"><strong>Financement :</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">Post Conflict Funds (PCF) -Banque Mondiale<br />Réf. Projet 100811-HA – Accord de Don PCF No. TF057498</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\">\r\n<div align=\"right\"><strong>Zones d’intervention :</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\">Cité Soleil et Bel-Air, deux zones de l’aire métropolitaine de Port-au-Prince pauvres et frappées par la violence</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<div align=\"right\"><strong>Statut du PRODEPPAP :</strong></div>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\"> </td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">Achevé</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>  </p>\r\n<p> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-26 23:47:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '8', '0', '28', '', '', '1', '41', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('232', '281', 'PetroCaribe', 'petrocaribe', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<h3 style=\"margin-top: 15px; margin-left: 20px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #365615; font-size: 16px; font-weight: bold;\">PetroCaribe - PDVSA Petroleo S.A.</span><span style=\"color: #a6bd65; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif;\"> </span></h3>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 65%; vertical-align: middle; border-width: 0px;\">\r\n<h3 style=\"margin-top: 15px; margin-left: 20px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Rôle du Bureau de Monétisation</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le Bureau de Monétisation joue un rôle d’intermédiaire entre le fournisseur vénézuélien PDVSA Petroleo S.A. et les compagnies pétrolières locales. La mise en œuvre de l’<a href=\"index.php?option=com_content&amp;view=article&amp;id=224&amp;Itemid=294\">Accord PetroCaribe</a> a démarré avec la réception en octobre et novembre 2007 de deux (2) cargaisons d’asphalte totalisant environ 16,300 barils.</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Dès le mois de février 2008, le Bureau de Monétisation a placé les commandes des produits pétroliers auprès du fournisseur PDVSA Petroleo S.A.. La nomination des volumes et du navire, la facturation et les recouvrements se font désormais à travers ce bureau.  </p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-size: 12px;\">Ces compagnies paient à l\'Etat haïtien 100% de la valeur FOB des cargaisons. Selon les prix du baril affichés sur le marché international, le Gouvernement haïtien transfert 40% à 70% de cette valeur au fournisseur vénézuélien;</span></p>\r\n', '\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-size: 12px;\"> la portion restante, soit 60% à 30%, devant être payée sur 25 ans avec 2 années de grâce et à un taux d’intérêt annuel de 1%.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"text-align: left; font-size: 12px;\">Tous les cargos de produits pétroliers, notamment l\'asphalte, le mazout, la gazoline 91 et 95, le diesel et le kérosène sont désormais reçus en Haïti dans le cadre de l’</span><a href=\"index.php?option=com_content&amp;view=article&amp;id=224&amp;Itemid=294\" style=\"font-size: 12px;\">Accord PetroCaribe</a><span style=\"text-align: left; font-size: 12px;\">. Le premier tanker de carburant est arrivé à Port-au-Prince le 8 mars 2008. Au 31 mars 2014, le Bureau de Monétisation a reçu 7 cargaisons d’asphalte et 140 cargaisons de carburant, soit un total d\'environ 29.4 millions de barils.</span></p>\r\n</td>\r\n<td style=\"width: 35%; text-align: center; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/pdvsahaiti.jpg\" border=\"0\" alt=\"\" width=\"200\" height=\"56\" /><img class=\"bmpad-lightbox\" src=\"images/template-content/tmp62AB.png\" border=\"0\" alt=\"\" width=\"339\" height=\"256\" style=\"margin-top: 25px;\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000;\">Il faut noter qu\'une cargaison de mazout d\'environ 65,000 barils a été reçue le 13 novembre 2008, une d\'environ 69,000 barils reçue le 26 mai 2009 et une troisième d’environ 73,000 barils est arrivé au port de Varreux le 11 août 2009. Ce produit est utilisé par les nouvelles usines électriques du Cap-Haïtien, des Gonaïves et de Carrefour d\'une capacité totale de 60 mégawatts.<br /><br /></span><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">{phocadownload view=category|id=1|target=b}</span></p>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row responsive-layout-row-2\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p>Video PetroCaribe-Haiti Français<iframe src=\"http://www.youtube.com/embed/B3a19xuaZhU?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"250\"> </iframe></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p>Video PetroCaribe-Haiti Espagnol<iframe src=\"http://www.youtube.com/embed/n7IDt1Tj64M?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"250\"> </iframe></p>\r\n</div>\r\n</div>\r\n</div>', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:05:19', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '8', '0', '27', '', '', '1', '132', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('233', '282', 'Les Fonds PetroCaribe', 'les-fonds-petrocaribe', '', '<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"> </p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">À la faveur de l’Accord PetroCaribe démarré en octobre 2007, l’État haïtien bénéficie de facilités de paiement pour l’achat de gazoline, de diesel, de kérozène, de mazout et d’asphalte du Vénézuela, principal fournisseur du marché local depuis plus de 20 ans.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Ces produits pétroliers sont achetés au prix en vigueur sur le marché international. Les commandes sont placées à travers le Bureau de Monétisation, ci-devant Bureau de Gestion PL-480,  pour le compte des compagnies pétrolières locales. Le Bureau de Monétisation joue, en fait, un  rôle d’intermédiaire entre le fournisseur vénézuélien PDVSA Petroleo S.A. et les compagnies pétrolières haïtiennes.<br /></span></p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">{phocadownload view=category|id=1|target=b}</ol>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Modalités de paiement</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Les facilités s’appliquent seulement au paiement,  lequel est conditionné par un délai allant de 30 à 90 jours maximum à partir de la date de chargement du bateau. Une partie du montant facturé est payée “cash”: sans intérêts jusqu’aux 30 premiers jours et avec 2% d’intérêts annuels du 31ème jour au 90ème. La balance est payable sur 25 ans avec 1% d’intérêts annuels. À noter qu’une période de  2 années de grâce est accordée avant le premier versement sur la dette.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Le montant cash à payer varie en fonction du prix du baril de pétrole sur le marché international. Ceci dit, quand le prix du baril augmente la partie cash diminue et vice versa. Pour un baril en dessous de US$ 40, le paiement cash couvre 75% de la livraison (Voir encadré). Le pourcentage non encore payé représente la dette à long terme de l’Etat haïtien reconnue par des Notes d’Engagement.</span></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Notes</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Partie financée sur 25 ans avec 1% d’intérêts annuels incluant 2 années de grâce</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">·          </span><span lang=\"ES-VE\">Si le prix du baril est égal à $150. Et plus partie Cash 30% - Partie Financée 70%</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">·          </span><span lang=\"ES-VE\">Si le prix du baril se situe entre $100 et $150. Partie Cash 40% - Partie Financée 60 %</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">·          </span><span lang=\"ES-VE\">Entre $80 et $100. Partie Cash 50% - Partie Financée 50%</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">·          </span><span lang=\"ES-VE\">Entre $50 et $80. Partie Cash 60% - Partie Financée 40%</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">·          </span><span lang=\"ES-VE\">Entre $40 et $50. Partie Cash 70% - Partie Financée 30%</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Partie financée sur 17 ans avec 2% d’intérêts annuels incluant 2 années de grâce</span></p>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" lang=\"ES-VE\">·          </span><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" lang=\"ES-VE\">Entre $30 et $40. Partie Cash 75% - Partie Financée 25 %</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">À chaque livraison de produits pétroliers au pays, PDVSA Petroleo S.A. facture le Bureau de Monétisation qui, en retour facture les compagnies pétrolières locales. Ces dernières  doivent payer 100% des montants facturés dans un délai maximum de 30 jours à partir de la date de chargement des bateaux  transportant les produits en Haïti. Ces paiements s’effectuent par transfert de fonds sur le compte Petro Caribe logé à la BNC.</span></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Volume des achats et flux du compte PetroCaribe</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">De l’entrée en vigueur de l’Accord PetroCaribe au 31 mars 2014, le montant total des importations d\'environ 29.4 millions de barils de produits pétroliers pour le pays s’élève à US$ 3,175,804,910.05.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">La portion cash à payer est de US$ 1,402,942,058.56. Il a été versé à PDVSA Petroleo S.A. US$ 1,325,100,407.04.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">La dette à long terme cumulée au 31 mars 2014, devant être payée sur une période de 25 ans, se chiffrerait à US$ 1,772,862,851.49. Cependant, suite au séisme dévastateur du 12 janvier 2010, la République Bolivarienne du Vénézuela a annulé officiellement US$ 395,000,000.00 de la dette de la République d\'Haïti. Par conséquent, la dette effective d\'Haïti au 31 mars 2014 est de US$ 1,377,862,851.49.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span lang=\"ES-VE\">Les fonds de PetroCaribe accusent au 31 mars 2014 des soldes bancaires de US$ 80,461,335.80 sur le compte en dollars américains logé à la BNC, de HTG 2,897,396,433.44 sur le compte en gourdes logé à la BNC et de HTG 2,620,265,500.41 sur le compte en gourdes logé à la BRH.</span></p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:05:30', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', '26', '', '', '1', '43', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('234', '283', 'Mécanisme de décaissement', 'mecanisme-de-decaissement', '', '<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les différentes étapes de décaissement des fonds PetroCaribe :</p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">{phocadownload view=category|id=1|target=b}\r\n<li>\r\n<div align=\"justify\">Les projets sont proposés au Conseil d’Administration du BMPAD. Ce Conseil est composé des membres suivants : Le Ministre de l’Economie et des Finances, le Ministre du Commerce, le Ministre de la Planification et de la Coopération Externe, le Ministre des Travaux Publics, le Ministre de l’Agriculture, le Gouverneur d, ainsi que le Directeur Général du BMPAD qui est Secrétaire Exécutif du Conseil d’Administration (ayant une voix consultative et non décisionnelle).<br />Les différents secteurs soumettent au Conseil d’Administration du BMPAD une liste de projets qu’ils proposent d’inclure dans une nouvelle résolution.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Une fois les projets approuvés en Conseil d’Administration, la résolution est envoyée au Conseil des Ministres où elle doit être signée. Cette résolution doit ensuite être publiée dans Le Moniteur.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Pour sélectionner une firme d’exécution, le secteur portant le projet, soit le maitre d’ouvrage, doit suivre la procédure de passation de marchés en faisant un appel d’offres – à moins que ce soit des projets d’urgence. Dans ce cas, le maitre d’ouvrage peut établir des contrats gré à gré.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Après avoir sélectionné la firme, le secteur signe un contrat avec celle-ci.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Tous les contrats doivent être approuvés par la Commission Nationale des Marchés Publics (CNMP) et la Cour Supérieure des Comptes et du Contentieux Administratif (CSCCA).</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Afin d’être payée, la firme envoie les bordereaux au secteur avec lequel elle a signé le contrat. Les bordereaux doivent être approuvés par la firme de supervision. Une fois reçu par le secteur ou maitre d’ouvrage, celui-ci peut, par exemple, envoyer ses ingénieurs sur le chantier pour vérifier que les travaux que la firme prétend avoir achevés sont en effet achevés.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Une fois le bordereau approuvé, le maitre d’ouvrage  envoie une requête de décaissement au Ministère de la Planification et de la Coopération Externe (MPCE).</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Le MPCE envoie ensuite une demande de décaissement au MEF</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Le MEF envoie la demande de décaissement au BMPAD. Seul le MEF a l’autorité d’envoyer une telle requête, signée par le Ministre des Finances, au BMPAD pour décaisser des fonds des comptes PetroCaribe.</div>\r\n</li>\r\n<li>\r\n<div align=\"justify\">Par la suite, le BMPAD fait une demande  de transfert des comptes PetroCaribe au Trésor Public. C’est le Trésor Public qui paie directement la firme. Ce processus a pour but de garantir l’impossibilité de pouvoir décaisser de l’argent alloué à un projet à un autre projet.</div>\r\n</li>\r\n</ol>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:01:06', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '25', '', '', '1', '44', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('235', '284', 'Video PetroCaribe-Haiti Fr', 'article-27', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '24', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('236', '285', 'Video PetroCaribe-Haiti Es', 'article-28', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '23', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('237', '286', 'Passation de Marchés', 'passation-de-marches', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 33%;\">\r\n<p><img class=\"bmpad-lightbox\" src=\"images/template-content/pm.jpg\" border=\"0\" alt=\"\" width=\"199\" height=\"141\" /></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 67%;\">\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"color: #4a771d; font-size: 14px; font-weight: bold;\">LA PASSATION DE MARCHES PUBLICS</span></h3>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Il existe en Haïti un manque de vulgarisation des techniques de passation de marchés publics. Par définition, ces derniers sont des contrats attribués par les collectivités publiques nationales et territoriales, en vue de l\'acquisition de fournitures et de services et de la réalisation de travaux .</p>\r\n<span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Ainsi, il est important que les agences d’exécution de l’Etat haïtien, comme le Bureau de Monétisation, maîtrisent cet instrument de gestion publique, en appliquant les mécanismes généralement employés dans le processus de passation de contrats d’exécution des commandes publiques. <br /><br /></span>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=238&amp;Itemid=308\"><span style=\"color: #365615;\">Utilité</span></a> <br /><a href=\"../passation-de-marche/dossiers-dappel-doffres\"><span style=\"color: #365615;\">Dossiers d\'appel d\'offres </span></a><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=240&amp;Itemid=310\"><span style=\"color: #365615;\">Méthodes d\'évaluation des offres</span></a></td>\r\n<td style=\"width: 50%; border-width: 0px;\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=241&amp;Itemid=311\"><span style=\"color: #365615;\">Procédures de sélection de consultants </span></a><br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=242&amp;Itemid=312\"><span style=\"color: #365615;\">Contrats</span></a> <br /><a href=\"index.php?option=com_content&amp;view=article&amp;id=243&amp;Itemid=313\"><span style=\"color: #365615;\">Avis de recrutement</span></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:06:55', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '22', '', '', '1', '40', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('238', '287', 'Utilité', 'utilite', '', '<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 10px; margin-left: 0px; line-height: normal; text-align: justify;\"><span style=\"font-size: 16px; font-weight: bold; color: #365615;\">A- Pourquoi avoir recours aux marchés?</span></h3>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 55%; vertical-align: middle; text-align: justify; border-width: 0px;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">A-1.-Economie, éfficacite, équité, transparence</span></h2>\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000;\">Compte tenu des considérations d’économie, d’efficacité et de transparence, le Bureau de Gestion PL-480 requiert que son administration obtienne les biens et services par voie d’appel à la concurrence.</span></p>\r\n<span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">En effet, le processus de passation de marchés publics permet d’obtenir des produits, ouvrages ou services économiques de qualité, efficaces et à temps voulu, suite à un processus de sélection de l’offre jugée la plus avantageuse.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Il faut aussi souligner que ce processus est une incitation au développement d’activités locales, eu égard à l’opportunité égale offerte à tous les intéressés de soumissionner.</span></td>\r\n<td style=\"width: 50%; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/Marches%20publics%20collectivites%20publiques%20territoriales%20travaux%20publics%20passation%20formulaires.jpg\" border=\"0\" alt=\"\" width=\"299\" height=\"199\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<h2 style=\"margin-top: 10px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">A-2.- Principes applicables aux marchés</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: justify;\"><span style=\"color: #000000;\">Recherche d’efficacité</span></li>\r\n<li style=\"text-align: left;\"><span style=\"color: #000000;\">Egalité d’accès à la commande publique (donner à tous les soumissionnaires une chance de soumettre une offre)</span></li>\r\n<li style=\"text-align: justify;\"><span style=\"color: #000000;\">Transparence du processus de passation des marchés.</span></li>\r\n</ol></td>\r\n<td style=\"width: 50%; text-align: justify; border-width: 0px;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-weight: bold; font-size: 14px; color: #4a771d;\">A-3.- Règlementation des marchés publics</span></h2>\r\n<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; color: #000000;\">Elle repose sur deux principes :</span></p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">\r\n<li><span style=\"color: #000000;\">Egalité des entreprises face à la commande publique</span></li>\r\n<li><span style=\"color: #000000;\">Mise en concurrence des entreprises</span>.</li>\r\n</ol></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p> </p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:11:00', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '21', '', '', '1', '5', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('239', '288', 'Dossiers d\'appel d\'offres DAO', 'dossiers-d-appel-d-offres-dao', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"padding: 0px; vertical-align: top; width: 100%;\">\r\n<h3 style=\"margin-left: 10px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 16px; color: #365615; font-weight: bold;\">B- Dossiers d’Appel d’Offres (DAO)</span><br /><br /></h3>\r\n<span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">C’est un ensemble de documents  comportant les directives, les dispositions et spécifications relatives aux prestations désirées, et préparés à l’intention des entreprises intéressées à sou- missionner au titre d’une mise en concurrence.<br /></span><br />\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px;\"><span style=\"font-weight: bold; color: #4a771d;\">B-1- Objectifs</span></span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Donner aux soumissionnaires les informations nécessaires sur la source de financement et les procédures à suivre pour préparer les offres</li>\r\n<li>Décrire les besoins de l’autorité contractante (fournitures ou travaux) qui font l’objet <br />de l’appel d’offres</li>\r\n<li>Enoncer les critères d’évaluation des offres</li>\r\n<li>Décrire les conditions du marché.</li>\r\n</ol></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">B-2- Contenu</span></h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le contenu du dossier d\'appel d\'offres est souvent dépendant du type de marché.</p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 62%; border-width: 0px;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold;\">B.-2.1- Dossier d’appel d’offres pour Consultants</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Demande de propositions / Lettre d’invitation (pour Appel d’offres restreint)</li>\r\n<li>Termes de référence</li>\r\n<li>Informations supplémentaires aux consultants</li>\r\n<li>Proposition technique </li>\r\n<li>Proposition financière</li>\r\n<li>Modèle de contrats de services de consultants : Tâches rémunérées de façon forfaitaire sur le temps passé</li>\r\n<li>Tâches brèves : Rémunération basée sur le temps passé ou paiement forfaitaire.</li>\r\n</ol></td>\r\n<td style=\"width: 50%; vertical-align: top; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/maechepublic.png\" border=\"0\" alt=\"\" width=\"252\" height=\"206\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"> </h2>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 60%;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-weight: bold; color: #4a771d;\">B.-2.2- Dossier d’appel d’offres pour Travaux</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Avis d’Appel d’Offres / Lettre d’invitation (pour Appel d’offres restreint)</li>\r\n<li>Instructions générales aux soumissionnaires (IGS).</li>\r\n<li>Instructions spéciales aux soumissionnaires (ISS).</li>\r\n<li>Modèle d’offre (Lettre de soumission)</li>\r\n<li>Cahier de clauses administratives générales (CCAG)</li>\r\n<li>Cahier de clauses administratives particulières (CCAP)</li>\r\n<li>Cahier de charges et études techniques : (Données techniques pertinentes<br />(y compris données de nature géologique et/ou environnementale)</li>\r\n<li>Bordereau des prix et des détails quantitatifs et estimatifs</li>\r\n<li>Sous détail des prix</li>\r\n<li>Délai d’achèvement des travaux</li>\r\n<li>Spécifications techniques</li>\r\n<li>Plans</li>\r\n<li>Modèles de formulaires (Garantie de soumission, de bonne exécution,… )</li>\r\n<li>Modèle de marchés (modèle de contrat)</li>\r\n<li>Annexes</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 40%;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold;\">B.-2.3- Dossier d’appel d’offres pour Approvisionnement et Services</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Avis d’Appel d’Offres / Lettre d’invitation (pour Appel d’offres restreint)</li>\r\n<li>Instructions aux Soumissionnaires (IGS).</li>\r\n<li>Données particulières de l’appel d’offres (DPAO) ou Instructions spéciales aux soumissionnaires (ISS).</li>\r\n<li>Cahier de charges administratives générales (CCAG)</li>\r\n<li>Cahier de charges administratives particulières (CCAP)</li>\r\n<li>Bordereau des prix et des détails quantitatifs et qualitatifs</li>\r\n<li>Spécifications techniques</li>\r\n<li>Garantie de soumission</li>\r\n<li>Plans</li>\r\n<li>Annexes</li>\r\n</ol></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 45%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: center;\"><span style=\"font-weight: bold; font-size: 14px; color: #4a771d;\">B-3- Etapes pour le suivi de la soumission</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"i\" start=\"1\">\r\n<li style=\"text-align: left;\">Remise des offres</li>\r\n<li style=\"text-align: left;\">Ouverture des plis</li>\r\n<li style=\"text-align: left;\">Validité des offres</li>\r\n<li style=\"text-align: left;\">Evaluation des offres</li>\r\n<li style=\"text-align: left;\">Attribution du marché</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 55%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">B-4- Confidentialité</span></h2>\r\n<span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Lorsque l’attribution provisoire du contrat est notifiée à la firme gagnante, les autres soumissionnaires seront informés du choix et éventuellement de l’évaluation et des recommandations d’attribution. En aucun cas ces informations ne peuvent être retirées avant l’attribution du contrat. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">En cas d’échec de la négociation avec la firme gagnante, il est obligatoire de négocier avec le soumissionnaire placé en deuxième position, et ainsi de suite jusqu’au dernier pré qualifié.</span></div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:06:42', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '20', '', '', '1', '8', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('240', '289', 'Méthodes d\'évaluation des offres', 'methodes-d-evaluation-des-offres', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 40%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"color: #4a771d; font-size: 14px; font-weight: bold;\">C.-1- QUALITE ET COUT</span><span style=\"font-size: 12px;\"> </span><br /><span style=\"font-size: 12px;\">(<span style=\"color: #5c9424;\">cas le plus fréquent</span>)</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Evaluation propositions techniques et pondération</li>\r\n<li>Evaluation propositions financières et pondération</li>\r\n<li>Sommation pondérée</li>\r\n<li>Attribution au meilleur score</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 30%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: left;\"><span style=\"color: #4a771d; font-weight: bold; font-size: 14px;\">C.-2- BUDGET FIXE</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: left;\">Evaluation propositions techniques et pondération</li>\r\n<li style=\"text-align: left;\">Elimination des offres supérieures au budget fixé</li>\r\n<li style=\"text-align: left;\">Attribution au meilleur score</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 30%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: left;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">C.-3- MOINS DISANT</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: left;\">Evaluation propositions techniques</li>\r\n<li style=\"text-align: left;\">Etablissement d’un score minimum</li>\r\n<li style=\"text-align: left;\">Elimination des offres inférieures au score minimum</li>\r\n<li style=\"text-align: left;\">Attribution au moins disant</li>\r\n</ol></div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-weight: bold; font-size: 14px; color: #4a771d;\">C.-4- QUALIFICATION</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Recueillir expressions d’intérêt</li>\r\n<li>Etablir une liste restreinte</li>\r\n<li>Evaluation : Qualifications et Références</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">C.-5- SOURCE UNIQUE</span><span style=\"font-size: 12px;\">   (<span style=\"color: #5c9424;\">exceptionnellement</span>)</span></h2>\r\n<p> </p>\r\n<ol>\r\n<li style=\"text-align: left;\"><span style=\"font-size: 12px;\">Continuité contrat précédent attribué sur base compétitive.</span></li>\r\n<li style=\"text-align: left;\"><span style=\"font-size: 12px;\">La firme est invitée à faire une proposition technique et financière, et ensuite à négocierun contrat.</span></li>\r\n</ol>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:10:48', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '19', '', '', '1', '15', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('241', '290', 'Procédures de sélection de consultants', 'procedures-de-selection-de-consultants', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"color: #4a771d; font-size: 14px; font-weight: bold;\">D.-1- POUR LES FIRMES</span></h3>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Etablir une liste restreinte</li>\r\n<li>Recevoir les offres techniques et financières dans des enveloppes séparées ( système 2 enveloppes)</li>\r\n<li>Evaluer propositions techniques</li>\r\n<li>Evaluer propositions financières</li>\r\n<li>Pondérer critère prix</li>\r\n<li>Négocier le contrat avec le consultant classé Premier.</li>\r\n</ol></div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold; font-size: 14px;\">D.-2- POUR LES INDIVIDUS</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Recueillir expression d’intérêts</li>\r\n<li>Comparer au moins 3 CV</li>\r\n<li>Faire examiner les TDRs par la CNMP</li>\r\n<li>Transmission du contrat à la CNMP pour non objection</li>\r\n<li>Transmission du contrat à la CSCCA par la CNMP pour enregistrement</li>\r\n<li>Transmission du contrat à l’autorité contractante par la CNMP pour exécution.</li>\r\n</ol></div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:09:20', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '18', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('242', '291', 'Contrats', 'contrats', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"vertical-align: middle; width: 100%;\">\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"font-weight: bold; font-size: 14px; color: #4a771d;\">E.-1- METHODOLOGIE DE NEGOCIATION DU CONTRAT</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Discussion du plan de travail</li>\r\n<li>Mise au point des Termes de Référence (TDR)</li>\r\n<li>Finalisation dela constitution de l’équipe</li>\r\n<li>Précision des moyens mis à disposition</li>\r\n<li>Mise au point du chronogramme</li>\r\n</ol><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Pas de discussion sur les prix unitaires, lorsque le prix est <br />un facteur d’évaluation.</span></td>\r\n<td style=\"width: 50%; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/Marches%20publics%20collectivites%20publiques%20territoriales%20travaux%20publics%20passation%20formulaires-2.jpg\" border=\"0\" alt=\"\" width=\"250\" height=\"165\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 14px; color: #4a771d; font-weight: bold;\">E.-2- DIFFERENTS TYPES DE CONTRAT</span></p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%; vertical-align: middle; border-width: 0px;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold;\">E.-2-1- CONTRATS A REMUNERATION FORFAITAIRE</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Durée de la mission clairement définie</li>\r\n<li>Prestations des consultants clairement définies</li>\r\n<li>Paiements liés aux prestations (rapports, documents,… )</li>\r\n</ol><span style=\"color: #2a3215;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Contrat facile à administrer: prestations bien spécifiées.</span></span></td>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"font-weight: bold; color: #4a771d;\">E.-2-2- CONTRATS AU POURCENTAGE</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Société de surveillance, agents, spécialistes</li>\r\n<li>Honoraires liés au coût des marchandises achetées ou inspectées</li>\r\n</ol><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; color: #4a771d;\">Contrats négociés sur la base de normes applicables au service et/ou taux de rémunération exprimé en personnes/mois</span></td>\r\n</tr>\r\n<tr>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold;\">E.-2-3- CONTRATS REMUNERES AU TEMPS PASSE</span></h2>\r\n<span style=\"color: #2a3215;\"><span style=\"color: #2a3215;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">  Lorsqu’il est difficile de déterminer l’étendue et la durée des <br />  services (liés à d’autres services), par exemple études <br />  complexes, supervision de travaux.</span></span></span><ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li> Rémunération sur la base de taux unitaires agréés (journaliers, hebdomadaires, mensuels, … )</li>\r\n<li>Frais remboursables ; dépenses effectives ou prix unitaires convenus</li>\r\n<li>Rémunération (inclus salaire, charges sociales, profit)</li>\r\n<li>« montant plafonné » avec disposition pour tenir compte des difficultés d’exécution (possiblement clause de révision des prix)</li>\r\n</ol><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify; color: #4a771d;\">Contrat devant être administré de près pour s’assurer que les paiements facturés sont effectivement corrects.</span></td>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #4a771d;\"><span style=\"font-weight: bold;\">E.-2-4- CONTRATS A QUANTITE INDETERMINEE</span><br /></span><span style=\"color: #2a3215;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">   Contrats utilisés lorsque l’ampleur / la périodicité / le calendrier <br />   des prestations sont difficiles à déterminer</span></span></p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Services rendus à la demande.</li>\r\n<li>Taux de rémunération agréés à l’avance</li>\r\n<li>Rémunération au temps effectivement passé</li>\r\n</ol></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 45%; border-width: 0px;\">\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"color: #4a771d;\"><span style=\"font-weight: bold;\">E.-3- DOCUMENTS CONTACTUELS</span> (PAR ORDRE DE </span><br /><span style=\"color: #4a771d;\">          PRESEANCE)</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>La convention</li>\r\n<li>La lettre d’acceptation</li>\r\n<li>L’offre et ses annexes</li>\r\n<li>Le bordereau des prix et le devis quantitatif et estimatif</li>\r\n<li>Le sous-détail des prix</li>\r\n<li>Le cahier des clauses administratives particulières</li>\r\n<li>Le cahier des clauses administratives générales</li>\r\n<li>Les spécifications techniques et les plans</li>\r\n<li>Autres documents</li>\r\n</ol></td>\r\n<td style=\"width: 50%; border-width: 0px;\">\r\n<h2 style=\"font-size: 12px; font-family: Arial, Helvetica, sans-serif; line-height: normal; color: #2a286b; text-align: justify;\"><span style=\"color: #4a771d; font-weight: bold;\">E.-4- CONTRATS D’APPROVISIONNEMENT</span></h2>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Définition des caractéristiques techniques du ou des prix unitaires</li>\r\n<li>Préparation du formulaire descriptif des quantités et des prix unitaires</li>\r\n<li>Préparation d’un modèle de contrat à annexer à la demande</li>\r\n<li>Définition des critères d’évaluation des offres pondérées à recevoir</li>\r\n<li>Préparation du courrier de demande de cotation</li>\r\n<li>Envoi simultané des courriers avec copies pour accusé de <br />réception</li>\r\n<li>Désignation du comité d’évaluation des cotations</li>\r\n<li>Réception et évaluation des cotations.</li>\r\n</ol></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #4a771d; font-weight: bold;\">E.-5- DIFFERENTS TYPES DE GARANTIES / CAUTIONS DE GARANTIE</span></p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Garantie de l’offre ou de soumission</li>\r\n<li>Garantie de bonne exécution</li>\r\n<li>Garantie de remboursement de l’avance</li>\r\n<li>Garantie bancaire en lieu et place de la retenue de garantie</li>\r\n</ol>\r\n<p> </p>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:10:15', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '17', '', '', '1', '7', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('243', '292', 'Avis de recrutement', 'avis-de-recrutement', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 33%;\">\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 34%;\">\r\n<p> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 33%;\">\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:11:11', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '0', '16', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('244', '293', 'Projets', 'projets', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p style=\"text-align: justify;\"><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les projets retenus au Bureau de Monétisation sont financés à partir de fonds mis à la disposition de l’Etat haïtien par différents bailleurs, à travers des accords de don ou de prêt.  Ainsi, le financement d’un projet par un bailleur spécifique repose sur les principaux axes prioritaires définis conjointement avec le Gouvernement haïtien.</span><span style=\"font-size: 13px;\"> </span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<p>{gallery width=400 heigt=400 slideshow=4000  buttons=0}/sampledata/rea_bmpad/budget_invest_bmpad{/gallery}</p>', '', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-26 20:34:20', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '25', '0', '7', '', '', '1', '77', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `y43zw_content` VALUES ('245', '294', 'Critères d\'éligibilité des Projets', 'criteres-eligibilite-projets', '', '<h2 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; line-height: normal; text-align: left;\"><span style=\"color: #000000;\">Le choix des projets financés par le BMPAD repose sur un certain nombre de critères.</span><span style=\"color: #75bd2e; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 22px;\"> </span></h2>\r\n<h1 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: left;\"><span style=\"color: #a6bd65; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 20px;\">Introduction des projets</span></h1>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">L’introduction ou dépôt d’un projet au BMPAD doit se faire soit par le Ministère <span style=\"font-size: 12px;\">concerné par le projet soit par une Organisation Non-Gouvernementale (ONG).</span></p>\r\n<h1 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: left;\"><span style=\"color: #a6bd65; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 20px;\">Conditions d’éligibilité des projets</span></h1>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">Pour qu’il soit éligible, un projet doit comprendre :</p>\r\n', '\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\"> </p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"disc\">\r\n<li style=\"text-align: left;\">La promotion de la sécurité alimentaire ;</li>\r\n<li style=\"text-align: left;\">La promotion de la facilité d’accès aux produits alimentaires par la création d’emplois à court terme et l’augmentation de revenus ;</li>\r\n<li style=\"text-align: left;\">La réhabilitation d’infrastructures productives ;</li>\r\n<li style=\"text-align: left;\">Le développement agricole soutenable, équitable et à champ d’action étendu ;</li>\r\n<li style=\"text-align: left;\">La promotion du marché libre et ouvert ;</li>\r\n<li style=\"text-align: left;\">Le développement d’infrastructures routières, agricoles, sociocommunautaires, ect..</li>\r\n</ul>\r\n<h1 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: left;\"><span style=\"color: #a6bd65; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 20px;\">Choix des projets</span></h1>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">Pour être choisi, un projet doit :</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: left;\">entrer dans le cadre des programmes sectoriels de développement prévus par le ministère technique concerné ;</li>\r\n<li style=\"text-align: left;\">satisfaire aux exigences du bailleur ou programme considéré.</li>\r\n</ul>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">Aucun projet ne peut être choisi sur une base d’affiliation politique, de race, de sexe, de localisation géographique, d’identité ethnique ou religieuse.<br />Toutefois, dépendamment des fonds disponibles, les projets choisis peuvent soit être exécutés immédiatement soit être mis en attente de financement futur.</p>\r\n<p style=\"text-align: left;\"> </p>', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-26 19:24:06', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '10', '0', '6', '', '', '1', '16', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('246', '295', 'Projets priorisés', 'projets-priorises', '', '<h2><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\">Une considération prioritaire est accordée aux projets :</span></h2>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"disc\">\r\n<li><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px;\"> </span><span style=\"font-size: 12px;\"><span style=\"font-size: 12px;\"><span style=\"font-size: 12px;\">Fournissant des travaux à haute intensité de main d’œuvre susceptibles de générer des emplois </span></span></span><span style=\"font-size: 12px;\"><span style=\"font-size: 12px;\"><span style=\"font-size: 12px;\">à court terme au profit des couches les plus défavorisées de la population ;</span></span></span></li>\r\n<li style=\"text-align: left;\">Fournissant des travaux et des résultats visibles ;', '</li>\r\n<li style=\"text-align: left;\">Pouvant être exécutés efficacement et</li>\r\n<li style=\"text-align: left;\">Améliorant la participation des populations bénéficiaires</li>\r\n<li style=\"text-align: left;\">au processus de prise de décisions démocratiques ;</li>\r\n<li style=\"text-align: left;\">Contribuant au développement socio-économique du pays ;</li>\r\n<li style=\"text-align: left;\">Réduisant la vulnérabilité des communautés et améliorant la sécurité alimentaire de la population.</li>\r\n</ul>\r\n<p> </p>\r\n<h2>Secteurs prioritaires</h2>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">La priorité est accordée aux projets relevant des domaines suivants :</p>\r\n<ol style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" type=\"1\" start=\"1\">\r\n<li style=\"text-align: left;\">Travaux publics (routes, ponts, port, infrastructures communautaires, ….)</li>\r\n<li style=\"text-align: left;\">Agriculture / environnement (systèmes d’irrigation, bassins versants, banques d’intrants, …..)</li>\r\n<li style=\"text-align: left;\">Santé (réhabilitation de centres de santé primaire)</li>\r\n<li style=\"text-align: left;\">Education (construction et réhabilitation d’écoles)</li>\r\n</ol>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: left;\"><span style=\"color: #4a771d;\">Secteurs prioritaires par bailleur</span> <span class=\"legende\" style=\"font-size: 9px; margin-top: 5px;\"><a href=\"../partenaires/accords-bilateraux\">(Voir partenaires bilatéraux)</a></span></h3>', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-26 19:25:15', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '17', '0', '5', '', '', '1', '27', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('247', '296', 'Exécution des projets', 'execution-des-projets', '', '<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">La mise en oeuvre des projets est réalisée par :<span style=\"font-size: 12px;\"> </span></p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li style=\"text-align: left;\">un organe déconcentré de l’Etat ou</li>\r\n<li style=\"text-align: left;\">une organisation non gouvernementale privée (ONG) ou</li>\r\n<li style=\"text-align: left;\">une firme privée choisie par appel d’offres compétitif.</li>\r\n</ul>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: left;\">Des firmes de supervision choisies aussi par appel d\'offres assurent le suivi et la bonne exécution des travaux.</p>', '', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-26 19:23:36', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '0', '4', '', '', '1', '10', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('248', '297', 'Programme à Impact Communal', 'programme-impact-communal', '', '<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le Programme à Impact Communal (PIC) se situait dans le prolongement et le renforcement des initiatives du Gouvernement en vue de répondre, au plus vite, aux besoins les plus urgents des populations les plus démunies.</p>\r\n', '\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"> Les projets dans le cadre du PIC, visant à compléter le paquet minimum de services offerts à ces populations, ont été mis en œuvre dans les dix (10) départements du pays et toucheront les secteurs de l’éducation, de l’eau potable et assainissement, de la santé, des infrastructures agricoles et routières, de la protection de l’environnement, de la jeunesse, action civique et sports.</p>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le BMPAD a agit comme agence d’exécution du PIC.</p>', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-27 16:53:04', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '0', '3', '', '', '1', '13', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('249', '298', 'Programme Appui aux Communes', 'programme-appui-aux-communes', '', '<h3 style=\"color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: -webkit-left;\"><span style=\"font-family: Arial; font-size: 16px; font-weight: bold;\"><span style=\"color: #365615;\">PROGRAMME POST-DESASTRES SEPTEMBRE 2008 </span><br /><span style=\"color: #365615;\">VOLET APPUI AUX COMMUNES</span></span></h3>\r\n<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<p style=\"font-size: 12px;\">Un Protocole d’Accord pour le financement de certaines activités du Programme Post-Désastres 2008, entre le Ministère de l’Intérieur et des CollectivitésTerritoriales (MICT) et le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD) a été signé le 8 octobre 2008 pour la mise en œuvre du Volet Appui aux Communes.</p>\r\n', '\r\n<p style=\"font-size: 12px;\">Ce Protocole a été approuvé par le Ministère de l’Economie et des Finances.</p>\r\n<p style=\"font-size: 12px;\"> </p>\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">CRITERES  D’ELIGIBILITE</span></h2>\r\n<p style=\"font-size: 12px;\">1◦        Les projets pour les communes des départements de l’Ouest, de l’Artibonite, du Sud, de la Grande-Anse et des Nippes sont présentés au Ministère de l’Intérieur et des Collectivités Territoriales (MICT par les Maires, les Députés et les Sénateurs pour financement à hauteur de Cinq (5) Millions de gourdes par commune.</p>\r\n<p style=\"font-size: 12px;\">2◦        Les projets doivent promouvoir l’utilisation de matériaux et la main d’œuvre locale ;</p>\r\n<p style=\"font-size: 12px;\">3◦        Les projets n’entraînent pas de coûts récurrents;</p>\r\n<p style=\"font-size: 12px;\">4◦        La durée d’exécution ne doit pas dépasser 6 mois;</p>\r\n<p style=\"font-size: 12px;\">5◦        Les projets doivent être viables techniquement;</p>\r\n<p style=\"font-size: 12px;\">6◦      Les projets doivent apporter des solutions  aux problèmes identifiés;</p>\r\n<p style=\"font-size: 12px;\">7◦        Les ressources disponibles doivent pouvoir financer les projets dans leur totalité à moins que ceux-ci soient trans-communaux avec l’accord des autres intéressés.</p>\r\n<p style=\"font-size: 12px;\">8◦        Le cofinancement est acceptable dans la mesure où la contrepartie est disponible  et justifiée.</p>\r\n<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b;\"><span style=\"color: #4a771d; font-weight: bold; font-size: 14px;\">PROCEDURES</span></h2>\r\n<p style=\"font-size: 12px;\">1◦        Les demandes de projets sont déposés au MICT ;</p>\r\n<p style=\"font-size: 12px;\">2◦        Le MICT applique les critères d’éligibilité et procède à une pré-évaluation ;<br />            <br />3◦        Le MICT transmet au BMPAD, le Document du Projet convenablement paraphé par les Demandeurs et le(s) exécutant(s) identifié(s);</p>\r\n<p style=\"font-size: 12px;\">4◦        Le BMPAD évalue techniquement et financièrement le(s) projet(s);</p>\r\n<p style=\"font-size: 12px;\">5◦        Le BMPAD évalue le(s) exécutant(s) proposé(s) et le cas échéant signe le contrat  avec ce(s) dernier(s) en appliquant les procédures en vigueur (CNMP). Le BMPAD engage des superviseurs immédiats de travaux à partir des fonds alloués au(x) projet(s).</p>\r\n<p style=\"font-size: 12px;\">6◦        Le BMPAD s’assurera de la bonne exécution du projet avant le décaissement des seconde et troisième tranches.<br />            <br />7◦        Le BMPAD communique au MICT la situation financière du Volet Appui aux Communes de façon hebdomadaire.</p>\r\n<p style=\"font-size: 12px;\">N.B. : Le FAES est responsable du financement de projets  dans les communes des départements du Nord, du Nord-Est, du Nord-Ouest, du Centre et du Sud-Est.</p>\r\n</div>\r\n<p>{gallery count=3}/sampledata/rea_bmpad/album_pac_2008{/gallery}</p>', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-25 19:50:03', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '13', '0', '2', '', '', '1', '32', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('250', '299', 'Programme Investissement Public', 'programme-investissement-public', '', '<p><span style=\"text-align: justify;\">Les programmes annuels d\'investissement public (PIP) regroupent les projets d\'investissement mis en œuvre par année budgétaire. Chacun d\'eux est inclus au budget annuel correspondant, lequel doit matérialiser la politique et la vision de développement du pays des autorités nationales.</span></p>\r\n', '\r\n<p> </p>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p><iframe src=\"http://www.youtube.com/embed/Cycd8HuzcC8?wmode=transparent&amp;amp;wmode=transparent\" width=\"350\" height=\"362\"></iframe></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p><iframe src=\"http://www.youtube.com/embed/VT7ANsoo7HQ?wmode=transparent\" width=\"350\" height=\"362\"></iframe></p>\r\n</div>\r\n</div>\r\n</div>', '1', '0', '0', '24', '2014-05-26 13:31:57', '69', '', '2014-06-25 21:56:44', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '12', '0', '1', '', '', '1', '72', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('251', '300', 'Plan du site', 'article-43', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <p><span style=\"font-weight: bold;\">Ipsum amet fringilla et ultrices phasellus ornare euismod viverra accumsan phasellus ligula molestie eu ut magna augue id eget orci.</span></p><p>Nisi ante dictumst purus metus dolor quis at tellus et. Lectus a curabitur pede praesent habitasse netus nam vitae ligula ut quam tempor nisi in egestas id suscipit. nunc vel ligula dapibus iaculis nunc ipsum est nunc et praesent. Non eu phasellus ac nullam auctor quam scelerisque jnteger nec id cursus.</p><p><a href=\"http://www.google.com\">Google.com</a><br>Suscipit urna leo leo ligula viverra ligula ut pede et. Eget ut sed pretium ante eu mi condimentum amet sapien orci nascetur ante quis ac netus consectetuer in orci. Turpis velit vestibulum augue laoreet quis neque mollis metus at.</p><p><a href=\"http://www.yahoo.com\">Yahoo.com</a><br>Augue sem varius tempus lorem non in mi tortor nunc mi. Ipsum orci netus ut rhoncus nullam orci a vestibulum tempus odio donec vel mauris amet rutrum duis dictum sed. Nunc condimentum pretium consectetuer nam egestas donec orci nec.</p><p><a href=\"http://www.artisteer.com\">Artisteer.com</a><br>Quam in porta metus tellus et nulla eget posuere justo. Vel vestibulum varius lacus nec ipsum orci fusce faucibus ligula enim adipiscing neque volutpat ridiculus nisi. Dui turpis eu mollis dolor odio pede eros ultricies cras aliquam.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '15', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('252', '301', 'Photos', 'photos', '', '<h1>ALBUM PHOTO BMPAD</h1>\r\n<h2>ALBUM PAC</h2>\r\n<p>{gallery}/sampledata/rea_bmpad/album_pac_2008{/gallery} </p>\r\n<h2><span style=\"font-size: 22px;\">ALBUM</span> BMPAD</h2>\r\n<p>{gallery}/sampledata/rea_bmpad/bmpad_all{/gallery}</p>\r\n<p><span style=\"color: #75bd2e; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 22px; line-height: 26.399999618530273px;\">ALBUM BUDGET INVESTISSEMENT</span></p>\r\n<p>{gallery}/sampledata/rea_bmpad/budget_invest_bmpad{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\">ALBUM</span> BANQUE MONDIALE</h2>\r\n<p>{gallery}/sampledata/rea_bmpad/fn_bm{/gallery}</p>\r\n<p><span style=\"color: #75bd2e; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 22px; line-height: 26.399999618530273px;\">ALBUM</span><span style=\"color: #75bd2e; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 22px; line-height: 26.399999618530273px;\"> PETROCARIBE</span></p>\r\n<p>{gallery}/sampledata/rea_bmpad/fn_petrocaribe{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\">ALBUM INFRASTRUCTURES SCOLAIRES</span></h2>\r\n<p>{gallery}/sampledata/rea_bmpad/pip{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\">ALBUM</span> FONDS COMMUNAUX</h2>\r\n<p>{gallery}/sampledata/rea_bmpad/fonds_communaux{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\"><span style=\"font-size: 22px;\">ALBUM</span> JAPON : LYCEE BELLADERES</span></h2>\r\n<p>{gallery}/sampledata/rea_bmpad/japon_lycee_belladeres{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\"><span style=\"font-size: 22px;\">ALBUM</span> PREKAD</span></h2>\r\n<p>{gallery}/sampledata/rea_bmpad/prekad{/gallery}</p>\r\n<h2><span style=\"font-size: 22px;\">ALBUM</span> PRODEPUR-HABITAT</h2>\r\n<p>{gallery}/sampledata/rea_bmpad/prodepur-habitat{/gallery}</p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:10:32', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '19', '0', '14', '', '', '1', '83', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('253', '302', 'Blog', 'article-45', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"border-top-style:solid;border-right-style:solid;border-bottom-style:solid;border-left-style:solid;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px;border-top-color:#F4F28A;border-right-color:#F4F28A;border-bottom-color:#F4F28A;border-left-color:#F4F28A; color: #1E240F; background: #FBFAD5; padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <h3>About</h3><p><span style=\"font-weight: bold;\">Tincidunt sem urna turpis vulputate ligula nisl nunc suspendisse. </span></p><p>Pellentesque ut vitae sagittis turpis neque libero donec sagittis adipiscing at in praesent dis molestie et. Odio nec hac sit quis sed urna.</p><div class=\"clearfix\">\r\n            <div class=\"image-caption-wrapper\" style=\"width: 50%; float: left\"><img src=\"images/template-content/shutterstock_62287657-03-5.jpg\" style=\"width: 100%; max-width:360px\" alt=\"an image\" class=\"bmpad-lightbox\"></div>\r\n            <div class=\"image-caption-wrapper\" style=\"width: 50%; float: left\"><img src=\"images/template-content/shutterstock_12488026.jpg\" style=\"width: 100%; max-width:360px\" alt=\"an image\" class=\"bmpad-lightbox\"></div>\r\n        </div>\r\n    </div>\r\n    </div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"border-top-style:solid;border-right-style:solid;border-bottom-style:solid;border-left-style:solid;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px;border-top-color:#F4F28A;border-right-color:#F4F28A;border-bottom-color:#F4F28A;border-left-color:#F4F28A;border-top:none !important; padding-right: 10px;padding-left: 10px; width:50%\" >\r\n        <h3>New Methods</h3><p><span style=\"font-weight: bold;\">Et sed ut vestibulum  praesent semper mollis nulla  purus at justo.</span></p><ul>\r\n            <li><span style=\"font-weight: bold;\">Quis risus erat est.</span><br>Libero nascetur vitae metus cubilia. Magna dictum libero in.</li>\r\n            <li><span style=\"font-weight: bold;\">Turpis ut pretium. </span><br>Blandit tellus mi eu odio nunc nunc. Primis at et convallis.</li>\r\n            <li><span style=\"font-weight: bold;\">Metus volutpat nunc.</span><br>Placerat cursus accumsan laoreet in. Lorem pretium blandit. </li>\r\n            <li><span style=\"font-weight: bold;\">Tortor nonummy orci.</span><br>Purus varius laoreet et metus ipsum. Eget ante euismod eget.</li>\r\n        </ul><p><a href=\"#\" class=\"bmpad-button\">Read more →</a></p>\r\n    </div><div class=\"bmpad-layout-cell\" style=\"border-top-style:solid;border-right-style:solid;border-bottom-style:solid;border-left-style:solid;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px;border-top-color:#F4F28A;border-right-color:#F4F28A;border-bottom-color:#F4F28A;border-left-color:#F4F28A;border-top:none !important; color: #1E240F; background: #FBFAD5; padding-right: 10px;padding-left: 10px; width:50%\" >\r\n        <h3>Hello!</h3><p><span style=\"font-weight: bold;\">Ut venenatis hendrerit ante donec amet enim adipiscing pede cras. </span></p><p><span style=\"font-weight: bold;\">Faucibus venenatis pretium sem sagittis nascetur praesent a ornare.</span></p><p>Massa mattis tincidunt ultrices pede sit urna a rutrum. Cum nulla in eu orci sed pede senectus tellus nostra. Mi a cras nunc quis. Sem jnteger faucibus lacinia vestibulum elit velit phasellus. A est id eget quis. Blandit vitae quam dapibus sem vestibulum fusce eros nunc nunc in.  Quisque sagittis vestibulum dolor nisl augue. Nisi quis ante et molestie congue faucibus lacus. Congue tellus purus consectetuer adipiscing quis in.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"border-top-style:solid;border-right-style:solid;border-bottom-style:solid;border-left-style:solid;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px;border-top-color:#F4F28A;border-right-color:#F4F28A;border-bottom-color:#F4F28A;border-left-color:#F4F28A;border-top:none !important; color: #1E240F; background: #FBFAD5; padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <h3>Introduction</h3><ul>\r\n            <li><h5>Introduction</h5>Eget ante libero at phasellus velit. Tincidunt pellentesque.</li>\r\n            <li><h5>Welcome</h5>Elit phasellus aenean porttitor sit. Porttitor arcu posuere.</li>\r\n            <li><h5>What We Do</h5>Tincidunt volutpat ullamcorper pede. Auctor nulla duis nisi.</li>\r\n        </ul><p><a href=\"#\" class=\"bmpad-button\">Read more →</a></p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '13', '', '', '1', '3', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('254', '303', 'A propos de BMPAD', 'article-46', '', '\n            <div class=\"bmpad-content-layout\">\r\n    <div class=\"bmpad-content-layout-row\">\r\n    <div class=\"bmpad-layout-cell\" style=\"padding-right: 10px;padding-left: 10px; width:100%\" >\r\n        <p><img alt=\"\" width=\"340\" height=\"227\" src=\"images/template-content/shutterstock_40335370.jpg\" style=\"float: left;\" class=\"\"></p><p><span style=\"font-weight: bold;\">Sagittis purus justo fringilla posuere accumsan metus mi iaculis facilisis ac ante. Fringilla mauris metus curae enim taciti rhoncus sem donec mollis at.</span></p><p>Enim augue orci morbi orci ac amet sagittis erat vitae. Et pellentesque suspendisse phasellus at eu donec sed faucibus ante tincidunt in suspendisse vestibulum tortor.</p><p>Fusce lectus odio sem ac adipiscing adipiscing sagittis nibh est. Libero amet eleifend congue. Adipiscing vestibulum magna vivamus sed sapien amet sed hac ipsum. Fringilla eget augue congue sagittis non per.</p><p>Purus blandit turpis elementum amet velit dapibus eget nisi tempor augue. A curae viverra amet in eu viverra pellentesque augue. Diam molestie a felis eget ac dui. Nulla phasellus nisi. Eros suspendisse primis feugiat vitae hendrerit cras vitae sagittis ipsum. Metus sed lobortis ut pellentesque hendrerit sed phasellus. Id sapien in mi eget mollis amet. Vestibulum libero et magnis non. Vestibulum lacinia vel.</p><p>Amet nec vestibulum libero mollis adipiscing. Volutpat maecenas vestibulum commodo. Nec at adipiscing mauris ante arcu enim adipiscing mattis et. Laoreet a nunc odio tortor nec accumsan lorem. Mauris ac nisl tellus blandit tellus bibendum. A est quisque a magna quis justo ut. Elementum viverra aenean phasellus hendrerit accumsan velit malesuada. Ut lobortis nam cras dapibus quis pulvinar. Consectetuer aliquam ante feugiat porttitor. elit odio tristique pretium risus metus neque et. Arcu turpis libero tellus. ipsum velit sagittis ullamcorper.</p><p>Lectus nisl quisque adipiscing convallis odio volutpat. Ut nunc lacinia eu nulla iaculis nonummy sed donec ut pretium dolor. Venenatis nisl iaculis a cras lobortis quisque mauris vitae. Nisi velit suspendisse nisi platea a lacus nulla lorem ac. Fringilla sed ipsum metus laoreet suscipit scelerisque eget ligula. Tempor porttitor eget rhoncus posuere aenean pretium nec. Elit nam per cras ligula quis vitae quis venenatis vivamus. Elementum praesent ac et elit in quam et odio. Dolor et metus elit. Amet curae ut ut ut ante id et vitae ac ut. Sagittis mattis condimentum velit sit. Eleifend faucibus luctus nunc elementum ac. Sed lobortis imperdiet volutpat id pulvinar in. Egestas aenean posuere. Tellus ut tristique auctor tellus lacus. Magna platea dolor eget eget. Nostra libero condimentum cursus pellentesque auctor lacus magna. Nisl primis sollicitudin est neque.</p><p>Nisi in faucibus viverra volutpat justo id eu risus nec sed donec facilisi eu cras odio vel purus augue tellus nulla dolor dapibus ut mauris eget netus posuere eros enim suscipit lorem rutrum magna fermentum suscipit iaculis condimentum eget dui volutpat duis libero donec vestibulum sem eros eu sagittis hendrerit aliquet sem mi sem sem nunc velit mi velit quam velit varius ut felis eu aenean eleifend ut mi felis arcu ut varius placerat lobortis lacus in vestibulum ligula pellentesque augue imperdiet a leo eros eget nisi a praesent ultricies pede quam justo faucibus enim nisl vel donec quis turpis curae tincidunt non.</p>\r\n    </div>\r\n    </div>\r\n</div>\r\n\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '12', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('255', '304', 'News', 'article-47', '', '\n            <p><span style=\"color: rgb(51, 0, 255); font-weight: bold;\">Les infos de BMPAD</span></p>\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '12', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('256', '305', 'Info1', 'article-48', '', '\n            <p>Info1 de bmpad<br></p>\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '11', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('257', '306', 'Info2', 'article-49', '', '\n            <p>Info2 de bmapd<br></p>\n        \n        ', '', '-2', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '10', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('258', '307', 'Publications', 'article-50', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '11', '', '', '1', '7', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('259', '308', 'Etudes et Réalisations', 'article-51', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '10', '', '', '1', '7', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('260', '309', 'Appels d\'offre', 'article-52', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '9', '', '', '1', '3', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('261', '310', 'Avis de recrutement', 'article-53', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '8', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('262', '311', 'Documents à télécharger', 'article-54', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '7', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('263', '312', 'Multimédia', 'article-55', '', '\n            <p><br></p>\n        \n        ', '', '0', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-05-26 13:31:57', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '0', '6', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"tags\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('264', '313', 'Actualités', 'actualites', '', '<p><strong style=\"color: #efefef; font-family: arial, helvetiva; font-size: 12px;\"><span style=\"color: #ff0066;\"><strong style=\"font-family: arial, helvetiva; font-size: 12px; font-weight: normal; color: #000000;\"><a id=\"divNewsObjectlink\" href=\"petrocaribe.html\" target=\"_self\" style=\"font-family: arial, helvetiva; font-size: 12px; font-weight: normal; color: #000000;\">Au 31 mai 2014,<br /><span style=\"color: #0099ff;\">environ 30 millions de barils de produits pétroliers ont été recus en Haïti dans le cadre de l\'Accord PetroCaribe.</span></a><br /></strong></span></strong></p>\r\n<p><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #ff0066;\">Appel d\'offres en cours pour la c</span></strong><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #ff0066;\">onstruction du lycée Lathème de Mirebalais.  DAO à récupérer au BMPAD jusqu\'au 4 juillet 2014.</span></strong></p>\r\n<p><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><span style=\"color: #0099ff;\">Construction du Lycée Sténio Vincent de Cerca-la-Source et Lycée national de Thomassique financés par le Japon en cours de lancement.</span></strong></p>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 16:52:29', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '13', '0', '5', '', '', '1', '75', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('265', '314', 'Contacts', 'contacts', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"padding-right: 10px; padding-left: 3px; vertical-align: middle; width: 60%;\">\r\n<p style=\"text-align: right;\"><strong>Bureau de Monétisation </strong><br /><strong>des Programmes d\'Aide au Développement </strong><br /><strong>BMPAD</strong></p>\r\n<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; padding-left: 15px; text-align: right;\">\r\n<p><span style=\"color: #4a771d;\">12bis, Blvd. Harry Truman</span><br /><span style=\"color: #4a771d;\">Boite postale 2488</span><br /><span style=\"color: #4a771d;\">Port-au-Prince, Haiti</span></p>\r\n</div>\r\n<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; margin-left: 30px; margin-right: 10px; padding-left: 35px; text-align: right;\">\r\n<p style=\"color: #000000;\"><span style=\"color: #4a771d;\">Tél. (509) 2940-8625</span><br /><span style=\"color: #4a771d;\">        (509) 2940-8031</span><br /><span style=\"color: #4a771d;\">        (509) 2813-0933<br /> (509) 2813-1967<br /><br /></span><span style=\"color: #4a771d;\">Mail. info@bmpad.gouv.ht</span></p>\r\n</div>\r\n<p> </p>\r\n<p><a href=\"contacts-formulaire.html\" title=\"Prendre Contact\">N\'hésitez pas à prendre contact avec nous via notre formulaire de contact ou directement</a></p>\r\n<iframe src=\"https://mapsengine.google.com/map/embed?mid=zgSMwYtvnsKU.kZlLrQrtT-Hg\" width=\"670\" height=\"480\"></iframe> <br /><small>Afficher <a href=\"https://www.google.fr/maps/ms?ll=18.545331,-72.338276&amp;spn=0.033526,0.055747&amp;t=m&amp;z=15&amp;msa=0&amp;msid=211721672410309478491.0004fb6dc3bd59e91a845&amp;source=embed\" target=\"_blank\" style=\"color: #0000ff; text-align: left;\">BMPAD</a> sur une carte plus grande</small></div>\r\n<div class=\"bmpad-layout-cell\" style=\"padding-right: 10px; padding-left: 10px; width: 40%;\">\r\n<p><img class=\"bmpad-lightbox\" src=\"images/template-content/LOGOBMPAD1-2.jpg\" border=\"0\" alt=\"\" width=\"208\" height=\"208\" /></p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 16:54:25', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '27', '0', '4', '', '', '1', '91', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('266', '317', 'Monétisation en cours news', 'article-58', '', '<h2 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; line-height: normal; text-align: justify;\"><span style=\"color: #365615; font-size: 14px;\">  <span style=\"color: #4a771d; font-weight: bold;\">LA MONETISATION DU RIZ</span></span><a href=\"index.php?option=com_content&amp;view=article&amp;id=225&amp;Itemid=295\" style=\"font-size: 12px;\">     VIETNAMIEN \"10 SOU 10\"</a></h2>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 75%; border-width: 0px;\"><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Un montant de Vingt Millions de dollars américains, à partir des fonds <a href=\"index.php?option=com_content&amp;view=article&amp;id=232&amp;Itemid=302\">PetroCaribe</a>, a été alloué au Programme de stabilisation des prix, permettant ainsi l\'acquisition de produits de première nécessité, notamment le riz vietnamien. <br /><br />Le riz 10 SOU 10 a contribué, de mars 2013 à date, à stabiliser les prix de cette denrée sur le marché et a permis de lutter contre \"la vie chère\".<br /><br />Le Bureau de Monétisation des Programmes d\'Aide au Développement (BMPAD) a déjà reçu quatre commandes du riz vietnamien 10 SOU 10, totalisant 66,000 TM. Les deux premières commandes étaient de 15,000 TM chacune (récolte 2012/2013). La troisième et la quatrième de 18 000 TM chacune (récolte 2013). Les troisième et quatrième cargaisons ont été reçues respectivement le 18 octobre 2013 et le 18 décembre 2013. <br /></span><br />\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Les prix de vente pratiqués pour les deux (2) catégories des acheteurs ont été comme suit:</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>Catégorie I (de 20,000 sacs de 25 kg @ 30,000 sacs) : 726 gdes/sac</li>\r\n<li>Catégorie II (de 5,000 sacs de 25 kg @ 10,000 sacs) : 751 gdes/sac</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 75%; border-width: 0px;\"><img class=\"bmpad-lightbox\" src=\"images/template-content/LOGODURIZ.jpg\" border=\"0\" alt=\"\" width=\"198\" height=\"291\" style=\"float: right;\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Il est à noter que les valeurs C &amp; F des 4 cargaisons sont les suivantes:</p>\r\n<ul style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">\r\n<li>1ère : US$ 509.00/TM</li>\r\n<li>2ème : US$ 504.00/TM</li>\r\n<li>3ème : US$ 493.00/TM</li>\r\n<li>4ème : US$ 475.00/TM</li>\r\n</ul>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"color: #365615; font-size: 14px;\">Les ventes</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le produit des ventes de 452,170 sacs provenant de la 3ème cargaison, se chiffre à 325,168,250.00 gourdes. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Réception 4ème cargaison</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Au 18 décembre 2013, date d\'arrivée de la quatrième cargaison de 18,000 ™ (720,000 sacs de 25 kg), il existait une balance théorique non vendue de 267,830 sacs provenant de la troisième cargaison.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; font-weight: bold; color: #4a771d;\">Situation de mévente</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">La lenteur dans les livraisons et une situation de mévente généralisée ont été notées à partir de la commercialisation de la 3ème cargaison du riz 10 SOU 10. Ceci est dû, selon les enquêtes menées auprès des commerçants, par : </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">a) le changement de stratégie de vente du BMPAD qui a vendu le produit aux grossistes au lieu des importateurs, comme cela avait été fait pour les 2 premières cargaisons;</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">b) une augmentation de la quantité de riz disponible sur le marché local. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">c) une baisse générale de prix enregistrée dès la mi-octobre au niveau des différentes marques de riz sur le marché local.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">d) la qualité du riz vietnamien de la 3ème cargaison jugée un peu inférieure à celle des deux premières cargaisons.</span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /></p>\r\n<h3 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 20px; line-height: normal; text-align: justify;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Réactions du BMPAD pour améliorer les ventes</span></h3>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Vu la quantité de sacs non encore écoulée, le BMPAD décida, pour améliorer la situation des ventes, de réduire le prix de vente du riz de la 3ème cargaison. Ce prix de vente passa de 726 gdes le sac de 25 kg à 710 gdes. Les acheteurs ont eu à bénéficier d\'une compensation en sacs proportionnelle aux quantités qu\'ils avaient achetées. </span><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><br style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\" /><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Le BMPAD a repris depuis la fin du mois de décembre une publicité agressive avec les stations de radio sur le riz 10 SOU 10 en vue de \"booster\" les ventes.</span></p>', '', '0', '0', '0', '18', '2014-05-26 13:31:57', '69', '', '2014-06-09 17:13:09', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/template-content\\/LOGODURIZ-large.jpg\",\"float_intro\":\"right\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"0\",\"show_urls_images_frontend\":\"0\"}', '6', '0', '0', '', '', '1', '10', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('267', '319', 'PREKAD', 'prekad', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span style=\"font-size: 14px; color: #4a771d;\" lang=\"FR-HT\">PROJET DE RECONSTRUCTION DES QUARTIERS DEFAVORISES DE PORT-AU-PRINCE (PREKAD)</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px; text-align: justify;\">Après le tremblement de terre qui a sévèrement frappé la capitale haïtienne et ses zones environnantes, le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD) a été désigné par l’Etat haïtien et la Banque Mondiale pour mettre en œuvre deux grands projets de reconstruction de certains quartiers de Port-au-Prince, il s’agit du Projet de Reconstruction des Quartiers Défavorisés (PREKAD) et du Projet de Développement Communautaire Participatif en Milieu Urbain (PRODEPUR Habitat). Le montant global des deux projets s’élève à 95 millions de dollars américains.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><a href=\"http://misucp.bmpad.net/mis%20system/grid_descriptionprojetsprodepurhabitat_1/grid_descriptionprojetsprodepurhabitat_1.php\" target=\"_blank\" title=\"RAPPORT DYNAMIQUE\">SYSTEME D\'INFORMATION PREKAD</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout-wrapper layout-item-0\">\r\n<div class=\"bmpad-content-layout layout-item-1\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span style=\"font-size: 14px; color: #4a771d;\" lang=\"FR-HT\">Objectif du PREKAD</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 13px;\">L’objectif de développement du PREKAD est de faciliter le retour dans leur communautés des résidents de quartiers sélectionnés de Port-au-Prince gravement touchés par le tremblement de terre, en les aidant à réparer ou reconstruire leurs maisons et en améliorant l’infrastructure des services communautaires de base.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"> </p>\r\n<div class=\"bmpad-layout-cell layout-item-2\" style=\"width: 66%;\">\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><strong><span style=\"color: #4a771d; font-size: 14px;\" lang=\"FR-HT\">Composantes</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-family: Arial;\" lang=\"FR-HT\">Composante 1 :Enlèvement de décombres et démolition et réparation/reconstruction de logements</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-family: Arial;\" lang=\"FR-HT\">Composante 2 : Réparation, amélioration et extension des infrastructures de services de base aux communautés</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-family: Arial;\" lang=\"FR-HT\">Composante 3 : Renforcement des capacités institutionnelles et études</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-family: Arial;\" lang=\"FR-HT\">Composante 4 : Gestion du projet</span></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span style=\"font-size: 12px; font-family: Arial;\" lang=\"FR-HT\"> </span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"-webkit-border-horizontal-spacing: 15px; font-size: 12px;\"><strong><span lang=\"FR-HT\">Coût :</span></strong><span lang=\"FR-HT\"> 65 millions de dollars américains</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\"><strong><span lang=\"FR-HT\">Durée : </span></strong><span lang=\"FR-HT\">4 ans</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\"><strong><span lang=\"FR-HT\">Financement : </span></strong><span lang=\"FR-HT\">Banque Mondiale</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\"><strong><span lang=\"FR-HT\">Bénéficiaires</span></strong><span lang=\"FR-HT\"> : Population en milieu urbain</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\"><strong><span lang=\"FR-HT\">Zones d’intervention : </span></strong><span lang=\"FR-HT\">Nazon, Christ-Roi, Poupelard, Simmonds Pelé, Delmas 32 et Carrefour Feuilles.</span></span></p>\r\n{phocadownload view=file|id=4|target=s} {phocadownload view=file|id=17|target=s} {phocadownload view=file|id=19|target=s}</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:13:56', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '20', '0', '3', '', '', '1', '57', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('268', '320', 'PRODEPUR Habitat', 'prodepur-habitat', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"text-align: left;\"><span lang=\"FR-HT\"><span style=\"font-weight: bold; color: #4a771d; font-size: 14px;\">PROJET DE DEVELOPPEMENT COMMUNAUTAIRE PARTICIPATIF EN MILIEU URBAIN - FINANCEMENT ADDITIONNEL<br /></span></span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"text-align: left;\"><span lang=\"FR-HT\"><span style=\"text-align: justify;\">Après le tremblement de terre qui a sévèrement frappé la capitale haïtienne et ses zones environnantes, le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD) a été désigné par l’Etat haïtien et la Banque Mondiale pour mettre en œuvre deux grands projets de reconstruction de certains quartiers de Port-au-Prince, il s’agit du Projet de Reconstruction des Quartiers Défavorisés (PREKAD) et du Projet de Développement Communautaire Participatif en Milieu Urbain - Financement Additionnel (PRODEPUR Habitat). Le montant global des deux projets s’élève à 95 millions de dollars américains.</span></span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><a href=\"http://misucp.bmpad.net/mis%20system/grid_descriptionprojetsprodepurhabitat_1_Prodepur_habitat/grid_descriptionprojetsprodepurhabitat_1_Prodepur_habitat.php\" target=\"_blank\" title=\"RAPPORT DYNAMIQUE\">SYSTEME D\'INFORMATION PRODEPUR Habitat</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout-wrapper layout-item-0\">\r\n<div class=\"bmpad-content-layout layout-item-1\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell layout-item-2\" style=\"width: 34%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span style=\"font-size: 14px; color: #4a771d;\" lang=\"FR-HT\">Objectif du PRODEPUR Habitat</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span lang=\"FR-HT\">L’objectif du PRODEPUR Habitat est d’aider les résidents des zones les plus touchées de l’aire métropolitaine de Port-au-Prince par le tremblement de terre du 12 janvier 2010, à regagner leurs communautés en toute sécurité. Le projet les aide aussi à réparer ou à reconstruire leurs logements tout en leur permettant de reprendre une activité génératrice de revenus.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"> </p>\r\n</div>\r\n<div class=\"bmpad-layout-cell layout-item-2\" style=\"width: 66%;\">\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><strong><span style=\"color: #4a771d; font-size: 14px;\" lang=\"FR-HT\">Composantes</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"padding-left: 40px;\"><span lang=\"FR-HT\">Composante 1 :<strong> </strong>Déblaiement de décombres<br /><br /></span> Composante 2 : Réparation et reconstruction de maisons<br /><br /> Composante 3: Réparation, amélioration des infrastructures communautaires<br /><br /> Composante 4 : Services consultatifs<span style=\"font-size: 13px;\"> </span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"-webkit-border-horizontal-spacing: 15px;\"><strong><span lang=\"FR-HT\">Coût :</span></strong><span lang=\"FR-HT\"> 30 millions de dollars américains</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span lang=\"FR-HT\">Durée : </span></strong><span lang=\"FR-HT\">4 ans</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span lang=\"FR-HT\">Financement : </span></strong><span lang=\"FR-HT\">Banque Mondiale</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span lang=\"FR-HT\">Bénéficiaires</span></strong><span lang=\"FR-HT\"> : Population en milieu urbain et périurbain</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><strong><span lang=\"FR-HT\">Zones d’intervention : </span></strong><span lang=\"FR-HT\">Delmas 32 et Carrefour Feuilles.</span></p>\r\n<p style=\"text-align: center;\"><iframe src=\"http://www.youtube.com/embed/SnlQUL9lT00?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"550\" height=\"350\"></iframe></p>\r\n{phocadownload view=file|id=4|target=s} {phocadownload view=file|id=14|target=s} {phocadownload view=file|id=15|target=s} {phocadownload view=file|id=18|target=s} {phocadownload view=category|id=10|target=b}</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-05-26 13:31:57', '69', '', '2014-06-27 17:09:09', '69', '0', '0000-00-00 00:00:00', '2014-05-26 13:31:57', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '21', '0', '2', '', '', '1', '70', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('269', '323', 'Projets Infrastructures Scolaires', 'projets-infrastructures-scolaires', '', '<p class=\"MsoListParagraph\" style=\"text-indent: -0.25in; padding-left: 40px;\"><strong><span style=\"font-size: 16px; color: #4a771d;\" lang=\"FR-HT\">Construction de lycées et d\'écoles</span></strong></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Les lycées construits par le Bureau de Monétisation des Programmes au Développement (BMPAD) répondent au modèle standard proposé par le Ministère de l’Education Nationale et de la Formation Professionnelle (MENFP):</span></p>\r\n<ul>\r\n<li><span style=\"font-size: 12px;\"><span style=\"color: #2a3215;\">Salles de classes de 50 m<sup>2</sup></span></span></li>\r\n<li><span style=\"font-size: 12px;\">Espaces de jeux<br /></span></li>\r\n<li><span style=\"font-size: 12px;\">Espace de restauration<br /></span></li>\r\n<li><span style=\"font-size: 12px;\">Conception parasismique<br /></span></li>\r\n<li><span style=\"font-size: 12px;\">Abris provisoires en cas de catastrophe<br /></span></li>\r\n</ul>\r\n<p> <strong style=\"color: #a6bd65; font-family: Arimo, Arial, \'Arial Unicode MS\', Helvetica, sans-serif; font-size: 20px; line-height: 24px;\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Typologie</span></strong></p>\r\n<p class=\"MsoNormal\"><span style=\"font-size: 12px;\" lang=\"FR-HT\">Ces lycées comprennent deux types d’architecture :</span></p>\r\n<ul>\r\n<li><span style=\"font-size: 12px;\">Type 1:<img src=\"images/template-content/Lycee_type_1-2.jpg\" border=\"0\" width=\"360\" height=\"240\" style=\"border: 0; vertical-align: text-top;\" /><br /></span></li>\r\n<li><span style=\"font-size: 12px;\"><span style=\"font-family: Arial, sans-serif;\" lang=\"EN-US\"> </span>Type 2:<img src=\"images/template-content/Lycee_type_2.jpg\" border=\"0\" width=\"360\" height=\"240\" style=\"border: 0; vertical-align: text-top;\" /><br /></span></li>\r\n</ul>\r\n<h3> <strong><span style=\"font-size: 12px;\">Fiche technique d’un lycée (Types 1 et 2)  de 2,373 m</span><sup><span style=\"font-size: 10px;\">2</span></sup><span style=\"font-size: 12px;\"> de bâti</span> </strong></h3>\r\n<ul>\r\n<li><span style=\"font-size: 12px;\">5 modules de 3 salles classes        :   51,81 m<sup>2</sup> / salle de classe<br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 module administratif                        :   104.25 m<sup>2</sup><br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 module de 3 laboratoires                :   51.81 m<sup>2</sup> / laboratoire<br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 bibliothèque                                       :   90,43 m<sup>2</sup><br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 module réfectoire et gardiennage :   123,71m<sup>2</sup><br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 bloc sanitaire                                     :   36 m<sup>2</sup><br /></span></li>\r\n<li><span style=\"font-size: 12px;\">1 scène en plein air                             :   48 m<sup>2</sup></span></li>\r\n</ul>\r\n<p> </p>\r\n<p style=\"text-align: justify;\"><span style=\"font-size: 12px;\">Les coûts de construction des lycées pour la période allant de 2010 à 2013 se situent entre 35 et 48 millions de gourdes, dépendamment de la configuration du site, des types de sols (design 1, 2 ou mixte (lycée de Limonade). Non compris dans ces montants les coûts des études géotechniques et topographiques (environ 700 mille gourdes par lycée).</span></p>\r\n<p>{gallery count=3}/sampledata/rea_bmpad/pip{/gallery}</p>', '', '1', '0', '0', '2', '2014-06-25 20:50:02', '69', '', '2014-06-26 21:27:19', '69', '0', '0000-00-00 00:00:00', '2014-06-25 20:50:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '19', '0', '0', '', '', '1', '40', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('270', '324', 'Projets Communaux', 'projets-communaux', '', '<p>Depuis l’exercice 2011-2012, l’Etat haïtien prévoit pour chaque commune du pays 10 millions de gourdes au budget annuel pour la réalisation de projets d’investissement. Le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD), suite à un protocole avec le Ministère de la Planification et de la Coopération Externe (MPCE), est le Maître d’Ouvrage Délégué dudit ministère pour la mise en œuvre de ces projets qui concernent :</p>\r\n<ul>\r\n<li><span style=\"color: #2a3215;\">la construction d’écoles nationales, de places et de marchés publics</span></li>\r\n<li><span style=\"color: #2a3215;\">la construction de centres de santé, de dispensaires et de complexes administratifs</span></li>\r\n<li><span style=\"color: #2a3215;\">la réhabilitation et l’extension de réseau électrique (basse et moyenne tension)</span></li>\r\n<li><span style=\"color: #2a3215;\">etc.</span></li>\r\n</ul>\r\n<p>{gallery count=1 width=\"650\" height=500}/sampledata/rea_bmpad/fonds_communaux{/gallery}</p>', '', '1', '0', '0', '2', '2014-06-25 21:02:02', '69', '', '2014-06-26 21:20:58', '69', '0', '0000-00-00 00:00:00', '2014-06-25 21:02:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '9', '0', '0', '', '', '1', '32', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('271', '325', 'Projets BMPAD', 'projets-bmpad', '', '<p><span>C’est la partie du budget du BMPAD utilisée pour le financement de projets de développement communautaire (marchés, écoles, extension de réseaux électriques, petits équipements agro-industriels,  etc.) </span></p>\r\n<p>{gallery count=1 width=\"750\" height=\"600\"}/sampledata/rea_bmpad/budget_invest_bmpad{/gallery}</p>', '', '1', '0', '0', '2', '2014-06-25 21:02:58', '69', '', '2014-06-26 21:20:38', '69', '0', '0000-00-00 00:00:00', '2014-06-25 21:02:58', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '0', '0', '', '', '1', '16', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('272', '326', 'JSDF', 'jsdf', '', '<div class=\"contenu\" style=\"font-family: Arial, Helvetica, sans-serif; color: #000000; margin-left: 30px; margin-right: 10px; text-align: justify;\">\r\n<h4 style=\"font-family: Arial, Helvetica, sans-serif; color: #2a286b; margin-top: 15px; margin-left: 25px; text-align: center;\"><span style=\"font-size: 14px; color: #4a771d; font-weight: bold;\">Projet Communautaire d\'Urgence Cash-for-Work / Japan Social Development Fund (JSDF)</span></h4>\r\n</div>\r\n<p>      </p>\r\n<table id=\"des_proj\" style=\"width: 650px; margin-right: auto; margin-left: auto;\" width=\"408\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n<tbody>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\" width=\"136\">\r\n<p align=\"right\"><strong>Objectif du JSDF:</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\">\r\n<p><img src=\"http://www.bureaudegestion.gouv.ht/gif/spacer.gif\" border=\"0\" width=\"1\" height=\"1\" /></p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"262\">\r\n<p><span style=\"font-size: 11.0pt; line-height: 115%; font-family: \'Calibri\',\'sans-serif\'; mso-ascii-theme-font: minor-latin; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; mso-hansi-theme-font: minor-latin; mso-bidi-font-family: \'Times New Roman\'; mso-bidi-theme-font: minor-bidi; mso-ansi-language: FR-HT; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\" lang=\"FR-HT\">Atténuer les effets économiques et sociaux du tremblement de terre du 12 janvier 2010</span></p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<p align=\"right\"><strong>Coût :</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\">\r\n<p> </p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">\r\n<p>2,840,000.00US$</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\">\r\n<p align=\"right\"><strong>Durée :</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\">\r\n<p> </p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\">\r\n<p>Dix-huit (18) mois</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<p align=\"right\"><strong>Financement :</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\">\r\n<p> </p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">\r\n<p>Gouvernement japonais à travers Banque Mondiale</p>\r\n<p>Réf. Accord de Don JSDF No. TF097742</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#ECECF2\">\r\n<p align=\"right\"><strong>Zones d’intervention :</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#ECECF2\" width=\"10\">\r\n<p> </p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#ECECF2\">\r\n<p class=\"MsoNormal\"><span lang=\"FR-HT\">Artibonite (Saint Marc, Gonaïves)</span></p>\r\n<p class=\"MsoNormal\"><span lang=\"FR-HT\">Centre (Mirebalais, Hinche)</span></p>\r\n<p>Ouest (Cité Soleil, Simmonds Pelé, Bel-Air, Solino, Delmas 32, Martissant, Carrefour-Feuilles)</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" valign=\"top\" bgcolor=\"#E1E1EA\">\r\n<p align=\"right\"><strong>Statut du JSDF :</strong></p>\r\n</td>\r\n<td style=\"border-width: 0px;\" bgcolor=\"#E1E1EA\" width=\"10\">\r\n<p> </p>\r\n</td>\r\n<td class=\"contenu2\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #000000; margin-left: 30px; margin-right: 10px; border-width: 0px;\" bgcolor=\"#E1E1EA\">\r\n<p>Achevé</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: center;\"><iframe src=\"http://www.youtube.com/embed/mtCMIqenPbU?wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent&amp;amp;wmode=transparent\" width=\"650\" height=\"345\"></iframe></p>', '', '1', '0', '0', '22', '2014-06-25 22:03:03', '69', '', '2014-06-26 23:46:36', '69', '0', '0000-00-00 00:00:00', '2014-06-25 22:03:03', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '13', '0', '1', '', '', '1', '44', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
INSERT INTO `y43zw_content` VALUES ('273', '327', 'Qui sommes-nous ?', 'qui-sommes-nous', '', '<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"margin-bottom: 0.0001pt;\"><span style=\"font-family: Arial; font-size: 12px; line-height: 14px; color: #000000;\">Le Bureau de Monétisation des Programmes d’Aide au Développement (BMPAD),  ci-devant Bureau de Gestion PL-480, travaillant sous tutelle du <a href=\"http://www.mefhaiti.gouv.ht/\" target=\"_blank\" title=\"MEF\">Ministère de l\'Economie et des Finances</a>, est  une entité étatique responsable de la monétisation des aides alimentaires, de la gestion des projets et de la mise en œuvre de l’Accord PetroCaribe.</span><span style=\"font-family: Arial; font-size: 12px;\"> <br /><br /></span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row responsive-layout-row-2\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">\r\n<p class=\"MsoNormal\" style=\"margin-bottom: 0.0001pt; text-align: justify;\"><span style=\"color: black; font-size: 12px; line-height: 13px; text-align: justify;\">Ce bureau, créé le 6 juin 1985 pour la gestion du programme américain PL-480/Titre III,  après une restructuration en 1995, s’est vu confié la monétisation des aides alimentaires reçues par Haïti dans le cadre de différents accords de don bilatéraux signés avec le </span><a href=\"partenaires/accords-bilateraux/japon\" style=\"font-size: 12px; line-height: 13px;\">Japon</a><span style=\"color: black; font-size: 12px; line-height: 13px; text-align: justify;\">, le Canada, la </span><a href=\"partenaires/accords-bilateraux/france\" title=\"PetroCaribe\" style=\"font-size: 12px; line-height: 13px;\">France</a><span style=\"color: black; font-size: 12px; line-height: 13px; text-align: justify;\"> et l’</span><a href=\"partenaires/accords-bilateraux/italie\" title=\"Italie\" style=\"font-size: 12px; line-height: 13px;\">Italie</a><span style=\"color: black; font-size: 12px; line-height: 13px; text-align: justify;\">.</span></p>\r\n<p class=\"MsoNormal\" style=\"margin-bottom: 0.0001pt; text-align: justify;\"><span style=\"color: black; font-family: Arial; font-size: 12px; line-height: 13px;\">Suite à l’Accord de Coopération Energétique </span><a href=\"petrocaribe.html\" title=\"PetroCaribe\" style=\"font-size: 12px; line-height: 13px;\">PetroCaribe</a><span style=\"color: black; font-family: Arial; font-size: 12px; line-height: 13px;\"> entre l’Etat haïtien et la République Bolivarienne du Venezuela, et la cessation du programme PL-480, il s’est avéré impératif de revoir le cadre légal du Bureau, tout en priorisant la préservation des acquis institutionnels du Bureau de Gestion PL-480, de manière à garantir la poursuite de la mise en œuvre des programmes bilatéraux et multilatéraux d’aide publique au développement d’Haïti. Ainsi, a été créé le BMPAD le 27 décembre 2007, avec à sa tête un Conseil d’Administration de 7 membres, le Directeur Général remplissant le rôle de Secrétaire Exécutif dudit Conseil.</span></p>\r\n<p style=\"text-align: justify;\"><span style=\"font-family: Arial; font-size: 12px; line-height: 13px; color: #000000;\">Le BMPAD  œuvre, dès lors, pour le renforcement de l’action gouvernementale  avec  une optimisation de l’utilisation des ressources humaines et financières disponibles, tout en appliquant de manière rigoureuse les normes et procédures en vigueur dans son manuel d’Opération.</span></p>\r\n</div>\r\n<div class=\"bmpad-layout-cell\" style=\"width: 50%;\">{gallery slider=boxplus.transition width=350 height=400 animation=3000}/template-content/tmpFE6A-large.png{/gallery} {gallery slider=boxplus.transition width=350 height=400 animation=3000}/sampledata/rea_bmpad/bmpad_all{/gallery}</div>\r\n</div>\r\n</div>\r\n<div class=\"bmpad-content-layout\">\r\n<div class=\"bmpad-content-layout-row\">\r\n<div class=\"bmpad-layout-cell\" style=\"width: 100%;\">\r\n<p class=\"MsoNormal\" style=\"margin-bottom: 0.0001pt; text-align: justify;\"><span style=\"line-height: 13px; color: black; font-family: Arial; font-size: 12px;\">Après le séisme du 12 janvier 2010, le BMPAD a pu avec un financement de la <a href=\"partenaires/accords-multilateraux.html\" target=\"_self\" title=\"Banque Mondiale\">Banque Mondiale</a> travailler à l\'opérationnalisation d’un plan permettant la réfection de routes et l’extension des réseaux d\'infrastructures de services publics. Un financement du Trésor Public a permis également au BMPAD d’être le Maître d’Ouvrage Délégué de deux Ministères pour la construction de 22 lycées à travers le pays et la réalisation de travaux de construction d’écoles, de centres de santé, de marchés publics, d’extension de réseaux électriques et d\'autres infrastructures publiques dans plusieurs communes des 10 départements du pays.</span></p>\r\n<p class=\"MsoNormal\" style=\"margin-bottom: 0.0001pt; text-align: justify;\"><span style=\"line-height: 13px; color: black; font-family: Arial; font-size: 12px;\"> </span></p>\r\n<blockquote style=\"background-repeat-x: no-repeat; background-repeat-y: no-repeat;\"><span style=\"font-family: Arial; font-size: 12px;\"><br /><span style=\"line-height: 13px;\">En août 2014, une journée « portes ouvertes » sera réalisée au sein même du BMPAD, de manière à familiariser le public<br />cible aux activités de cette institution.</span></span></blockquote>\r\n<p> </p>\r\n</div>\r\n</div>\r\n</div>', '', '1', '0', '0', '22', '2014-06-26 15:24:25', '69', '', '2014-06-26 18:08:41', '69', '0', '0000-00-00 00:00:00', '2014-06-26 15:24:25', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '29', '0', '0', '', '', '1', '49', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');

-- ----------------------------
-- Table structure for `y43zw_content_frontpage`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_content_frontpage`;
CREATE TABLE `y43zw_content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_content_frontpage
-- ----------------------------
INSERT INTO `y43zw_content_frontpage` VALUES ('214', '7');
INSERT INTO `y43zw_content_frontpage` VALUES ('216', '3');
INSERT INTO `y43zw_content_frontpage` VALUES ('217', '5');
INSERT INTO `y43zw_content_frontpage` VALUES ('232', '6');
INSERT INTO `y43zw_content_frontpage` VALUES ('237', '2');
INSERT INTO `y43zw_content_frontpage` VALUES ('244', '4');
INSERT INTO `y43zw_content_frontpage` VALUES ('273', '1');

-- ----------------------------
-- Table structure for `y43zw_content_rating`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_content_rating`;
CREATE TABLE `y43zw_content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_content_rating
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_core_log_searches`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_core_log_searches`;
CREATE TABLE `y43zw_core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_core_log_searches
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_extensions`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_extensions`;
CREATE TABLE `y43zw_extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10026 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_extensions
-- ----------------------------
INSERT INTO `y43zw_extensions` VALUES ('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"fr-FR\",\"site\":\"fr-FR\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":\"1\",\"show_publishing_options\":\"0\",\"show_article_options\":\"0\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"none\",\"float_fulltext\":\"none\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"0\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"0\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"2\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"0\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"0\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('27', 'com_finder', 'component', 'com_finder', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_advanced\":\"0\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"updatesource\":\"custom\",\"customurl\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"11.4\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0');
INSERT INTO `y43zw_extensions` VALUES ('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('405', 'plg_content_geshi', 'plugin', 'geshi', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"xhtml\"}', '', '', '0', '2011-09-18 15:22:50', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0');
INSERT INTO `y43zw_extensions` VALUES ('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\",\"relative\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0');
INSERT INTO `y43zw_extensions` VALUES ('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0');
INSERT INTO `y43zw_extensions` VALUES ('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"2.5.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2013\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.4.1\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\",\"skin\":\"3\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"fr\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"applet\",\"extended_elements\":\"style,script,div[*]\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0');
INSERT INTO `y43zw_extensions` VALUES ('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0');
INSERT INTO `y43zw_extensions` VALUES ('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0');
INSERT INTO `y43zw_extensions` VALUES ('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0');
INSERT INTO `y43zw_extensions` VALUES ('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0');
INSERT INTO `y43zw_extensions` VALUES ('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0');
INSERT INTO `y43zw_extensions` VALUES ('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0');
INSERT INTO `y43zw_extensions` VALUES ('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0');
INSERT INTO `y43zw_extensions` VALUES ('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '8', '0');
INSERT INTO `y43zw_extensions` VALUES ('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0');
INSERT INTO `y43zw_extensions` VALUES ('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '10', '0');
INSERT INTO `y43zw_extensions` VALUES ('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0');
INSERT INTO `y43zw_extensions` VALUES ('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0');
INSERT INTO `y43zw_extensions` VALUES ('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0');
INSERT INTO `y43zw_extensions` VALUES ('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0');
INSERT INTO `y43zw_extensions` VALUES ('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0');
INSERT INTO `y43zw_extensions` VALUES ('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0');
INSERT INTO `y43zw_extensions` VALUES ('502', 'bluestork', 'template', 'bluestork', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"2.5.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.19\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.19\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('602', 'French Language Pack', 'package', 'pkg_fr-FR', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"French Language Pack\",\"type\":\"package\",\"creationDate\":\"01-03-2014\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.22.1\",\"description\":\"\\n\\t\\t\\n\\t\\t<h3>Joomla! Full French (fr-FR) Language Package version 2.5.22v1<\\/h3>\\n\\t\\t<h3>Paquet de langue fran\\u00e7ais complet Joomla! fr-FR version 2.5.21v1<\\/h3>\\n\\t\\t<div>Installation incluse du pack de langue fr-FR de TinyMCE 3.5.4 pour Joomla 2.5.x<\\/div><br>\\n\\t\\t<div style=\\\"font-weight: normal; padding-bottom:15px;\\\">N\'oubliez pas de s\\u00e9lectionner la langue FR dans les <a href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\"><strong>param\\u00e8tres du plug-in \'\\u00c9diteur - TinyMCE\'<\\/strong><\\/a> (param\\u00e8tre  \'Langue de l\'\\u00e9diteur\' = fr).<br>\\n \\t\\tSi vous utilisez la <strong>d\\u00e9tection automatique<\\/strong>, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants aux packs de langue install\\u00e9s pour Joomla!<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('603', 'Frenchfr-FR', 'language', 'fr-FR', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"01-03-2014\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.22.1\",\"description\":\"fr-FR administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('604', 'Frenchfr-FR', 'language', 'fr-FR', '', '0', '1', '0', '1', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"01-03-2014\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.22.1\",\"description\":\"fr-FR site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('605', 'TinyMCE langue FR', 'file', 'TinyMCE_fr-FR', '', '0', '1', '0', '1', '{\"legacy\":false,\"name\":\"TinyMCE langue FR\",\"type\":\"file\",\"creationDate\":\"4 feb 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"(C) 2005-2013 French Translation Team\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"3.5.4.1\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installation du pack de langue FR de TinyMCE 3.5.4.1 pour Joomla 2.5 effectu\\u00e9e avec succ\\u00e8s<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tN\'oubliez pas de s\\u00e9lectionner la langue FR dans la \\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestion du plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n \\t\\tSi vous utilisez la d\\u00e9tection automatique, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants \\n \\t\\t\\u00e0 ceux install\\u00e9s pour Joomla!<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.19\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('800', 'PKG_JOOMLA', 'package', 'pkg_joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10001', 'IceTabs Module', 'module', 'mod_icetabs', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"IceTabs Module\",\"type\":\"module\",\"creationDate\":\"November 2010\",\"author\":\"IceTheme\",\"copyright\":\"GNU \\/ GPL\",\"authorEmail\":\"info@icetheme.com\",\"authorUrl\":\"http:\\/\\/www.icetheme.com\",\"version\":\"2.5.0\",\"description\":\"\\n\\t\\t\\n\\t\\t<h2>IceTabs Module<\\/h2>IceTabs module can display any content\\/banner\\/images\\/K2\\/VirtueMart information with a smooth and nice interface based on a tabular interface.<br><br><ul><li><a href=\\\"http:\\/\\/icetheme.com\\/Joomla-Extensions\\/icetabs.html\\\">IceTabs Page<\\/a><\\/li><li><a target=\\\"_blank\\\" href=\\\"http:\\/\\/icetheme.com\\/Forums\\/IceTabs\\/\\\">Get Support<\\/a><\\/li><\\/ul><\\/li><\\/ul> <script type=\\\"text\\/javascript\\\" src=\\\"..\\/modules\\/mod_icetabs\\/assets\\/form.js\\\"><\\/script> <style>.lof-group{ padding:2px;color:#666;background:#CCC;cursor:hand; font-weight:bold; cursor:pointer}<\\/style>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{\"theme\":\"default-white\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"600\",\"main_height\":\"300\",\"imagemain_width\":\"160\",\"imagemain_height\":\"220\",\"limit_items\":\"5\",\"display_button\":\"1\",\"show_readmore\":\"1\",\"auto_strip_tags\":\"0\",\"description_max_chars\":\"100\",\"group\":\"content\",\"source\":\"content_category\",\"article_ids\":\"\",\"content_category\":\"\",\"ordering\":\"created_asc\",\"image_folder\":\"images\\/sampledata\\/fruitshop\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"\":\"K2_ITEM_VIEW_OPTIONS_COMMON_FOR_EITHER_SOURCE\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"clientids\":\"\",\"banner_category\":\"\",\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_category\":\"\",\"vm_ordering\":\"ordering_desc\",\"navigator_pos\":\"right\",\"navitem_width\":\"290\",\"navitem_height\":\"100\",\"max_items_display\":\"3\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"60\",\"thumbnail_height\":\"60\",\"title_max_chars\":\"100\",\"layout_style\":\"vrdown\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.Sine.easeInOut\",\"auto_start\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10010', 'bmpadv451', 'template', 'bmpadv451', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"bmpadv451\",\"type\":\"template\",\"creationDate\":\"2014-05-26\",\"author\":\"GSI BMPAD\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"bmpad\",\"group\":\"\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10012', 'com_phocadownload', 'component', 'com_phocadownload', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"com_phocadownload\",\"type\":\"component\",\"creationDate\":\"27\\/04\\/2013\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"2.1.9\",\"description\":\"Phoca Download\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10013', 'plg_content_phocadownload', 'plugin', 'phocadownload', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_phocadownload\",\"type\":\"plugin\",\"creationDate\":\"07\\/02\\/2012\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"2.1.6\",\"description\":\"PLG_CONTENT_PHOCADOWNLOAD_DESCRIPTION\",\"group\":\"\"}', '{\"icon_size\":\"32\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10014', 'Phoca Download Section Menu Module', 'module', 'mod_phocadownload_sectionmenu', '', '0', '1', '0', '0', '{\"legacy\":true,\"name\":\"Phoca Download Section Menu Module\",\"type\":\"module\",\"creationDate\":\"12\\/05\\/2010\",\"author\":\"Jan Pavelka (www.phoca.cz)\",\"copyright\":\"Jan Pavelka\",\"authorEmail\":\"\",\"authorUrl\":\"www.phoca.cz\",\"version\":\"1.3.5\",\"description\":\" \\n       Phoca Download Section Menu Module - displays a menu of Phoca Download component\'s sections.<br \\/>\\n       More information on <a href=\\\"http:\\/\\/www.phoca.cz\\\" target=\\\"_blank\\\" >www.phoca.cz<\\/a>  \\n      \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10015', 'Phoca Download-fr-FR', 'file', 'fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Phoca Download-fr-FR\",\"type\":\"file\",\"creationDate\":\"2013-11-29\",\"author\":\"Aide-Joomla.com\",\"copyright\":\"Copyright (C)2006-2013 Aide-Joomla.com. Tous droits r\\u00e9serv\\u00e9s.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"3.0.3\",\"description\":\"Traduction fran\\u00e7aise pour l\'extension Phoca Download - Traduction r\\u00e9vis\\u00e9e par Aide-Joomla.com\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10016', 'com_xmap', 'component', 'com_xmap', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"com_xmap\",\"type\":\"component\",\"creationDate\":\"2011-04-10\",\"author\":\"Guillermo Vargas\",\"copyright\":\"This component is released under the GNU\\/GPL License\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"http:\\/\\/www.jooxmap.com\",\"version\":\"2.3.4\",\"description\":\"Xmap - Sitemap Generator for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10017', 'Xmap - Mosets Tree Plugin', 'plugin', 'com_mtree', 'xmap', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Xmap - Mosets Tree Plugin\",\"type\":\"plugin\",\"creationDate\":\"07\\/20\\/2011\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.2\",\"description\":\"XMAP_MTREE_PLUGIN_DESCRIPTION\",\"group\":\"\"}', '{\"cats_order\":\"cat_name\",\"cats_orderdir\":\"ASC\",\"include_links\":\"1\",\"links_order\":\"ordering\",\"entries_orderdir\":\"ASC\",\"max_links\":\"\",\"max_age\":\"\",\"cat_priority\":\"0.5\",\"cat_changefreq\":\"weekly\",\"link_priority\":\"0.5\",\"link_changefreq\":\"weekly\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10021', 'Content - Image gallery - sigplus', 'plugin', 'sigplus', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Content - Image gallery - sigplus\",\"type\":\"plugin\",\"creationDate\":\"Dec 06, 2013\",\"author\":\"Levente Hunyadi\",\"copyright\":\"\\u00a9 2009-2011 Levente Hunyadi. All rights reserved.\",\"authorEmail\":\"hunyadi@gmail.com\",\"authorUrl\":\"http:\\/\\/hunyadi.info.hu\\/projects\\/sigplus\",\"version\":\"1.4.2.17\",\"description\":\"SIGPLUS_DESCRIPTION\",\"group\":\"\"}', '{\"base_folder\":\"images\",\"layout\":\"fixed\",\"rows\":\"1\",\"cols\":\"2\",\"thumb_count\":\"0\",\"thumb_width\":\"200\",\"thumb_height\":\"200\",\"thumb_crop\":\"0\",\"alignment\":\"center\",\"lightbox\":\"boxplus\\/prettyphoto\",\"lightbox_slideshow\":\"0\",\"slider\":\"boxplus.slider\",\"slider_orientation\":\"horizontal\",\"slider_navigation\":\"bottom\",\"slider_buttons\":\"1\",\"slider_links\":\"0\",\"slider_counter\":\"0\",\"slider_overlay\":\"1\",\"slider_duration\":\"800\",\"slider_animation\":\"0\",\"captions\":\"none\",\"caption_title\":\"\",\"caption_description\":\"\",\"download\":\"1\",\"metadata\":\"0\",\"margin\":\"\",\"border_style\":\"\",\"border_width\":\"\",\"border_color\":\"\",\"padding\":\"\",\"thumb_cache\":\"1\",\"thumb_folder\":\"thumbs\",\"preview_folder\":\"preview\",\"fullsize_folder\":\"fullsize\",\"base_url\":\"\",\"thumb_quality\":\"85\",\"labels\":\"labels\",\"labels_multilingual\":\"0\",\"sort_criterion\":\"labels-filename\",\"sort_order\":\"0\",\"linkage\":\"inline\",\"ajaxapi\":\"local\",\"library\":\"default\",\"activationtag\":\"gallery\",\"debug\":\"0\",\"settings\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10022', 'sigplus', 'module', 'mod_sigplus', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"sigplus\",\"type\":\"module\",\"creationDate\":\"Dec 06, 2013\",\"author\":\"Levente Hunyadi\",\"copyright\":\"\\u00a9 2009-2011 Levente Hunyadi. All rights reserved.\",\"authorEmail\":\"hunyadi@gmail.com\",\"authorUrl\":\"http:\\/\\/hunyadi.info.hu\\/projects\\/sigplus\",\"version\":\"1.4.2.17\",\"description\":\"SIGPLUS_DESCRIPTION\",\"group\":\"\"}', '{\"images_folder\":\"images\\/sampledata\\/fruitshop\",\"layout\":\"fixed\",\"rows\":\"1\",\"cols\":\"1\",\"thumb_count\":\"0\",\"thumb_width\":\"200\",\"thumb_height\":\"200\",\"thumb_crop\":\"0\",\"alignment\":\"center\",\"lightbox\":\"boxplus\\/lightsquare\",\"lightbox_slideshow\":\"0\",\"slider\":\"boxplus.slider\",\"slider_orientation\":\"vertical\",\"slider_navigation\":\"bottom\",\"slider_buttons\":\"0\",\"slider_links\":\"0\",\"slider_counter\":\"0\",\"slider_overlay\":\"1\",\"slider_duration\":\"800\",\"slider_animation\":\"0\",\"download\":\"0\",\"metadata\":\"0\",\"margin\":\"\",\"border_style\":\"\",\"border_width\":\"\",\"border_color\":\"\",\"padding\":\"\",\"thumb_cache\":\"1\",\"thumb_folder\":\"thumbs\",\"preview_folder\":\"preview\",\"fullsize_folder\":\"fullsize\",\"base_url\":\"\",\"thumb_quality\":\"85\",\"labels\":\"labels\",\"labels_multilingual\":\"0\",\"sort_criterion\":\"labels-filename\",\"sort_order\":\"0\",\"linkage\":\"inline\",\"ajaxapi\":\"default\",\"library\":\"default\",\"moduleclass_sfx\":\"\",\"debug\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10023', 'sigplus', 'package', 'pkg_sigplus', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"sigplus\",\"type\":\"package\",\"creationDate\":\"Dec 06, 2013\",\"author\":\"Levente Hunyadi\",\"copyright\":\"\\u00a9 2009-2011 Levente Hunyadi. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/hunyadi.info.hu\\/projects\\/sigplus\",\"version\":\"1.4.2.17\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10024', 'Editor - JoomlaCK', 'plugin', 'jckeditor', 'editors', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Editor - JoomlaCK\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"WebxSolution Ltd\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"6.5.2\",\"description\":\"PLG_JCK_XML_DESC\",\"group\":\"\"}', '{\"ftfamily\":\"\",\"ftcolor\":\"\",\"ftsize\":\"\",\"bgcolor\":\"#FFFFFF\",\"task\":\"finish\",\"useUserFolders\":\"0\",\"userFolderType\":\"username\",\"template\":\"bmpadv451\",\"content_css_custom\":\"templates\\\\bmpadv451\\\\css\\\\template.css\",\"jcktypography\":\"1\",\"styles_css_custom\":\"templates\\\\bmpadv451\\\\css\\\\template.css\",\"content_css\":0,\"styles_css\":0,\"editor_css\":0,\"jcktypographycontent\":\"\\ufeff\\/*\\r\\n * JCK Editor Typography Style-sheet\\r\\n * @author: Paul Franklin\\r\\n * @website: http:\\/\\/www.joomlackeditor.com\\r\\n * @version: 1.3\\r\\n * @copyright (C) WebxSolution Ltd 2011 - 2013. All rights reserved\\r\\n * @license: GPLv2\\r\\n * @terms: http:\\/\\/www.joomlackeditor.com\\/terms-of-use\\r\\n * @icons: WebxSolution Ltd has the non-exclusive, non-transferable, non-sublicensable right to use the Licensed Material an unlimited number of times in any and all media for the following commercial or personal purposes (together the \\\"Permitted Uses\\\") subject to the restrictions set forth in the Agreement. Any uses other than the Permitted Uses must be approved by DryIcons in writing. http:\\/\\/dryicons.com\\/terms\\/commercial\\/\\r\\n *\\/ \\r\\n \\r\\n \\/* ADD GENERAL BODY FOR EDITOR\\r\\n-------------------------------------------------------------------------*\\/\\r\\n\\/* The body class defines the document\'s body. This usually contains generic default font, size & color which is used across your site.\\r\\nIf your template does not have a dedicated style-sheet for  your content typography, or the editor\'s \'Style\' box is being populated with thousands of useless classes due to your typography being found in different style-sheets, you can improve the users workflow by adding these styles to the classes as defined below. As the editor is set to read from this style-sheet it will automatically be used in the editor\'s editing area. *\\/\\r\\n\\r\\nbody {}\\r\\n\\r\\n \\/* ADD PARAGRAPH FORMAT STYLES FOR EDITOR\\r\\n-------------------------------------------------------------------------*\\/\\r\\n\\r\\nh1 {}\\r\\nh2 {}\\r\\nh3 {}\\r\\nh4 {}\\r\\nh5 {}\\r\\nh6 {}\\r\\npre {}\\r\\naddress {}\\r\\nhr {}\\r\\n\\r\\n \\/* Preformatted text\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\n\\r\\nblockquote {\\r\\n    background: none repeat scroll 0 0 #CCCCCC;\\r\\n    border-left: 10px solid #8F8F8F;\\r\\n    color: #544C4A;\\r\\n    font: italic 12pt\\/1.2em Georgia;\\r\\n    margin: 10px !important;\\r\\n    padding: 10px !important;\\r\\n    text-shadow: 1px 1px 1px #ffffff;\\r\\n    width: 60%;\\r\\n    border-radius: 0 10px 0 10px;\\r\\n    -moz-border-radius: 0 10px 0 10px;\\r\\n    -webkit-border: 0 10px 0 10px;\\r\\n}\\r\\n\\r\\nblockquote p { display: inline; }\\r\\n\\r\\nblockquote:before {\\r\\n    content: url(\\\"blockquotes.png\\\") !important;\\r\\n\\tbackground: none repeat scroll 0 0 transparent !important;\\r\\n    margin-right: 15px;\\r\\n    vertical-align: super;\\r\\n\\tposition: relative !important;\\r\\n}\\r\\n\\r\\nblockquote:after { background: none repeat scroll 0 0 transparent !important; }\\r\\n\\r\\nspan.dropcap  {\\r\\n    color: #333333;\\r\\n    display: block;\\r\\n    float: left;\\r\\n    font: 60px\\/40px Georgia,Times,serif;\\r\\n    padding: 7px 8px 0 0;\\r\\n}\\r\\n\\r\\n \\/* Text Highlight\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\nspan.bluhlight-jck, span.grehlight-jck, span.redhlight-jck, span.blahlight-jck , span.yelhlight-jck {\\r\\n    border-radius: 5px 5px 5px 5px;\\r\\n    color: #FFFFFF;\\r\\n    display: inline;\\r\\n    font-weight: bold;\\r\\n\\ttext-shadow: none;\\r\\n    padding: 2px 4px;\\r\\n\\tfont-size: 13px;\\r\\n}\\r\\n\\r\\nspan.bluhlight-jck {  background: none repeat scroll 0 0 #3E6A86;}\\r\\nspan.grehlight-jck {  background: none repeat scroll 0 0 #b9cd96;}\\r\\nspan.redhlight-jck {  background: none repeat scroll 0 0 #AA1428;}\\r\\nspan.blahlight-jck {  background: none repeat scroll 0 0 #000000;}\\r\\nspan.yelhlight-jck {  background: none repeat scroll 0 0 #F2F096; color: #544C4A;}\\r\\n \\r\\n\\/* Box Styles\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\n.blubox-jck, .grebox-jck, .redbox-jck, .blabox-jck, .yelbox-jck   {\\r\\n\\tbackground: none repeat scroll 0 0 #FAFAFA;\\r\\n\\tborder-style: solid;\\r\\n    border-width: 1px 1px 1px 8px;\\r\\n\\tmargin: 10px 0 20px !important;\\r\\n    padding: 8px 8px 8px 20px !important;\\r\\n\\t-webkit-border-top-left-radius: 15px;\\r\\n    -webkit-border-bottom-left-radius: 15px;\\r\\n    -moz-border-radius-topleft: 15px;\\r\\n    -moz-border-radius-bottomleft: 15px;\\r\\n    border-top-left-radius: 15px;\\r\\n    border-bottom-left-radius: 15px;\\r\\n\\tcolor: #444444 !important;\\r\\n\\ttext-shadow: 1px 1px 1px #ffffff;\\r\\n}\\r\\n\\r\\n.blubox-jck  {  border-color: #DDDDDD #DDDDDD #DDDDDD #3E6A86;}\\r\\n.grebox-jck  {  border-color: #DDDDDD #DDDDDD #DDDDDD #b9cd96;}\\r\\n.redbox-jck {  border-color: #DDDDDD #DDDDDD #DDDDDD #AA1428;}\\r\\n.blabox-jck  {  border-color: #DDDDDD #DDDDDD #DDDDDD #000000;}\\r\\n.yelbox-jck  {  border-color: #DDDDDD #DDDDDD #DDDDDD #F2F096; color: #544C4A;}\\r\\n\\r\\n.blubox-jck > br,\\r\\n.grebox-jck  > br,\\r\\n.redbox-jck > br, \\r\\n.blabox-jck  > br, \\r\\n.yelbox-jck > br {\\r\\n    clear: both;\\r\\n}\\r\\n\\r\\nspan.box-1heading-jck { font: 50px\\/50px Georgia,Times,serif;}\\r\\nspan.box-2heading-jck { font: 30px\\/40px Georgia,Times,serif;}\\r\\nspan.box-1heading-jck, span.box-2heading-jck { color: #333333; display: block; float: left;}\\r\\n \\r\\n\\/* Icon Library\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\n.info-jck, .warning-jck, .film-jck, .pin-jck , .lightbulb-jck , .recycle-jck , .camera-jck, .comment-jck, .chat-jck, .document-jck, .accessible-jck, .star-jck, .heart-jck, .previous-jck, .cart-jck, .attachment-jck, .calculator-jck, .cut-jck, .dollar-jck, .pound-jck , .euro-jck, .mail-jck, .support-jck, .next-jck, .sound-jck, .flash-jck, .zip-jck, .pdf-jck, .video-jck   {\\r\\n    display: block;\\r\\n    padding: 20px 0 20px 60px !important;\\r\\n\\tmargin-bottom: 20px !important;\\r\\n\\tbackground-color: transparent !important;\\r\\n    background-position: left center !important;\\r\\n    background-repeat: no-repeat !important;\\r\\n}\\r\\n\\r\\n.info-jck { background: url(\\\"info.png\\\")}\\r\\n.warning-jck { background: url(\\\"warning.png\\\")}\\r\\n.film-jck { background: url(\\\"film.png\\\")}\\r\\n.pin-jck {background: url(\\\"pin.png\\\")}\\r\\n.lightbulb-jck {background: url(\\\"light_bulb.png\\\")}\\r\\n.recycle-jck { background: url(\\\"recycle.png\\\")}\\r\\n.camera-jck { background: url(\\\"camera.png\\\")}\\r\\n.comment-jck { background: url(\\\"comment.png\\\")}\\r\\n.chat-jck  { background: url(\\\"chat.png\\\")}\\r\\n.document-jck { background: url(\\\"document.png\\\")}\\r\\n.accessible-jck { background: url(\\\"accessible.png\\\")}\\r\\n.star-jck { background: url(\\\"star.png\\\")}\\r\\n.heart-jck { background: url(\\\"heart.png\\\")}\\r\\n.previous-jck { background: url(\\\"previous.png\\\")}\\r\\n.cart-jck { background: url(\\\"cart.png\\\")}\\r\\n.attachment-jck { background: url(\\\"attachment.png\\\")}\\r\\n.calculator-jck { background: url(\\\"calculator.png\\\")}\\r\\n.cut-jck { background: url(\\\"cut.png\\\")}\\r\\n.dollar-jck { background: url(\\\"dollar_currency_sign.png\\\")}\\r\\n.pound-jck { background: url(\\\"sterling_pound_currency_sign.png\\\")}\\r\\n.euro-jck { background: url(\\\"euro_currency_sign.png\\\")}\\r\\n.mail-jck { background: url(\\\"mail.png\\\")}\\r\\n.support-jck { background: url(\\\"support.png\\\")}\\r\\n.next-jck  { background: url(\\\"next.png\\\")}\\r\\n.sound-jck  { background: url(\\\"sound.png\\\")}\\r\\n\\r\\n.flash-jck  { background: url(\\\"flash.png\\\")}\\r\\n.zip-jck  { background: url(\\\"zip_download.png\\\")}\\r\\n.pdf-jck  { background: url(\\\"pdf.png\\\")}\\r\\n.video-jck  { background: url(\\\"video_clip.png\\\")}\\r\\n\\r\\n\\r\\n\\/* Tooltips \\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\n\\r\\n.flashtip-jck, .ziptip-jck, .pdftip-jck, .videotip-jck, .infotip-jck, .warningtip-jck, .filmtip-jck, .pintip-jck , .lightbulbtip-jck , .recycletip-jck , .cameratip-jck, .commenttip-jck, .chattip-jck, .documenttip-jck, .accessibletip-jck, .startip-jck, .hearttip-jck, .previoustip-jck, .carttip-jck, .attachmenttip-jck, .calculatortip-jck, .cuttip-jck, .dollartip-jck, .poundtip-jck , .eurotip-jck, .mailtip-jck, .supporttip-jck, .nexttip-jck, .soundtip-jck, .download-DOC, .download-IMG  { color: #444444 !important; }\\r\\n\\r\\na.flashtip-jck, a.ziptip-jck, a.pdftip-jck, a.videotip-jck, a.infotip-jck, a.warningtip-jck, a.filmtip-jck, a.pintip-jck , a.lightbulbtip-jck , a.recycletip-jck , a.cameratip-jck, a.commenttip-jck, a.chattip-jck, a.documenttip-jck, a.accessibletip-jck, a.startip-jck, a.hearttip-jck, a.previoustip-jck, a.carttip-jck, a.attachmenttip-jck, a.calculatortip-jck, a.cuttip-jck, a.dollartip-jck, a.poundtip-jck , a.eurotip-jck, a.mailtip-jck, a.supporttip-jck , a.nexttip-jck, a.soundtip-jck, a .download-DOC , a .download-IMG { color: #095197 !important; }\\r\\n\\r\\n.flashtip-jck, .ziptip-jck, .pdftip-jck, .videotip-jck, .infotip-jck, .warningtip-jck, .filmtip-jck, .pintip-jck , .lightbulbtip-jck , .recycletip-jck , .cameratip-jck, .commenttip-jck, .chattip-jck, .documenttip-jck, .accessibletip-jck, .startip-jck, .hearttip-jck, .previoustip-jck, .carttip-jck, .attachmenttip-jck, .calculatortip-jck, .cuttip-jck, .dollartip-jck, .poundtip-jck , .eurotip-jck, .mailtip-jck, .supporttip-jck, .nexttip-jck, .soundtip-jck, .download-DOC, .download-IMG ,\\r\\n a.flashtip-jck, a.ziptip-jck, a.pdftip-jck, a.videotip-jck, a.infotip-jck, a.warningtip-jck, a.filmtip-jck, a.pintip-jck , a.lightbulbtip-jck , a.recycletip-jck , a.cameratip-jck, a.commenttip-jck, a.chattip-jck, a.documenttip-jck, a.accessibletip-jck, a.startip-jck, a.hearttip-jck, a.previoustip-jck, a.carttip-jck, a.attachmenttip-jck, a.calculatortip-jck, a.cuttip-jck, a.dollartip-jck, a.poundtip-jck , a.eurotip-jck, a.mailtip-jck, a.supporttip-jck , a.nexttip-jck, a.soundtip-jck, a .download-DOC , a .download-IMG\\r\\n{\\r\\n    display: block;\\r\\n\\tmargin-bottom: 20px;\\r\\n\\tbackground-color: #FAFAFA !important;\\r\\n    background-position: left center !important;\\r\\n    background-repeat: no-repeat !important;\\r\\n\\tbackground-size: 28px auto !important;\\r\\n    border-bottom: 1px dotted #C8C8C8;\\r\\n    border-top: 1px dotted #C8C8C8;\\r\\n    display: block;\\r\\n    margin: 10px 0 !important;\\r\\n    padding: 7px 10px 7px 35px !important;\\r\\n\\t-webkit-transition: background-color 800ms ease-in-out;\\r\\n\\t-moz-transition: background-color 800ms ease-in-out;\\r\\n\\t-o-transition: background-color 800ms ease-in-out;\\r\\n\\ttransition: background-color 800ms ease-in-out;\\r\\n\\ttext-shadow: 1px 1px 1px #ffffff;\\r\\n\\tfont-size: 14px;\\r\\n}\\r\\n\\r\\na.flashtip-jck:hover, a.ziptip-jck:hover, a.pdftip-jck:hover, a.videotip-jck:hover, a.infotip-jck:hover, a.warningtip-jck:hover, a.filmtip-jck:hover, a.pintip-jck:hover , a.lightbulbtip-jck:hover , a.recycletip-jck:hover , a.cameratip-jck:hover, a.commenttip-jck:hover, a.chattip-jck:hover, a.documenttip-jck:hover, a.accessibletip-jck:hover, a.startip-jck:hover, a.hearttip-jck:hover, a.previoustip-jck:hover, a.carttip-jck:hover, a.attachmenttip-jck:hover, a.calculatortip-jck:hover, a.cuttip-jck:hover, a.dollartip-jck:hover, a.poundtip-jck:hover, a.eurotip-jck:hover, a.mailtip-jck:hover, a.supporttip-jck:hover, a.nexttip-jck:hover, a.soundtip-jck:hover, a.download-DOC:hover, a.download-IMG:hover { color: #095197 !important; }\\r\\n\\r\\n.flashtip-jck:hover, .ziptip-jck:hover, .pdftip-jck:hover, .videotip-jck:hover, .infotip-jck:hover, .warningtip-jck:hover, .filmtip-jck:hover, .pintip-jck:hover , .lightbulbtip-jck:hover , .recycletip-jck:hover , .cameratip-jck:hover, .commenttip-jck:hover, .chattip-jck:hover, .documenttip-jck:hover, .accessibletip-jck:hover, .startip-jck:hover, .hearttip-jck:hover, .previoustip-jck:hover, .carttip-jck:hover, .attachmenttip-jck:hover, .calculatortip-jck:hover, .cuttip-jck:hover, .dollartip-jck:hover, .poundtip-jck:hover, .eurotip-jck:hover, .mailtip-jck:hover, .supporttip-jck:hover, .nexttip-jck:hover, .soundtip-jck:hover, .download-DOC:hover, .download-IMG:hover, a.flashtip-jck:hover, a.ziptip-jck:hover, a.pdftip-jck:hover, a.videotip-jck:hover, a.infotip-jck:hover, a.warningtip-jck:hover, a.filmtip-jck:hover, a.pintip-jck:hover , a.lightbulbtip-jck:hover, a.recycletip-jck:hover, a.cameratip-jck:hover, a.commenttip-jck:hover, a.chattip-jck:hover, a.documenttip-jck:hover, a.accessibletip-jck:hover, a.startip-jck:hover, a.hearttip-jck:hover, a.previoustip-jck:hover, a.carttip-jck:hover, a.attachmenttip-jck:hover, a.calculatortip-jck:hover, a.cuttip-jck:hover, a.dollartip-jck:hover, a.poundtip-jck:hover, a.eurotip-jck:hover, a.mailtip-jck:hover, a.supporttip-jck, a.nexttip-jck:hover, a.soundtip-jck:hover, a.download-DOC:hover, a.download-IMG:hover {\\r\\n    background-color: #F2F2F2 !important;\\r\\n\\t-webkit-transition: background-color 400ms ease-in-out;\\r\\n\\t-moz-transition: background-color 400ms ease-in-out;\\r\\n\\t-o-transition: background-color 400ms ease-in-out;\\r\\n\\ttransition: background-color 400ms ease-in-out;\\r\\n\\tbackground-repeat: no-repeat !important;\\r\\n}\\r\\n\\r\\n.flashtip-jck, .flashtip-jck:hover, a.flashtip-jck:hover { background-image: url(\\\"flash.png\\\")!important}\\r\\n.ziptip-jck, .ziptip-jck:hover, a.ziptip-jck:hover { background-image: url(\\\"zip_download.png\\\")!important}\\r\\n.pdftip-jck, .pdftip-jck:hover, a.pdftip-jck:hover { background-image: url(\\\"pdf.png\\\")!important}\\r\\n.videotip-jck , .videotip-jck:hover, a.videotip-jck:hover { background-image: url(\\\"video_clip.png\\\")!important}\\r\\n.download-IMG span, .download-DOC span:hover, a.download-DOC span:hover { font-weight: bold;}\\r\\n.infotip-jck, .infotip-jck:hover, a.infotip-jck:hover { background-image: url(\\\"info.png\\\")!important}\\r\\n.warningtip-jck, .warningtip-jck:hover, a.warningtip-jck:hover { background-image: url(\\\"warning.png\\\")!important}\\r\\n.filmtip-jck, .filmtip-jck:hover, a.filmtip-jck:hover { background-image: url(\\\"film.png\\\")!important}\\r\\n.pintip-jck, .pintip-jck:hover, a.pintip-jck:hover {background-image: url(\\\"pin.png\\\")!important}\\r\\n.lightbulbtip-jck, .lightbulbtip-jck:hover, a.lightbulbtip-jck:hover {background-image: url(\\\"light_bulb.png\\\")!important}\\r\\n.recycletip-jck, .recycletip-jck:hover, a.recycletip-jck:hover { background-image: url(\\\"recycle.png\\\")!important}\\r\\n.cameratip-jck, .cameratip-jck:hover, a.cameratip-jck:hover, .download-IMG, .download-IMG:hover, a.download-IMG:hover { background-image: url(\\\"camera.png\\\")!important}\\r\\n.commenttip-jck, .commenttip-jck:hover, a.commenttip-jck:hover { background-image: url(\\\"comment.png\\\")!important}\\r\\n.chattip-jck, .chattip-jck:hover , a.chattip-jck:hover { background-image: url(\\\"chat.png\\\")!important}\\r\\n.documenttip-jck, .documenttip-jck:hover, a.documenttip-jck:hover { background-image: url(\\\"document.png\\\")!important}\\r\\n.accessibletip-jck, .accessibletip-jck:hover, a.accessibletip-jck:hover { background-image: url(\\\"accessible.png\\\")!important}\\r\\n.startip-jck, .startip-jck:hover , a.startip-jck:hover { background-image: url(\\\"star.png\\\")!important}\\r\\n.hearttip-jck, .hearttip-jck:hover, a.hearttip-jck:hover { background-image: url(\\\"heart.png\\\")!important}\\r\\n.previoustip-jck, .previoustip-jck:hover, a.previoustip-jck:hover { background-image: url(\\\"previous.png\\\")!important}\\r\\n.carttip-jck, .carttip-jck :hover, a.carttip-jck:hover { background-image: url(\\\"cart.png\\\")!important}\\r\\n.attachmenttip-jck, .attachmenttip-jck:hover, a.attachmenttip-jck:hover, .download-DOC, .download-DOC:hover , a.download-DOC:hover { background-image: url(\\\"attachment.png\\\")!important}\\r\\n.calculatortip-jck, .calculatortip-jck:hover , a.calculatortip-jck:hover { background-image: url(\\\"calculator.png\\\")!important}\\r\\n.cuttip-jck, .cuttip-jck:hover, a.cuttip-jck:hover { background-image: url(\\\"cut.png\\\")!important}\\r\\n.dollartip-jck , .dollartip-jck:hover, a.dollartip-jck:hover { background-image: url(\\\"dollar_currency_sign.png\\\")!important}\\r\\n.poundtip-jck, .poundtip-jck:hover, a.poundtip-jck:hover { background-image: url(\\\"sterling_pound_currency_sign.png\\\")!important}\\r\\n.eurotip-jck, .eurotip-jck:hover , a.eurotip-jck:hover { background-image: url(\\\"euro_currency_sign.png\\\")!important}\\r\\n.mailtip-jck, .mailtip-jck:hover , a.mailtip-jck:hover { background-image: url(\\\"mail.png\\\")!important}\\r\\n.supporttip-jck, .supporttip-jck:hover , a.supporttip-jck:hover { background-image: url(\\\"support.png\\\")!important}\\r\\n.nexttip-jck, .nexttip-jck:hover, a.nexttip-jck:hover { background-image: url(\\\"next.png\\\")!important}\\r\\n.soundtip-jck, .soundtip-jck:hover , a.soundtip-jck:hover { background-image: url(\\\"sound.png\\\")!important}\\r\\n\\r\\n\\/* Number Disc\'s\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\nspan.bludisc-jck, span.bludisc-black-jck, span.gredisc-jck, span.gredisc-black-jck, span.reddisc-jck, span.reddisc-black-jck, span.bladisc-jck, span.bladisc-black-jck, span.yeldisc-jck, span.yeldisc-black-jck {\\r\\n    background-image: url(\\\"mask-white.png\\\");\\r\\n    background-position: left top !important;\\r\\n    background-repeat: no-repeat !important;\\r\\n    color: #FFFFFF;\\r\\n    display: block;\\r\\n    float: left;\\r\\n    font-size: 19px;\\r\\n    margin-right: 10px;\\r\\n    text-align: center;\\r\\n    width: 42px;\\r\\n\\theight: 31px; \\r\\n\\tpadding-top: 11px;\\r\\n\\tline-height: 15px;\\r\\n\\ttext-indent: -1px;\\r\\n\\tfont-family: georgia;\\r\\n\\ttext-shadow: 1px 1px 1px #5e5e5e;\\r\\n}\\r\\n\\r\\nspan.bludisc-black-jck, span.gredisc-black-jck, span.reddisc-black-jck , span.bladisc-black-jck , span.yeldisc-black-jck { \\r\\n\\tbackground-image: url(\\\"mask-black.png\\\")!important;\\r\\n\\t-webkit-border-radius: 20px;\\r\\n    -moz-border-radius: 20px;\\r\\n    border-radius: 20px;\\r\\n}\\r\\n\\r\\nspan.bludisc-jck, span.bludisc-black-jck {  background-color: #3E6A86;}\\r\\nspan.gredisc-jck, span.gredisc-black-jck {  background-color: #b9cd96;}\\r\\nspan.reddisc-jck, span.reddisc-black-jck {  background-color: #AA1428;}\\r\\nspan.bladisc-jck, span.bladisc-black-jck {  background-color: #000000;}\\r\\nspan.yeldisc-jck, span.yeldisc-black-jck {  background-color: #F2F096; color: #000000; text-shadow: 0px 1px 1px #444444;}\\r\\n\\r\\n\\/* Images Caption Styles\\r\\n-------------------------------------------------------------------------*\\/\\r\\nimg.caption { background-color:inherit; vertical-align: middle;}\\r\\n.img_caption.none { \\/* Override for central alignment = margin: 0 !important; *\\/} \\r\\n.img_caption { text-align: center; }\\r\\n\\r\\nimg.caption.photo, img.caption.photoblack, img.caption.photoblue, img.caption.photogreen, img.caption.photored, img.caption.photoyellow { \\r\\n    background-color: #FFFFFF;\\r\\n    padding: 10px 10px 40px;\\r\\n\\tmargin-right: 5px;\\r\\n\\tbox-shadow: 0 0 3px #000000;\\r\\n\\t-webkit-box-shadow: 0 0 3px #000000;\\r\\n    -moz-box-shadow: 0 0 3px #000000;\\r\\n}\\r\\n\\r\\nimg.caption.photo + p, img.caption.photoblack + p, img.caption.photoblue + p, img.caption.photogreen + p, img.caption.photored + p, img.caption.photoyellow + p {\\r\\n    position: relative; \\r\\n    left: 10px;\\r\\n    bottom: 30px;\\r\\n    overflow: hidden;\\r\\n    text-overflow: ellipsis;\\r\\n    white-space: nowrap;\\r\\n    width: 100%;\\r\\n\\tcolor: #333333;\\r\\n\\tmargin: 0;\\r\\n    font-size: 13px;\\r\\n    line-height: 18px;\\r\\n}\\r\\n\\r\\nimg.caption.photoblack + p , img.caption.photoblue + p, img.caption.photored + p { color: #FFFFFF; }\\r\\n\\r\\nimg.caption.photoblack { background-color: #000000;}\\r\\nimg.caption.photoblue {  background-color: #3E6A86;}\\r\\nimg.caption.photogreen  {  background-color: #b9cd96;}\\r\\nimg.caption.photored {  background-color: #AA1428;}\\r\\nimg.caption.photoyellow {  background-color: #F2F096;}\\r\\n\\r\\n\\r\\n\\/* Images Styles\\r\\n-------------------------------------------------------------------------*\\/\\r\\nimg.jck_img_align_left {\\r\\n    float: left; \\r\\n    margin: 3px 5px 0 0;\\r\\n    padding: 1px;\\r\\n}\\r\\n\\r\\nimg.jck_img_align_right {\\r\\n    float: right; \\r\\n    margin: 3px 0 0 5px;\\r\\n    padding: 1px;\\r\\n}\\r\\n\\r\\nimg.image_holder {\\r\\n    background: none repeat scroll 0 0 #FFFFFF;\\r\\n    border: 5px solid #EFEFEF;\\r\\n    margin: 3px 5px 0 0;\\r\\n    padding: 1px;\\r\\n}\\r\\n\\r\\nimg.fade_in {\\r\\n\\t-webkit-transition: all 500ms ease-in-out;\\r\\n\\t-moz-transition: all 500ms ease-in-out;\\r\\n\\t-o-transition: all 500ms ease-in-out;\\r\\n\\ttransition: all 500ms ease-in-out;\\r\\n\\t-webkit-box-shadow: 0 0 3px #000000;\\r\\n\\t-moz-box-shadow: 0 0 3px #000000;\\r\\n\\tbox-shadow: 0 0 3px #000000;\\r\\n\\tborder: 10px solid #FFFFFF;\\r\\n    height: 200px;\\r\\n    opacity: 0.5;\\r\\n    overflow: hidden;\\r\\n    position: relative;\\r\\n\\tmargin: 3px;\\r\\n\\tcursor:url(cursor_zoom.png),auto;\\r\\n}\\r\\n\\r\\nimg.fade_in:hover {\\r\\n\\t-webkit-box-shadow: 0 0 10px #000000;\\r\\n\\t-moz-box-shadow: 0 0 10px #000000;\\r\\n\\tbox-shadow: 0 0 10px #000000;\\r\\n    opacity: 1;\\r\\n}\\r\\n\\r\\nimg.zoom  { \\r\\n\\t-webkit-transition: all 500ms ease-in-out;\\r\\n\\t-moz-transition: all 500ms ease-in-out;\\r\\n\\t-o-transition: all 500ms ease-in-out;\\r\\n\\ttransition: all 500ms ease-in-out;\\r\\n    background: none repeat scroll 0 0 #FFFFFF;\\r\\n\\t-webkit-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n\\t-moz-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n\\tbox-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n    color: #333333;\\r\\n    display: inline;\\r\\n    float: left;\\r\\n    font-size: 18px;\\r\\n    padding: 10px 10px 15px;\\r\\n    text-align: center;\\r\\n    text-decoration: none;\\r\\n    width: auto;\\r\\n\\tfont-family: serif;\\r\\n\\theight: 100px !important;\\r\\n\\twidth: auto !important;\\r\\n\\tmargin: 0 20px 27px 0px;\\r\\n\\tcursor:url(cursor_zoom.png),auto;\\r\\n}\\r\\n\\r\\nimg.zoom:hover {\\r\\n    -moz-transform: scale(1.75);\\r\\n\\t-webkit-transform: scale(1.75);\\r\\n\\t-o-transform: scale(1.75);\\r\\n\\t-webkit-transition: all 500ms ease-in-out;\\r\\n\\t-moz-transition: all 500ms ease-in-out;\\r\\n\\t-o-transition: all 500ms ease-in-out;\\r\\n\\ttransition: all 500ms ease-in-out;\\r\\n\\t-webkit-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.5);\\r\\n\\t-moz-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.5);\\r\\n\\tbox-shadow: 0 3px 6px rgba(0, 0, 0, 0.5); \\r\\n    position: relative;\\r\\n    z-index: 50;\\r\\n\\tmargin: 0 -60px 27px 80px;\\r\\n}\\r\\n\\r\\nimg.polaroids_zoom  {\\r\\n    -moz-transform: rotate(-2deg);\\r\\n\\t-webkit-transform: rotate(2deg); \\r\\n\\t-o-transform: rotate(2deg); \\r\\n\\t-webkit-transition: all 500ms ease-in-out;\\r\\n\\t-moz-transition: all 500ms ease-in-out;\\r\\n\\t-o-transition: all 500ms ease-in-out;\\r\\n\\ttransition: all 500ms ease-in-out;\\r\\n    background: none repeat scroll 0 0 #FFFFFF;\\r\\n\\t-webkit-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n\\t-moz-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n\\tbox-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);\\r\\n    color: #333333;\\r\\n    display: inline;\\r\\n    float: left;\\r\\n    font-size: 18px;\\r\\n    margin: 0 20px 27px 30px;\\r\\n    padding: 10px 10px 15px;\\r\\n    text-align: center;\\r\\n    text-decoration: none;\\r\\n    width: auto;\\r\\n\\tfont-family: serif;\\r\\n\\theight: 100px !important;\\r\\n\\twidth: auto !important;\\r\\n\\tcursor:url(cursor_zoom.png),auto;\\r\\n}\\r\\n\\r\\nimg.polaroids_zoom:hover {\\r\\n    -moz-transform: scale(1.30);\\r\\n\\t-webkit-transform: scale(1.30);\\r\\n\\t-o-transform: scale(1.30);\\r\\n\\t-webkit-transition: all 500ms ease-in-out;\\r\\n\\t-moz-transition: all 500ms ease-in-out;\\r\\n\\t-o-transition: all 500ms ease-in-out;\\r\\n\\ttransition: all 500ms ease-in-out;\\r\\n\\t-webkit-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.5);\\r\\n\\t-moz-box-shadow: 0 3px 6px rgba(0, 0, 0, 0.5);\\r\\n\\tbox-shadow: 0 3px 6px rgba(0, 0, 0, 0.5); \\r\\n    position: relative;\\r\\n    z-index: 50;\\r\\n}\\r\\n\\r\\nimg.screenshot_blue, img.screenshot_green , img.screenshot_red, img.screenshot_black, img.screenshot_gray, img.screenshot_yellow  {\\r\\n    margin: 5px 0;\\r\\n    padding: 10px;\\r\\n\\tbackground: #ffffff;\\r\\n\\tbackground: -moz-linear-gradient(top, #ffffff 0%, #e5e5e5 100%);\\r\\n\\tbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(100%,#e5e5e5));\\r\\n\\tbackground: -webkit-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: -o-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: -ms-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#ffffff\', endColorstr=\'#e5e5e5\',GradientType=0 );\\r\\n\\topacity: 1;\\r\\n}\\r\\n\\r\\nimg.screenshot_blue { border: 10px solid #3E6A86;}\\r\\nimg.screenshot_green  { border: 10px solid #b9cd96;}\\r\\nimg.screenshot_red  { border: 10px solid #AA1428;}\\r\\nimg.screenshot_black  { border: 10px solid #000000;}\\r\\nimg.screenshot_gray { border: 10px solid #F0F0F0;}\\r\\nimg.screenshot_yellow { border: 10px solid #EFDE2C;}\\r\\n\\r\\n \\/* Div Styles\\r\\n----------------------------------------------------------------------------------------------------*\\/\\r\\ndiv.scroll_box {\\r\\n    margin: 5px 0;\\r\\n    padding: 10px;\\r\\n\\tbackground: #ffffff;\\r\\n\\tbackground: -moz-linear-gradient(top, #ffffff 0%, #e5e5e5 100%);\\r\\n\\tbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(100%,#e5e5e5));\\r\\n\\tbackground: -webkit-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: -o-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: -ms-linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tbackground: linear-gradient(top, #ffffff 0%,#e5e5e5 100%);\\r\\n\\tfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#ffffff\', endColorstr=\'#e5e5e5\',GradientType=0 );\\r\\n\\topacity: 1;\\r\\n\\tborder-left: 15px solid ##EDEDED;\\r\\n    border-top: 15px solid #EDEDED;\\r\\n    height: 300px;\\r\\n    overflow: scroll;\\r\\n\\t-webkit-box-shadow: 0 0 1px 1px #E3E3E3 inset, 0 0 1px 2px #FFFFFF inset, 0 0 0 1px #E3E3E3;\\r\\n\\tbox-shadow: 0 0 1px 1px #E3E3E3 inset, 0 0 1px 2px #FFFFFF inset, 0 0 0 1px #E3E3E3; \\r\\n}\\r\\n\\r\\ndiv.img_rollover { background-color: transparent; }\\r\\ndiv.img_rollover img:first-child { display: block; }\\r\\ndiv.img_rollover img:last-child { display: none; }\\r\\ndiv.img_rollover:hover img:first-child { display: none; }\\r\\ndiv.img_rollover:hover img:last-child { display:block; cursor: pointer; }\\r\\n\\r\\n\\/* Tables Styles\\r\\n-------------------------------------------------------------------------*\\/\\r\\ntable.table_style_blue, table.table_style_green, table.table_style_red, table.table_style_black, table.table_style_yellow  {\\r\\n    border: 1px solid #DDDDDD;\\r\\n    border-collapse: collapse;\\r\\n    color: #404040;\\r\\n    width: 100%;\\r\\n}\\r\\n\\r\\ntable.table_style_blue tbody tr, table.table_style_green tbody tr, table.table_style_red tbody tr, table.table_style_black tbody tr, table.table_style_yellow tbody tr  {\\r\\n    background: none repeat scroll 0 0 #F2F2F2;\\r\\n\\tborder: 1px solid #DDDDDD;\\r\\n\\t-webkit-transition: all 800ms ease-in-out;\\r\\n\\t-moz-transition: all 800ms ease-in-out;\\r\\n\\t-o-transition: all 800ms ease-in-out;\\r\\n\\ttransition: all 800ms ease-in-out;\\r\\n}\\r\\n\\r\\ntable.table_style_blue tbody tr:hover , table.table_style_green tbody tr:hover, table.table_style_red tbody tr:hover, table.table_style_black tbody tr:hover, table.table_style_yellow tbody tr:hover  {\\r\\n    background: none repeat scroll 0 0 #E5E5E5;\\r\\n\\t-webkit-transition: all 300ms ease-in-out;\\r\\n\\t-moz-transition: all 300ms ease-in-out;\\r\\n\\t-o-transition: all 300ms ease-in-out;\\r\\n\\ttransition: all 300ms ease-in-out;\\r\\n}\\r\\n\\r\\ntable.table_style_blue tbody tr td, table.table_style_green tbody tr td, table.table_style_red tbody tr td, table.table_style_black tbody tr td, table.table_style_yellow tbody tr td {\\r\\n    line-height: 22px;\\r\\n\\tpadding: 5px;\\r\\n\\tborder: 1px solid #DDDDDD;\\r\\n}\\r\\n\\r\\ntable.table_style_blue caption, table.table_style_green caption, table.table_style_red caption, table.table_style_black caption, table.table_style_yellow caption  {\\r\\n    color: #FFFFFF;\\r\\n    font-weight: 700;\\r\\n    line-height: 22px;\\r\\n    text-align: center;\\r\\n    text-transform: uppercase;\\r\\n}\\r\\n\\r\\ntable.table_style_blue caption { background: none repeat scroll 0 0 #3E6A86;}\\r\\ntable.table_style_green caption { background: none repeat scroll 0 0 #b9cd96;}\\r\\ntable.table_style_red caption { background: none repeat scroll 0 0 #AA1428;}\\r\\ntable.table_style_black caption { background: none repeat scroll 0 0 #000000;}\\r\\ntable.table_style_yellow caption { background: none repeat scroll 0 0 #F2F096; color: #544C4A;}\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
INSERT INTO `y43zw_extensions` VALUES ('10025', 'System - JCK Typography', 'plugin', 'jcktypography', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"System - JCK Typography\",\"type\":\"plugin\",\"creationDate\":\"Feb 2013\",\"author\":\"JCK\",\"copyright\":\"Copyright (C) 2011- 2013 All rights reserved.\",\"authorEmail\":\"andrew@joomlackeditor.com\",\"authorUrl\":\"www.joomlackeditor.com\",\"version\":\"3.5.0\",\"description\":\"Adds JCK Typography styles to template\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');

-- ----------------------------
-- Table structure for `y43zw_finder_filters`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_filters`;
CREATE TABLE `y43zw_finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `params` mediumtext,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_filters
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links`;
CREATE TABLE `y43zw_finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms0`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms0`;
CREATE TABLE `y43zw_finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms0
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms1`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms1`;
CREATE TABLE `y43zw_finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms1
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms2`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms2`;
CREATE TABLE `y43zw_finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms2
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms3`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms3`;
CREATE TABLE `y43zw_finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms3
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms4`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms4`;
CREATE TABLE `y43zw_finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms4
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms5`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms5`;
CREATE TABLE `y43zw_finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms5
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms6`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms6`;
CREATE TABLE `y43zw_finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms6
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms7`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms7`;
CREATE TABLE `y43zw_finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms7
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms8`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms8`;
CREATE TABLE `y43zw_finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms8
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_terms9`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_terms9`;
CREATE TABLE `y43zw_finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_terms9
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termsa`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termsa`;
CREATE TABLE `y43zw_finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termsa
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termsb`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termsb`;
CREATE TABLE `y43zw_finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termsb
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termsc`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termsc`;
CREATE TABLE `y43zw_finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termsc
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termsd`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termsd`;
CREATE TABLE `y43zw_finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termsd
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termse`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termse`;
CREATE TABLE `y43zw_finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termse
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_links_termsf`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_links_termsf`;
CREATE TABLE `y43zw_finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_links_termsf
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_taxonomy`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_taxonomy`;
CREATE TABLE `y43zw_finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_taxonomy
-- ----------------------------
INSERT INTO `y43zw_finder_taxonomy` VALUES ('1', '0', 'ROOT', '0', '0', '0');

-- ----------------------------
-- Table structure for `y43zw_finder_taxonomy_map`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_taxonomy_map`;
CREATE TABLE `y43zw_finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_taxonomy_map
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_terms`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_terms`;
CREATE TABLE `y43zw_finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_terms
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_terms_common`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_terms_common`;
CREATE TABLE `y43zw_finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_terms_common
-- ----------------------------
INSERT INTO `y43zw_finder_terms_common` VALUES ('a', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('about', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('after', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('ago', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('all', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('am', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('an', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('and', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('ani', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('any', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('are', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('aren\'t', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('as', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('at', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('be', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('but', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('by', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('for', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('from', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('get', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('go', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('how', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('if', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('in', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('into', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('is', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('isn\'t', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('it', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('its', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('me', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('more', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('most', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('must', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('my', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('new', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('no', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('none', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('not', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('noth', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('nothing', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('of', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('off', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('often', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('old', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('on', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('onc', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('once', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('onli', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('only', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('or', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('other', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('our', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('ours', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('out', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('over', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('page', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('she', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('should', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('small', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('so', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('some', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('than', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('thank', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('that', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('the', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('their', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('theirs', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('them', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('then', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('there', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('these', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('they', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('this', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('those', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('thus', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('time', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('times', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('to', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('too', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('true', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('under', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('until', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('up', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('upon', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('use', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('user', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('users', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('veri', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('version', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('very', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('via', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('want', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('was', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('way', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('were', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('what', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('when', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('where', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('whi', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('which', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('who', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('whom', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('whose', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('why', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('wide', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('will', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('with', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('within', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('without', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('would', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('yes', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('yet', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('you', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('your', 'en');
INSERT INTO `y43zw_finder_terms_common` VALUES ('yours', 'en');

-- ----------------------------
-- Table structure for `y43zw_finder_tokens`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_tokens`;
CREATE TABLE `y43zw_finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_tokens
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_tokens_aggregate`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_tokens_aggregate`;
CREATE TABLE `y43zw_finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_tokens_aggregate
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_finder_types`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_finder_types`;
CREATE TABLE `y43zw_finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_finder_types
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_languages`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_languages`;
CREATE TABLE `y43zw_languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(7) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_image` (`image`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_languages
-- ----------------------------
INSERT INTO `y43zw_languages` VALUES ('1', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '1', '1', '2');
INSERT INTO `y43zw_languages` VALUES ('2', 'fr-FR', 'Français (FR)', 'Français (FR)', 'fr', 'fr', '', '', '', '', '1', '1', '1');

-- ----------------------------
-- Table structure for `y43zw_menu`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_menu`;
CREATE TABLE `y43zw_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `ordering` int(11) NOT NULL DEFAULT '0' COMMENT 'The relative ordering of the menu item in the tree.',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`,`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_path` (`path`(255)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_menu
-- ----------------------------
INSERT INTO `y43zw_menu` VALUES ('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '0', '571', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('2', 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '0', '1', '1', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '1', '10', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('3', 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('4', 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', '0', '2', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('5', 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('6', 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '0', '2', '2', '4', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('7', 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '0', '1', '1', '8', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '11', '16', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('8', 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', '0', '7', '2', '8', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact', '0', '', '12', '13', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('9', 'menu', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', '0', '7', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:contact-cat', '0', '', '14', '15', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('10', 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', '0', '1', '1', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages', '0', '', '17', '22', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('11', 'menu', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', '0', '10', '2', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-add', '0', '', '18', '19', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('12', 'menu', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', '0', '10', '2', '15', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:messages-read', '0', '', '20', '21', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('13', 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '0', '1', '1', '17', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '23', '28', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('14', 'menu', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', '0', '13', '2', '17', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds', '0', '', '24', '25', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('15', 'menu', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', '0', '13', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:newsfeeds-cat', '0', '', '26', '27', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('16', 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', '0', '1', '1', '24', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:redirect', '0', '', '41', '42', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('17', 'menu', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', '0', '1', '1', '19', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:search', '0', '', '33', '34', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('18', 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', '0', '1', '1', '21', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks', '0', '', '35', '40', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('19', 'menu', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', '0', '18', '2', '21', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks', '0', '', '36', '37', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('20', 'menu', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', '0', '18', '2', '6', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:weblinks-cat', '0', '', '38', '39', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('21', 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '0', '1', '1', '27', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:finder', '0', '', '31', '32', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('22', 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', '0', '1', '1', '28', '0', '0', '0000-00-00 00:00:00', '0', '0', 'class:joomlaupdate', '0', '', '41', '42', '0', '*', '1');
INSERT INTO `y43zw_menu` VALUES ('101', 'mainmenu', 'Accueil', 'accueil-h2', '', 'accueil-h2', 'index.php?option=com_content&view=article&id=212', 'component', '0', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '29', '30', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('281', 'ct-horizontal-menu', 'Accueil', 'accueil', '', 'accueil', 'index.php?Itemid=', 'alias', '1', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"282\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '401', '402', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('282', 'ct-vertical-menu', 'Accueil', 'accueil-bmpad', '', 'accueil-bmpad', 'index.php?option=com_content&view=featured', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Accueil\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '403', '410', '1', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('283', 'ct-vertical-menu', 'Historique', 'historique', '', 'accueil-bmpad/historique', 'index.php?option=com_content&view=article&id=213', 'component', '1', '282', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Historique\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '406', '407', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('284', 'ct-vertical-menu', 'Mission', 'mission', '', 'accueil-bmpad/mission', 'index.php?option=com_content&view=article&id=214', 'component', '1', '282', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Mission\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '408', '409', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('285', 'ct-vertical-menu', 'Monétisation', 'monetisation', '', 'monetisation', 'index.php?option=com_content&view=article&id=215', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Mon\\u00e9tisation\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '411', '414', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('286', 'ct-vertical-menu', 'Monétisation en cours', 'monetisation-en-cours', '', 'monetisation/monetisation-en-cours', 'index.php?option=com_content&view=article&id=216', 'component', '1', '285', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Mon\\u00e9tisation en cours\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '412', '413', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('287', 'ct-vertical-menu', 'Partenaires', 'partenaires', '', 'partenaires', 'index.php?option=com_content&view=article&id=217', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Partenaires\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '415', '452', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('288', 'ct-vertical-menu', 'Accords Bilatéraux', 'accords-bilateraux', '', 'partenaires/accords-bilateraux', 'index.php?option=com_content&view=article&id=218', 'component', '1', '287', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Accords Bilat\\u00e9raux\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '416', '431', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('289', 'ct-vertical-menu', 'Etats-Unis', 'etats-unis', '', 'partenaires/accords-bilateraux/etats-unis', 'index.php?option=com_content&view=article&id=219', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Etats-Unis\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '417', '418', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('290', 'ct-vertical-menu', 'Japon', 'japon', '', 'partenaires/accords-bilateraux/japon', 'index.php?option=com_content&view=article&id=220', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Japon\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '419', '420', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('291', 'ct-vertical-menu', 'Espagne', 'espagne', '', 'partenaires/accords-bilateraux/espagne', 'index.php?option=com_content&view=article&id=221', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Espagne\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '421', '422', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('292', 'ct-vertical-menu', 'France', 'france', '', 'partenaires/accords-bilateraux/france', 'index.php?option=com_content&view=article&id=222', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"France\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '423', '424', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('293', 'ct-vertical-menu', 'Italie', 'italie', '', 'partenaires/accords-bilateraux/italie', 'index.php?option=com_content&view=article&id=223', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Italie\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '425', '426', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('294', 'ct-vertical-menu', 'Vénézuela', 'venezuela', '', 'partenaires/accords-bilateraux/venezuela', 'index.php?option=com_content&view=article&id=224', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"V\\u00e9n\\u00e9zuela\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '427', '428', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('295', 'ct-vertical-menu', 'Vietnam', 'vietnam', '', 'partenaires/accords-bilateraux/vietnam', 'index.php?option=com_content&view=article&id=225', 'component', '1', '288', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Vietnam\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '429', '430', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('296', 'ct-vertical-menu', 'Accords Multilatéraux', 'accords-multilateraux', '', 'partenaires/accords-multilateraux', 'index.php?option=com_content&view=article&id=226', 'component', '1', '287', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Accords Multilat\\u00e9raux\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '432', '451', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('297', 'ct-vertical-menu', 'PRODEP', 'prodep', '', 'partenaires/accords-multilateraux/prodep', 'index.php?option=com_content&view=article&id=227', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEP\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '441', '442', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('298', 'ct-vertical-menu', 'PRODEPUR', 'prodepur', '', 'partenaires/accords-multilateraux/prodepur', 'index.php?option=com_content&view=article&id=228', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEPUR\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '437', '438', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('299', 'ct-vertical-menu', 'PUGRD', 'pugrd', '', 'partenaires/accords-multilateraux/pugrd', 'index.php?option=com_content&view=article&id=229', 'component', '0', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PUGRD\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '443', '444', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('300', 'ct-vertical-menu', 'PTDT', 'ptdt', '', 'partenaires/accords-multilateraux/ptdt', 'index.php?option=com_content&view=article&id=230', 'component', '0', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PTDT\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '445', '446', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('301', 'ct-vertical-menu', 'PRODEPPAP / CDD URBAIN', 'prodeppap-cdd-urbain', '', 'partenaires/accords-multilateraux/prodeppap-cdd-urbain', 'index.php?option=com_content&view=article&id=231', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEPAD \\/ CDD URBAIN\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '447', '448', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('302', 'ct-vertical-menu', 'PetroCaribe', 'petrocaribe', '', 'petrocaribe', 'index.php?option=com_content&view=article&id=232', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PetroCaribe\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '453', '462', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('303', 'ct-vertical-menu', 'Les Fonds PetroCaribe', 'les-fonds-petrocaribe', '', 'petrocaribe/les-fonds-petrocaribe', 'index.php?option=com_content&view=article&id=233', 'component', '1', '302', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Les Fonds PetroCaribe\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '454', '455', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('304', 'ct-vertical-menu', 'Mécanisme de décaissement', 'mecanisme-de-decaissement', '', 'petrocaribe/mecanisme-de-decaissement', 'index.php?option=com_content&view=article&id=234', 'component', '1', '302', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"M\\u00e9canisme de d\\u00e9caissement\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '456', '457', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('305', 'ct-vertical-menu', 'Video PetroCaribe-Haiti Fr', 'video-petrocaribe-haiti-fr', '', 'petrocaribe/video-petrocaribe-haiti-fr', 'index.php?option=com_content&view=article&id=235', 'component', '0', '302', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Video PetroCaribe-Haiti Fr\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '458', '459', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('306', 'ct-vertical-menu', 'Video PetroCaribe-Haiti Es', 'video-petrocaribe-haiti-es', '', 'petrocaribe/video-petrocaribe-haiti-es', 'index.php?option=com_content&view=article&id=236', 'component', '0', '302', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Video PetroCaribe-Haiti Es\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '460', '461', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('307', 'ct-vertical-menu', 'Passation de Marchés', 'passation-de-marches', '', 'passation-de-marches', 'index.php?option=com_content&view=article&id=237', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Passation de March\\u00e9\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '463', '476', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('308', 'ct-vertical-menu', 'Utilité', 'utilite', '', 'passation-de-marches/utilite', 'index.php?option=com_content&view=article&id=238', 'component', '1', '307', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Utilit\\u00e9\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '464', '465', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('309', 'ct-vertical-menu', 'Dossiers d\'appel d\'offres DAO', 'dossiers-appel-offres-dao', '', 'passation-de-marches/dossiers-appel-offres-dao', 'index.php?option=com_content&view=article&id=239', 'component', '1', '307', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Dossiers d\'appel d\'offres DAO\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '466', '467', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('310', 'ct-vertical-menu', 'Méthodes d\'évaluation des offres', 'methodes-evaluation-offres', '', 'passation-de-marches/methodes-evaluation-offres', 'index.php?option=com_content&view=article&id=240', 'component', '1', '307', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"M\\u00e9thodes d\'\\u00e9valuation des offres\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '468', '469', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('311', 'ct-vertical-menu', 'Procédures de sélection', 'procedures-selection', '', 'passation-de-marches/procedures-selection', 'index.php?option=com_content&view=article&id=241', 'component', '1', '307', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Proc\\u00e9dures de s\\u00e9lection de consultants\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '470', '471', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('312', 'ct-vertical-menu', 'Contrats', 'contrats', '', 'passation-de-marches/contrats', 'index.php?option=com_content&view=article&id=242', 'component', '1', '307', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Contrats\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '472', '473', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('313', 'ct-vertical-menu', 'Avis de recrutement', 'avis-de-recrutement', '', 'passation-de-marches/avis-de-recrutement', 'index.php?option=com_phocadownload&view=category&id=4', 'component', '1', '307', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Avis de recrutement\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '474', '475', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('314', 'ct-vertical-menu', 'Projets', 'projets', '', 'projets', 'index.php?option=com_content&view=category&layout=blog&id=24', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"0\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"page_subheading\":\"\",\"num_leading_articles\":\"2\",\"num_intro_articles\":\"2\",\"num_columns\":\"2\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"0\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Projets\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '477', '502', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('315', 'ct-vertical-menu', 'Critères d\'éligibilité des Projets', 'criteres-eligibilite-projets', '', 'projets/criteres-eligibilite-projets', 'index.php?option=com_content&view=article&id=245', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Crit\\u00e8res d\'\\u00e9ligibilit\\u00e9 des Projets\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '478', '479', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('316', 'ct-vertical-menu', 'Projets priorisés', 'projets-priorises', '', 'projets/projets-priorises', 'index.php?option=com_content&view=article&id=246', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Projets prioris\\u00e9s\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '480', '481', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('317', 'ct-vertical-menu', 'Exécution des projets', 'execution-des-projets', '', 'projets/execution-des-projets', 'index.php?option=com_content&view=article&id=247', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Ex\\u00e9cution des projets\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '482', '483', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('318', 'ct-vertical-menu', 'Programme à Impact Communal', 'programme-a-impact-communal', '', 'projets/programme-a-impact-communal', 'index.php?option=com_content&view=article&id=248', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Programme \\u00e0 Impact Communal\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '484', '485', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('319', 'ct-vertical-menu', 'Programme Appui aux Communes', 'programme-appui-aux-communes', '', 'projets/programme-appui-aux-communes', 'index.php?option=com_content&view=article&id=249', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Appui aux communes\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '486', '487', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('320', 'ct-vertical-menu', 'Programme Investissement Public', 'programme-investissement-public', '', 'projets/programme-investissement-public', 'index.php?option=com_content&view=article&id=250', 'component', '1', '314', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Programme investissement public\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '488', '495', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('321', 'ct-horizontal-menu', 'Plan du site', 'plan-du-site', '', 'plan-du-site', 'index.php?option=com_xmap&view=html&id=1', 'component', '1', '1', '1', '10016', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"include_css\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Plan du site\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '519', '520', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('322', 'ct-horizontal-menu', 'Photos', 'photo', '', 'photo', 'index.php?option=com_content&view=article&id=252', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Photos\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '517', '518', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('323', 'ct-horizontal-menu', 'A propos', 'a propos', '', 'ct-menu-item-43', 'index.php?option=com_content&view=article&id=254', 'component', '0', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":\"1\",\"page_title\":\"A propos de BMPAD\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":\"0\"}', '503', '504', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('324', 'ct-horizontal-menu', 'Publications', 'publications', '', 'publications', 'index.php?option=com_phocadownload&view=categories', 'component', '1', '1', '1', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Publications\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '505', '516', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('325', 'ct-vertical-menu', 'Publications', 'publications-v', '', 'publications-v', 'index.php?option=com_phocadownload&view=categories', 'component', '0', '1', '1', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Publications\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '521', '532', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('326', 'ct-horizontal-menu', 'Etudes et Réalisations', 'etudes-realisations', '', 'publications/etudes-realisations', 'index.php?option=com_phocadownload&view=category&id=2', 'component', '1', '324', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Etudes et R\\u00e9alisations\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '506', '507', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('327', 'ct-vertical-menu', 'Etudes et Réalisations', 'etudes-et-realisations', '', 'publications-v/etudes-et-realisations', 'index.php?option=com_phocadownload&view=category&id=2', 'component', '0', '325', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Etudes et R\\u00e9alisations\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '522', '523', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('328', 'ct-horizontal-menu', 'Appels d\'offre', 'appels-offre', '', 'publications/appels-offre', 'index.php?option=com_phocadownload&view=category&id=3', 'component', '1', '324', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Appels d\'offre\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '508', '509', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('329', 'ct-vertical-menu', 'Appels d\'offre', 'appels-d-offre', '', 'publications-v/appels-d-offre', 'index.php?option=com_phocadownload&view=category&id=3', 'component', '0', '325', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Appels d\'offre\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '524', '525', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('330', 'ct-horizontal-menu', 'Avis de recrutement', 'avis-recrutement', '', 'publications/avis-recrutement', 'index.php?option=com_phocadownload&view=category&id=4', 'component', '1', '324', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Avis de recrutement\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '510', '511', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('331', 'ct-vertical-menu', 'Avis de recrutement', 'avis-de-recrutement', '', 'publications-v/avis-de-recrutement', 'index.php?option=com_phocadownload&view=category&id=4', 'component', '0', '325', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Avis de recrutement\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '526', '527', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('332', 'ct-horizontal-menu', 'Documents à télécharger', 'documents-telecharger', '', 'publications/documents-telecharger', 'index.php?option=com_content&view=article&id=262', 'component', '0', '324', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":\"1\",\"page_title\":\"Documents \\u00e0 t\\u00e9l\\u00e9charger\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":\"0\"}', '512', '513', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('333', 'ct-vertical-menu', 'Documents à télécharger', 'documents-a-telecharger', '', 'publications-v/documents-a-telecharger', 'index.php?option=com_content&view=article&id=262', 'component', '0', '325', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Documents \\u00e0 t\\u00e9l\\u00e9charger\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '528', '529', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('334', 'ct-horizontal-menu', 'Multimédia', 'multimedia', '', 'publications/multimedia', 'index.php?option=com_phocadownload&view=category&id=6', 'component', '1', '324', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Multim\\u00e9dia\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '514', '515', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('335', 'ct-vertical-menu', 'Multimédia', 'multimedia', '', 'publications-v/multimedia', 'index.php?option=com_phocadownload&view=category&id=6', 'component', '0', '325', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Multim\\u00e9dia\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '530', '531', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('336', 'ct-horizontal-menu', 'Actualités', 'actualites', '', 'ct-menu-item-56', 'index.php?option=com_content&view=article&id=264', 'component', '0', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":\"1\",\"page_title\":\"Nouvelle Page\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":\"0\"}', '533', '534', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('337', 'ct-vertical-menu', 'Actualités', 'actualites-v', '', 'actualites-v', 'index.php?option=com_content&view=article&id=264', 'component', '0', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Nouvelle Page\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '535', '536', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('338', 'ct-horizontal-menu', 'Contacts', 'contacts', '', 'contacts', 'index.php?option=com_content&view=article&id=265', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Contacts\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '537', '538', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('339', 'ct-special-menu', 'Special Blog Page', 'ct-menu-item-59', '', 'ct-menu-item-59', 'index.php?option=com_content&view=category&layout=blog&id=21', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"4\",\"num_columns\":\"1\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '539', '540', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('340', 'ct-special-menu', 'Special Single Page', 'ct-menu-item-60', '', 'ct-menu-item-60', 'index.php?option=com_content&view=article&id=', 'component', '1', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":\"1\",\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":\"0\"}', '541', '542', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('369', 'main', 'COM_PHOCADOWNLOAD', 'com-phocadownload', '', 'com-phocadownload', 'index.php?option=com_phocadownload', 'component', '0', '1', '1', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu.png', '0', '', '543', '564', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('370', 'main', 'COM_PHOCADOWNLOAD_CONTROLPANEL', 'com-phocadownload-controlpanel', '', 'com-phocadownload/com-phocadownload-controlpanel', 'index.php?option=com_phocadownload', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-control-panel.png', '0', '', '544', '545', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('371', 'main', 'COM_PHOCADOWNLOAD_FILES', 'com-phocadownload-files', '', 'com-phocadownload/com-phocadownload-files', 'index.php?option=com_phocadownload&view=phocadownloadfiles', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-files.png', '0', '', '546', '547', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('372', 'main', 'COM_PHOCADOWNLOAD_CATEGORIES', 'com-phocadownload-categories', '', 'com-phocadownload/com-phocadownload-categories', 'index.php?option=com_phocadownload&view=phocadownloadcats', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-category.png', '0', '', '548', '549', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('373', 'main', 'COM_PHOCADOWNLOAD_LICENSES', 'com-phocadownload-licenses', '', 'com-phocadownload/com-phocadownload-licenses', 'index.php?option=com_phocadownload&view=phocadownloadlics', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-lic.png', '0', '', '550', '551', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('374', 'main', 'COM_PHOCADOWNLOAD_STATISTICS', 'com-phocadownload-statistics', '', 'com-phocadownload/com-phocadownload-statistics', 'index.php?option=com_phocadownload&view=phocadownloadstat', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-stat.png', '0', '', '552', '553', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('375', 'main', 'COM_PHOCADOWNLOAD_USERS', 'com-phocadownload-users', '', 'com-phocadownload/com-phocadownload-users', 'index.php?option=com_phocadownload&view=phocadownloadusers', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-users.png', '0', '', '554', '555', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('376', 'main', 'COM_PHOCADOWNLOAD_FILE_RATING', 'com-phocadownload-file-rating', '', 'com-phocadownload/com-phocadownload-file-rating', 'index.php?option=com_phocadownload&view=phocadownloadrafile', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-vote-file.png', '0', '', '556', '557', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('377', 'main', 'COM_PHOCADOWNLOAD_TAGS', 'com-phocadownload-tags', '', 'com-phocadownload/com-phocadownload-tags', 'index.php?option=com_phocadownload&view=phocadownloadtags', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-tags.png', '0', '', '558', '559', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('378', 'main', 'COM_PHOCADOWNLOAD_LAYOUT', 'com-phocadownload-layout', '', 'com-phocadownload/com-phocadownload-layout', 'index.php?option=com_phocadownload&view=phocadownloadlayouts', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-layout.png', '0', '', '560', '561', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('379', 'main', 'COM_PHOCADOWNLOAD_INFO', 'com-phocadownload-info', '', 'com-phocadownload/com-phocadownload-info', 'index.php?option=com_phocadownload&view=phocadownloadinfo', 'component', '0', '369', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_phocadownload/assets/images/icon-16-pdl-menu-info.png', '0', '', '562', '563', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('380', 'mainmenu', 'Formulaire de contact', 'contacts-formulaire', '', 'contacts-formulaire', 'index.php?option=com_contact&view=contact&id=1', 'component', '1', '1', '1', '8', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '569', '570', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('381', 'ct-vertical-menu', 'PRODEPUR Habitat', 'prodepur-habitat', '', 'partenaires/accords-multilateraux/prodepur-habitat', 'index.php?option=com_content&view=article&id=268', 'component', '-2', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '439', '440', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('382', 'ct-vertical-menu', 'PREKAD', 'prekad', '', 'prekad', 'index.php?option=com_content&view=article&id=267', 'component', '-2', '1', '1', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '565', '566', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('383', 'ct-vertical-menu', 'PRODEPUR Habitat', 'prodepur-habitat-bm', '', 'partenaires/accords-multilateraux/prodepur-habitat-bm', 'index.php?option=com_content&view=article&id=268', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEPUR\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '435', '436', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('384', 'ct-vertical-menu', 'PREKAD', 'prekad', '', 'partenaires/accords-multilateraux/prekad', 'index.php?option=com_content&view=article&id=267', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEPUR\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '433', '434', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('385', 'main', 'COM_XMAP_TITLE', 'com-xmap-title', '', 'com-xmap-title', 'index.php?option=com_xmap', 'component', '0', '1', '1', '10016', '0', '0', '0000-00-00 00:00:00', '0', '1', 'components/com_xmap/images/xmap-favicon.png', '0', '', '567', '568', '0', '', '1');
INSERT INTO `y43zw_menu` VALUES ('386', 'ct-vertical-menu', 'Infrastructures Scolaires', 'projets-infrastructures-scolaires', '', 'projets/programme-investissement-public/projets-infrastructures-scolaires', 'index.php?option=com_content&view=article&id=269', 'component', '1', '320', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '489', '490', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('387', 'ct-vertical-menu', 'Projets Communaux', 'projets-communaux', '', 'projets/programme-investissement-public/projets-communaux', 'index.php?option=com_content&view=article&id=270', 'component', '1', '320', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '491', '492', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('388', 'ct-vertical-menu', 'Projets BMPAD', 'projets-bmpad', '', 'projets/programme-investissement-public/projets-bmpad', 'index.php?option=com_content&view=article&id=271', 'component', '1', '320', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '493', '494', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('389', 'ct-vertical-menu', 'JSDF', 'jsdf', '', 'partenaires/accords-multilateraux/jsdf', 'index.php?option=com_content&view=article&id=272', 'component', '1', '296', '3', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"PRODEPAD \\/ CDD URBAIN\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '449', '450', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('390', 'ct-vertical-menu', 'Fonds Japonais', '2014-06-25-23-01-07', '', 'projets/2014-06-25-23-01-07', 'index.php?Itemid=', 'alias', '1', '314', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"290\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '496', '497', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('391', 'ct-vertical-menu', 'Fonds Banque Mondiale', '2014-06-27-17-40-05', '', 'projets/2014-06-27-17-40-05', 'index.php?Itemid=', 'alias', '1', '314', '2', '0', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"296\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '498', '499', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('392', 'ct-vertical-menu', 'Fonds PetroCaribe', 'fonds-petrocaribe', '', 'projets/fonds-petrocaribe', 'index.php?option=com_phocadownload&view=category&id=1', 'component', '1', '314', '2', '10012', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_pagination\":\"1\",\"show_pagination_limit\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '500', '501', '0', '*', '0');
INSERT INTO `y43zw_menu` VALUES ('393', 'ct-vertical-menu', 'Qui sommes-nous ?', 'qui-sommes-nous', '', 'accueil-bmpad/qui-sommes-nous', 'index.php?option=com_content&view=article&id=273', 'component', '1', '282', '2', '22', '0', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"0\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Historique\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '404', '405', '0', '*', '0');

-- ----------------------------
-- Table structure for `y43zw_menu_types`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_menu_types`;
CREATE TABLE `y43zw_menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_menu_types
-- ----------------------------
INSERT INTO `y43zw_menu_types` VALUES ('1', 'mainmenu', 'Menu principal', 'Le menu principal du site');
INSERT INTO `y43zw_menu_types` VALUES ('15', 'ct-horizontal-menu', 'Content / Horizontal Menu', '');
INSERT INTO `y43zw_menu_types` VALUES ('16', 'ct-vertical-menu', 'Content / Vertical Menu', '');
INSERT INTO `y43zw_menu_types` VALUES ('17', 'ct-special-menu', 'Content / Special Menu', '');

-- ----------------------------
-- Table structure for `y43zw_messages`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_messages`;
CREATE TABLE `y43zw_messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_messages
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_messages_cfg`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_messages_cfg`;
CREATE TABLE `y43zw_messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_messages_cfg
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_modules`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_modules`;
CREATE TABLE `y43zw_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_modules
-- ----------------------------
INSERT INTO `y43zw_modules` VALUES ('1', 'Menu principal', '', '', '1', 'position-1', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('2', 'Identification', '', '', '1', 'login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('3', 'Articles populaires', '', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('4', 'Articles les plus récents', '', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('8', 'Barre d\'outils', '', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('9', 'Icônes de raccourcis', '', '', '1', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('10', 'Utilisateurs connectés', '', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('12', 'Menu principal', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"forum_url\":\"http:\\/\\/forum.joomla.fr\",\"cache\":\"0\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('13', 'Sous-menu', '', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('14', 'Statut utilisateurs', '', '', '2', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('15', 'Titre', '', '', '1', 'title', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('16', 'Connexion', '', '', '11', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('17', 'Fil de navigation', '', '', '1', 'position-2', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_breadcrumbs', '1', '1', '{\"moduleclass_sfx\":\"\",\"showHome\":\"1\",\"homeText\":\"Accueil\",\"showComponent\":\"1\",\"separator\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('79', 'Statut multilangue', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('86', 'Version Joomla', '', '', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_version', '3', '1', '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*');
INSERT INTO `y43zw_modules` VALUES ('92', 'Suivez-nous', '', '<p><a href=\"https://twitter.com/bmpadhaiti\" target=\"_blank\"><img src=\"images/template-content/icon-twitter.png\" border=\"0\" alt=\"\" width=\"16\" height=\"16\" />Rejoignez nous sur Twitter.</a><br /><a href=\"https://www.facebook.com/pages/BMPAD/1397808410481570\" target=\"_blank\"><img src=\"images/template-content/icon-facebook.png\" border=\"0\" alt=\"\" width=\"16\" height=\"16\" />Rejoignez nous sur facebook.</a><a href=\"http://www.facebook.com\" target=\"_blank\"></a><br /><br /></p>', '5', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('97', 'Slide Module IceTabs', '', '', '1', 'position-16', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_icetabs', '1', '0', '{\"theme\":\"default-white\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"750\",\"main_height\":\"175\",\"imagemain_width\":\"600\",\"imagemain_height\":\"150\",\"limit_items\":\"20\",\"display_button\":\"0\",\"show_readmore\":\"1\",\"auto_strip_tags\":\"1\",\"description_max_chars\":\"300\",\"group\":\"content\",\"source\":\"article_ids\",\"article_ids\":\"233,264,216,244\",\"content_category\":[\"\"],\"ordering\":\"rand_\",\"image_folder\":\"images\\/sampledata\\/fruitshop\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"banner_category\":[\"\"],\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_ordering\":\"cdate_asc\",\"navigator_pos\":\"left\",\"navitem_width\":\"250\",\"navitem_height\":\"60\",\"max_items_display\":\"3\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"50\",\"thumbnail_height\":\"20\",\"title_max_chars\":\"60\",\"layout_style\":\"vrup\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.Cubic.easeInOut\",\"auto_start\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('100', 'Mon Profil', '', '\n            <p>Bienvenue to my Blog!<br>Lobortis odio eu purus ligula imperdiet maecenas quam vel.<br><br>Volutpat sapien sapien donec tincidunt.</p>\n        \n        ', '6', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('101', 'BLBL', '', '<blockquote><span style=\"font-family: Arial; font-size: 12px;\"><span style=\"line-height: 18px;\">Banm limyè, banm lavi </span></span></blockquote>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"font-family: Arial; font-size: 12px;\"><span style=\"line-height: 18px;\">est un programme mis en œuvre par le Gouvernement haïtien afin de résoudre les problèmes du secteur de l’énergie en Haïti.</span></span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"line-height: 115%; font-family: Arial; font-size: 12px;\" lang=\"EN-US\">Ce projet, financé à hauteur de Onze Millions Deux Cent Quatre-vingt Mille (11,280,000) dollars américains à partir des fonds Petrocaribe, par résolution prise en conseil des ministres en date du 28 février 2012, vise à permettre l’électrification des dix (10) départements du pays par l’édification de lampadaires solaires.</span></p>\r\n<p class=\"MsoNormal\" style=\"text-align: justify;\"><span style=\"line-height: 115%; font-family: Arial; font-size: 12px;\">Vu l’importance et l’envergure de ce programme, un financement additionnel de 2.5 millions de dollars américains lui a été octroyé à travers une résolution prise le 11 décembre 2013. Ces fonds devraient notamment permettre la poursuite des activités dans les départements du Nord, du Nord-Est, du Nord-Ouest et des Nippes.</span></p>', '1', 'position-21', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('105', 'Info PetroCaribe', '', '<p><strong style=\"font-family: arial, helvetiva; font-size: 12px; color: #000000;\"><a id=\"divNewsObjectlink\" href=\"http://www.bureaudegestion.gouv.ht/partenaire_bilateraux_petrocaribe.htm\" target=\"_self\">Au 31 mai 2014,<br /></a><span style=\"color: #0099ff;\">environ 30 millions de barils de produits pétroliers ont été recus en Haïti dans le cadre de l\'Accord Petrocaribe.</span></strong></p>\r\n<p><strong style=\"color: #efefef; font-family: arial, helvetiva; text-align: start;\"><strong><span style=\"color: #ff0066;\">A télécharger<br /> {phocadownload view=category|id=1|target=b}<br /></span></strong></strong></p>', '2', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"bmpad-block\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('107', 'Fil de navigation', '', '', '1', 'position-2', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_breadcrumbs', '1', '0', '{\"showHere\":\"0\",\"showHome\":\"0\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('108', 'Flash news', '', '', '1', 'position-21', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_articles_news', '1', '1', '{\"catid\":[\"18\"],\"image\":\"0\",\"item_title\":\"0\",\"link_titles\":\"\",\"item_heading\":\"h4\",\"showLastSeparator\":\"1\",\"readmore\":\"1\",\"count\":\"1\",\"ordering\":\"a.publish_up\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('111', 'Termes de référence', '', '\n            <p>Bienvenue to my Blog!<br>Lobortis odio eu purus ligula imperdiet maecenas quam vel.<br><br>Volutpat sapien sapien donec tincidunt.</p>\n        \n        ', '3', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('113', 'DG', '', '<h6 style=\"text-align: justify;\"><img src=\"images/template-content/dg.png\" border=\"0\" alt=\"LECORPS Michael\" width=\"207\" height=\"182\" style=\"border: 0; vertical-align: top; margin-top: 1px; margin-bottom: 1px;\" /><br />Le BMPAD vous souhaite la bienvenue sur son nouveau site internet.</h6>\r\n<p style=\"text-align: right;\"> Michaël Lecorps, DG</p>', '1', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('118', 'Navigation Horizontal', '', '', '1', 'position-1', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"ct-horizontal-menu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"bmpad-vmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('119', 'Navigation', '', '', '1', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"ct-vertical-menu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"bmpad-vmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('120', 'BMPAD', '', '<h2 style=\"text-align: center;\"><img src=\"images/template-content/logo130.jpg\" border=\"0\" alt=\"\" width=\"130\" height=\"130\" /><br /><span style=\"color: #335214; line-height: 24px; text-align: left; white-space: nowrap; font-family: Arimo; font-size: 20px;\"><a id=\"headline\" name=\"headline\" href=\"#\" style=\"line-height: 28px; text-decoration: none; color: #335214; outline-color: #646464;\"><span style=\"font-weight: bold; color: #a8a510;\">B</span>ureau de<br /><span style=\"color: #a8a510;\">M</span>onétisation des <br /><span style=\"color: #a8a510;\">P</span>rogrammes<br />d\'</a></span><span style=\"color: #335214; font-family: Arimo; font-size: 20px; line-height: 24px; white-space: nowrap;\"><a id=\"headline\" name=\"headline\" href=\"#\" style=\"line-height: 28px; text-decoration: none; color: #335214; outline-color: #646464;\"><span style=\"color: #a8a510;\">A</span>ide au<br /></a></span><span style=\"color: #335214; font-family: Arimo; font-size: 20px; line-height: 24px; white-space: nowrap;\"><a id=\"headline\" name=\"headline\" href=\"#\" style=\"line-height: 28px; text-decoration: none; color: #335214; outline-color: #646464;\"><span style=\"color: #a8a510;\">D</span>éveloppement</a></span></h2>', '1', 'position-4', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('121', 'Avis de recrutement', '', '\n            <p><br>Placerat sem vel.<br><br>Cras id pretium curabitur vivamus cras eget id rutrum ut praesent erat mi nisl ipsum aliquam turpis ut. Orci est arcu eu quam dignissim id varius risus enim orci quis lacus.</p>\n        \n        ', '9', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('122', 'Search', '', '<div>\r\n	<form action=\"#\" class=\"bmpad-search\" method=\"get\" name=\"searchform\">\r\n		<input name=\"s\" type=\"text\" value=\"\" /> <input class=\"bmpad-search-button\" name=\"search\" type=\"submit\" value=\"Search\" />&nbsp;</form>\r\n</div>\r\n', '8', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('123', 'Nous contacter', '', '<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\"><img src=\"images/template-content/BMPAD.png\" border=\"0\" alt=\"\" width=\"200\" height=\"80\" style=\"float: left; margin-top: 0px; margin-left: 0px;\" /> <span class=\"jicons-icons\"><img src=\"media/contacts/images/con_address.png\" border=\"0\" alt=\"Adresse: \" />12 bis, Blvd<span style=\"font-size: 13px;\">. Harry Truman, </span></span></div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\"><span class=\"jicons-icons\"><span>              Bicentenaire (</span></span>Ancien local</div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\">              Casino International) </div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\">              B.P. 2488  </div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\"><span class=\"contact-suburb\">              Port-au-Prince </span><span class=\"contact-country\">Haiti </span></div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\"><span class=\"contact-suburb\">              </span>HT-6110</div>\r\n<div class=\"contact-address\" style=\"background-color: rgba(255, 255, 255, 0.701961);\"><address><span class=\"jicons-icons\" style=\"font-size: 13px; font-style: normal;\"><img src=\"media/contacts/images/emailButton.png\" border=\"0\" alt=\"E-mail: \" /> </span><span class=\"contact-emailto\" style=\"font-size: 13px; font-style: normal;\"><a href=\"mailto:info@bmpad.gouv.ht\">info@bmpad.gouv.ht<br /></a></span><span class=\"jicons-icons\" style=\"font-size: 13px; font-style: normal;\"><img src=\"media/contacts/images/con_tel.png\" border=\"0\" alt=\"Téléphone: \" /> </span><span class=\"contact-telephone\" style=\"font-size: 13px; font-style: normal;\">(509) 2940-8625 \\ 2940-8031<br /></span><span class=\"jicons-icons\" style=\"font-size: 13px; font-style: normal;\"><img src=\"media/contacts/images/con_mobile.png\" border=\"0\" alt=\"Mobile: \" /> </span><span class=\"contact-mobile\" style=\"font-size: 13px; font-style: normal;\">(509) 2813-0933 \\ 2813-1967<br /><br /></span> <a href=\"http://www.bmpad.gouv.ht/\" target=\"_blank\" style=\"font-size: 13px; font-style: normal;\">http://www.bmpad.gouv.ht</a></address></div>', '4', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('124', 'Nouveau Bloc', '', '<p><a id=\"divNewsObjectlink\" name=\"divNewsObjectlink\" href=\"../pl480_7fev07/partenaire_bilateraux_petrocaribe.htm\" target=\"_self\" style=\"font-family: arial, helvetiva; text-align: start; text-decoration: none; color: #000000; cursor: pointer;\"><strong>Au 31 décembre 2013,<br /><span style=\"color: #0099ff;\">environ 28 millions de barils de produits pétroliers ont été recus en Haïti dans le cadre de l\'Accord Petrocaribe.<br /></span></strong></a><strong style=\"color: #efefef; font-family: arial, helvetiva; text-align: start;\"><a href=\"../pl480_7fev07/petrocaribe/Liste_pp.xls\"><strong><span style=\"color: #ff0066;\">Listes des projets Petrocaribe (á télécharger).</span></strong></a></strong></p>\r\n<p><strong style=\"color: #efefef; font-family: arial, helvetiva; text-align: start;\"><strong><span style=\"color: #ff0066;\"> </span></strong></strong></p>\r\n<p>{gallery count=1}japon{/gallery}</p>', '1', 'position-5', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"bmpad-block\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('125', 'Footer', '', '<p>\r\n	&nbsp;</p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"width: 50%; border-width: 0px;\">\r\n				<span style=\"font-family: tahoma; font-size: 11px; line-height: 16.799999237060547px; background-color: #dadada; color: #365615;\">Bureau de Monétisation des Programmes d \'Aide au Développement (BMPAD)<br />\r\n				<span style=\"line-height: 16.799999237060547px; background-color: #dadada; color: #365615;\">Blvd. Harry Truman - Boite postale 2488 - Port-au-Prince, Haiti.&nbsp;</span><br style=\"line-height: 16.799999237060547px; background-color: #dadada;\" />\r\n				<span style=\"line-height: 16.799999237060547px; background-color: #dadada; color: #365615;\">© Copyright 2014 Tous droits réservés</span></span></td>\r\n			<td style=\"width: 50%; text-align: right; border-width: 0px;\">\r\n				<a class=\"bmpad-facebook-tag-icon\" href=\"https://www.facebook.com/pages/BMPAD/1397808410481570\" target=\"_blank\" title=\"Rejoignez nous sur facebook.\"> facebook</a>&nbsp;&nbsp;<a class=\"bmpad-twitter-tag-icon\" href=\"https://twitter.com/bmpadhaiti\" target=\"_blank\" title=\"Rejoignez nous sur Twitter.\">Twitter</a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<table class=\"bmpad-article\" style=\"width: 100%;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"width: 16%; border-width: 0px;\">\r\n				<a href=\"index.php\" title=\"Accueil\">Accueil</a><br />\r\n				<ul class=\"level_0\">\r\n					<li>\r\n						<a href=\"accueil-bmpad/historique.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Historique\">Historique</a></li>\r\n					<li>\r\n						<a href=\"accueil-bmpad/mission.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Mission\">Mission</a></li>\r\n				</ul>\r\n				<a href=\"monetisation.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Monétisation\"><br />\r\n				Monétisation</a><br />\r\n				<ul>\r\n					<li>\r\n						<a href=\"monetisation/monetisation-en-cours.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Monétisation en cours\">Monétisation en cours</a></li>\r\n				</ul>\r\n			</td>\r\n			<td style=\"width: 12%; border-width: 0px;\">\r\n				<table class=\"bmpad-article\">\r\n					<tbody>\r\n						<tr>\r\n							<td title=\"Partenaires\">\r\n								<a href=\"index.php?option=com_content&amp;view=article&amp;id=217&amp;catid=22&amp;Itemid=287\">Partenaires</a><br />\r\n								<ul>\r\n									<li>\r\n										<a href=\"partenaires/accords-bilateraux.html\" title=\"Accords Bilatéraux\">Accords Bilatéraux</a></li>\r\n									<li>\r\n										<a href=\"partenaires/accords-bilateraux/japon.html\" title=\"Japon\">Japon</a></li>\r\n									<li>\r\n										<a href=\"partenaires/accords-bilateraux/venezuela.html\" title=\"Vénézuela\">Vénézuela</a></li>\r\n									<li>\r\n										<a href=\"partenaires/accords-bilateraux/vietnam.html\" title=\"Vietnam\">Vietnam</a></li>\r\n								</ul>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n			</td>\r\n			<td style=\"width: 17%; border-width: 0px;\">\r\n				<a href=\"partenaires/accords-multilateraux.html\" style=\"font-size: inherit;\" title=\"Accords Multilatéraux\">Accords Multilatéraux</a>\r\n				<ul class=\"level_2\" style=\"color: #404b20; font-size: inherit;\">\r\n					<li>\r\n						<a href=\"partenaires/accords-multilateraux/prodep.html\" title=\"PRODEP\">PRODEP</a></li>\r\n					<li>\r\n						<a href=\"partenaires/accords-multilateraux/prodepur.html\" title=\"PRODEPUR\">PRODEPUR</a></li>\r\n					<li>\r\n						<a href=\"partenaires/accords-multilateraux/prekad.html\" title=\"PREKAD\">PREKAD</a></li>\r\n					<li>\r\n						<a href=\"partenaires/accords-multilateraux/prodepur-habitat-bm.html\" title=\"PRODEPUR Habitat\">PRODEPUR Habitat</a></li>\r\n				</ul>\r\n			</td>\r\n			<td style=\"width: 17%; border-width: 0px;\">\r\n				<a href=\"index.php?option=com_content&amp;view=article&amp;id=237&amp;Itemid=307\" style=\"font-size: inherit;\" title=\"Passation de Marchés\">Passation de Marchés</a>\r\n				<ul>\r\n					<li>\r\n						<a href=\"index.php?option=com_phocadownload&amp;view=category&amp;id=4&amp;Itemid=313\" title=\"Avis de recrutement\">Avis de recrutement</a></li>\r\n				</ul>\r\n				<a href=\"petrocaribe.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"PetroCaribe\"><br />\r\n				PetroCaribe</a><br />\r\n				<ul>\r\n					<li>\r\n						<a href=\"petrocaribe/les-fonds-petrocaribe.html\" title=\"Les Fonds PetroCaribe\">Les Fonds PetroCaribe</a></li>\r\n					<li>\r\n						<a href=\"petrocaribe/mecanisme-de-decaissement.html\" title=\"Mécanisme de décaissement\">Mécanisme de décaissement</a></li>\r\n				</ul>\r\n			</td>\r\n			<td style=\"width: 21%; border-width: 0px;\">\r\n				<a href=\"projets.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Projets\">Projets</a><br />\r\n				<ul>\r\n					<li>\r\n						<a href=\"projets/programme-investissement-public.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Programme investissement public\">Programme investissement public</a></li>\r\n					<li>\r\n						<a href=\"projets/programme-investissement-public/projets-infrastructures-scolaires.html\" title=\"Infrastructures Scolaires\">Infrastructures Scolaires</a></li>\r\n					<li>\r\n						<a href=\"projets/programme-investissement-public/projets-communaux.html\" style=\"text-decoration: underline;\" title=\"Projets Communaux\">Projets Communaux</a></li>\r\n					<li>\r\n						<a href=\"projets/programme-investissement-public/projets-bmpad.html\" title=\"Projets BMPAD\">Projets BMPAD</a></li>\r\n				</ul>\r\n				<ul>\r\n					<li>\r\n						<a href=\"partenaires/accords-bilateraux/japon.html\" title=\"Fonds Japonais\">Fonds Japonais</a></li>\r\n					<li>\r\n						<a href=\"partenaires/accords-multilateraux.html\" title=\"Fonds Banque Mondiale\">Fonds Banque Mondiale</a></li>\r\n					<li>\r\n						<a href=\"index.php?option=com_content&amp;view=article&amp;id=270&amp;Itemid=387\" title=\"Projets Communaux\">Projets Communaux</a></li>\r\n				</ul>\r\n			</td>\r\n			<td style=\"width: 18%; border-width: 0px;\">\r\n				<a href=\"publications.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Publications\">Publications</a><br />\r\n				<ul>\r\n					<li>\r\n						<a href=\"publications/etudes-realisations.html\" style=\"font-family: inherit; font-size: inherit;\" title=\"Etudes et Réalisations\">Etudes et Réalisations</a></li>\r\n					<li>\r\n						<a href=\"publications/appels-offre.html\" style=\"font-size: inherit;\" title=\"Appels d\'offre\">Appels d\'offre</a></li>\r\n					<li>\r\n						<a href=\"publications/avis-recrutement.html\" style=\"font-size: inherit;\" title=\"Avis de recrutement\">Avis de recrutement</a></li>\r\n					<li>\r\n						<a href=\"publications/multimedia.html\" style=\"font-size: inherit;\" title=\"Multimédia\">Multimédia</a></li>\r\n				</ul>\r\n				<p style=\"text-align: left; padding-left: 30px;\">\r\n					<a href=\"photo.html\" style=\"font-size: inherit;\" title=\"Photos\"><br />\r\n					Photos</a></p>\r\n				<p style=\"text-align: left; padding-left: 30px;\">\r\n					<a href=\"index.php?option=com_xmap&amp;view=html&amp;id=1&amp;Itemid=321\" title=\"Plan du site\">Plan du site</a></p>\r\n				<p style=\"text-align: left; padding-left: 30px;\">\r\n					<a href=\"index.php?option=com_content&amp;view=article&amp;id=265&amp;Itemid=338\" title=\"Contacts\">Contacts</a></p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>\r\n', '1', 'position-27', '69', '2014-06-27 17:48:18', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('126', 'Phoca Download Section Menu Module', '', '', '1', 'position-20', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_phocadownload_sectionmenu', '1', '1', '', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('127', 'Slide Module Proj_Petrocaribe', '', '', '1', 'position-23', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_icetabs', '1', '0', '{\"theme\":\"default-bmpad\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"600\",\"main_height\":\"460\",\"imagemain_width\":\"550\",\"imagemain_height\":\"450\",\"limit_items\":\"20\",\"display_button\":\"1\",\"show_readmore\":\"0\",\"auto_strip_tags\":\"0\",\"description_max_chars\":\"500\",\"group\":\"image\",\"source\":\"content_category\",\"article_ids\":\"\",\"content_category\":[\"18\"],\"ordering\":\"rand_\",\"image_folder\":\"images\\/sampledata\\/rea_bmpad\\/petrocaribe_slide1_0314\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"banner_category\":[\"\"],\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_ordering\":\"cdate_asc\",\"navigator_pos\":\"left\",\"navitem_width\":\"150\",\"navitem_height\":\"100\",\"max_items_display\":\"5\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"100\",\"thumbnail_height\":\"60\",\"title_max_chars\":\"100\",\"layout_style\":\"hrleft\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.Cubic.easeInOut\",\"auto_start\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('128', 'Slide Module Proj_Realisations_all', '', '', '1', 'position-15', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_icetabs', '1', '0', '{\"theme\":\"default-bmpad\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"720\",\"main_height\":\"550\",\"imagemain_width\":\"720\",\"imagemain_height\":\"500\",\"limit_items\":\"50\",\"display_button\":\"1\",\"show_readmore\":\"0\",\"auto_strip_tags\":\"0\",\"description_max_chars\":\"0\",\"group\":\"image\",\"source\":\"content_category\",\"article_ids\":\"\",\"content_category\":[\"18\"],\"ordering\":\"rand_\",\"image_folder\":\"images\\/sampledata\\/rea_bmpad\\/bmpad_all\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"banner_category\":[\"\"],\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_ordering\":\"cdate_asc\",\"navigator_pos\":\"left\",\"navitem_width\":\"290\",\"navitem_height\":\"100\",\"max_items_display\":\"5\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"245\",\"thumbnail_height\":\"70\",\"title_max_chars\":\"0\",\"layout_style\":\"hrright\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.linear\",\"auto_start\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('129', 'Slide Module Proj_Fonds_Communaux', '', '', '1', 'position-22', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_icetabs', '1', '0', '{\"theme\":\"default-bmpad\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"700\",\"main_height\":\"500\",\"imagemain_width\":\"700\",\"imagemain_height\":\"450\",\"limit_items\":\"10\",\"display_button\":\"1\",\"show_readmore\":\"0\",\"auto_strip_tags\":\"1\",\"description_max_chars\":\"500\",\"group\":\"image\",\"source\":\"content_category\",\"article_ids\":\"\",\"content_category\":[\"18\"],\"ordering\":\"rand_\",\"image_folder\":\"images\\/sampledata\\/rea_bmpad\\/fonds_communaux\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"banner_category\":[\"\"],\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_ordering\":\"cdate_asc\",\"navigator_pos\":\"bottom\",\"navitem_width\":\"158\",\"navitem_height\":\"100\",\"max_items_display\":\"5\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"130\",\"thumbnail_height\":\"80\",\"title_max_chars\":\"100\",\"layout_style\":\"opacity\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.Pow.easeOut\",\"auto_start\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('130', 'Slide Module Proj_Banque_Mondiale', '', '', '1', 'position-22', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_icetabs', '1', '0', '{\"theme\":\"default-bmpad\",\"module_width\":\"auto\",\"module_height\":\"auto\",\"main_width\":\"790\",\"main_height\":\"500\",\"imagemain_width\":\"750\",\"imagemain_height\":\"450\",\"limit_items\":\"10\",\"display_button\":\"0\",\"show_readmore\":\"0\",\"auto_strip_tags\":\"0\",\"description_max_chars\":\"500\",\"group\":\"image\",\"source\":\"content_category\",\"article_ids\":\"\",\"content_category\":[\"18\"],\"ordering\":\"rand_\",\"image_folder\":\"images\\/sampledata\\/rea_bmpad\\/fn_bm\",\"image_category\":\"\",\"image_ordering\":\"\",\"k2_source_from\":\"filter\",\"catfilter\":\"0\",\"k2_category_id\":\"\",\"getChildren\":\"0\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"JPlugins\":\"1\",\"K2Plugins\":\"1\",\"banner_category\":[\"\"],\"banner_ordering\":\"ordering_desc\",\"vm_source\":\"vm_category\",\"vm_items_ids\":\"\",\"vm_ordering\":\"cdate_asc\",\"navigator_pos\":\"bottom\",\"navitem_width\":\"158\",\"navitem_height\":\"100\",\"max_items_display\":\"5\",\"auto_renderthumb\":\"1\",\"image_quanlity\":\"100\",\"thumbnail_width\":\"121\",\"thumbnail_height\":\"60\",\"title_max_chars\":\"100\",\"layout_style\":\"opacity\",\"interval\":\"2000\",\"duration\":\"700\",\"effect\":\"Fx.Transitions.Cubic.easeInOut\",\"auto_start\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('132', 'Slide-Photos projets PetroCaribe module', '', '', '1', 'position-21', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_sigplus', '1', '0', '{\"images_folder\":\"images\\/sampledata\\/rea_bmpad\\/fn_petrocaribe\",\"layout\":\"fixed\",\"rows\":\"1\",\"cols\":\"1\",\"thumb_count\":\"0\",\"thumb_width\":\"600\",\"thumb_height\":\"500\",\"thumb_crop\":\"0\",\"alignment\":\"center\",\"lightbox\":\"boxplus\\/prettyphoto\",\"lightbox_slideshow\":\"0\",\"slider\":\"boxplus.slider\",\"slider_orientation\":\"horizontal\",\"slider_navigation\":\"bottom\",\"slider_buttons\":\"0\",\"slider_links\":\"1\",\"slider_counter\":\"0\",\"slider_overlay\":\"1\",\"slider_duration\":\"800\",\"slider_animation\":\"0\",\"captions\":\"none\",\"caption_title\":\"\",\"caption_description\":\"\",\"download\":\"1\",\"metadata\":\"0\",\"margin\":\"\",\"border_style\":\"\",\"border_width\":\"\",\"border_color\":\"\",\"padding\":\"\",\"thumb_cache\":\"1\",\"thumb_folder\":\"thumbs\",\"preview_folder\":\"preview\",\"fullsize_folder\":\"fullsize\",\"base_url\":\"\",\"thumb_quality\":\"85\",\"labels\":\"labels\",\"labels_multilingual\":\"0\",\"sort_criterion\":\"labels-filename\",\"sort_order\":\"0\",\"linkage\":\"inline\",\"ajaxapi\":\"local\",\"library\":\"default\",\"moduleclass_sfx\":\"\",\"debug\":\"0\",\"settings\":\"\"}', '0', '*');
INSERT INTO `y43zw_modules` VALUES ('133', 'plan du site', '', '', '1', 'position-9', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_articles_category', '1', '1', '{\"mode\":\"dynamic\",\"show_on_article_page\":\"1\",\"show_front\":\"show\",\"count\":\"2\",\"category_filtering_type\":\"1\",\"catid\":[\"22\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"item_heading\":\"4\",\"link_titles\":\"1\",\"show_date\":\"0\",\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\"}', '0', '*');

-- ----------------------------
-- Table structure for `y43zw_modules_menu`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_modules_menu`;
CREATE TABLE `y43zw_modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_modules_menu
-- ----------------------------
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-384');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-383');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-340');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-339');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-338');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-337');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-336');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-335');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-334');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-333');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-332');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-331');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-330');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-329');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-328');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-327');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-326');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-325');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-324');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-323');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-322');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-321');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-320');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-319');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-318');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-317');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-316');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-315');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-314');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-313');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-312');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-311');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-310');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-309');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-308');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-307');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-306');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-305');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-304');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-303');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-302');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-301');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-300');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-299');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-298');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-297');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-296');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-295');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-294');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-293');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-292');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-291');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-290');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-289');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-288');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-287');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-286');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-285');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-284');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-283');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-282');
INSERT INTO `y43zw_modules_menu` VALUES ('1', '-281');
INSERT INTO `y43zw_modules_menu` VALUES ('2', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('3', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('4', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('6', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('7', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('8', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('9', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('10', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('12', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('13', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('14', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('15', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-340');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-339');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-338');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-337');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-336');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-335');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-334');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-333');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-332');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-331');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-330');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-329');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-328');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-327');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-326');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-325');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-324');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-323');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-322');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-321');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-320');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-319');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-318');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-317');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-316');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-315');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-314');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-313');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-312');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-311');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-310');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-309');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-308');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-307');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-306');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-305');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-304');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-303');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-302');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-301');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-300');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-299');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-298');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-297');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-296');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-295');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-294');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-293');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-292');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-291');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-290');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-289');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-288');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-287');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-286');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-285');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-284');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-283');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-282');
INSERT INTO `y43zw_modules_menu` VALUES ('17', '-281');
INSERT INTO `y43zw_modules_menu` VALUES ('79', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('86', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '283');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '380');
INSERT INTO `y43zw_modules_menu` VALUES ('92', '386');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '283');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '284');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '285');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '287');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '289');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '290');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '291');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '292');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '293');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '295');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '297');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '299');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '300');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '301');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '304');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '307');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '310');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '311');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '315');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '316');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '317');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '319');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '380');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('97', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('101', '392');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('105', '304');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '101');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '283');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '284');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '285');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '287');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '289');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '290');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '291');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '292');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '293');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '295');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '297');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '299');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '300');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '301');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '304');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '307');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '310');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '311');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '315');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '316');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '317');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '319');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '380');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '386');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '387');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '388');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '389');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '390');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '391');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '392');
INSERT INTO `y43zw_modules_menu` VALUES ('107', '393');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-380');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-340');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-339');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-338');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-337');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-336');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-335');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-334');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-333');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-332');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-331');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-330');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-329');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-328');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-327');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-326');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-325');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-324');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-323');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-322');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-321');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-320');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-319');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-318');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-317');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-316');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-315');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-314');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-313');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-312');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-311');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-310');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-309');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-308');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-307');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-306');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-305');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-304');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-303');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-302');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-301');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-300');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-299');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-298');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-297');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-296');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-295');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-294');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-293');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-292');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-291');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-290');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-289');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-288');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-287');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-286');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-285');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-284');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-283');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-282');
INSERT INTO `y43zw_modules_menu` VALUES ('108', '-281');
INSERT INTO `y43zw_modules_menu` VALUES ('113', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('113', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('118', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('119', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '285');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '287');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '299');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '386');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '387');
INSERT INTO `y43zw_modules_menu` VALUES ('120', '388');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '283');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '284');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '285');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '287');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '289');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '290');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '291');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '292');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '293');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '295');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '297');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '299');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '300');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '301');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '304');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '307');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '310');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '311');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '315');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '316');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '317');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '319');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('121', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '316');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('122', '389');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '284');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '295');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '315');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '386');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '392');
INSERT INTO `y43zw_modules_menu` VALUES ('123', '393');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '283');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '284');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '285');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '286');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '287');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '288');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '289');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '290');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '291');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '292');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '293');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '295');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '297');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '298');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '299');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '300');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '301');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '304');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '307');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '308');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '309');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '310');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '311');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '312');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '313');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '314');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '315');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '316');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '317');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '318');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '319');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '321');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '322');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '323');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '324');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '325');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '326');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '327');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '328');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '329');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '330');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '331');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '332');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '333');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '334');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '335');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '336');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '337');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '338');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '339');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '340');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '380');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('124', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('125', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('126', '0');
INSERT INTO `y43zw_modules_menu` VALUES ('127', '294');
INSERT INTO `y43zw_modules_menu` VALUES ('127', '302');
INSERT INTO `y43zw_modules_menu` VALUES ('127', '303');
INSERT INTO `y43zw_modules_menu` VALUES ('127', '305');
INSERT INTO `y43zw_modules_menu` VALUES ('127', '306');
INSERT INTO `y43zw_modules_menu` VALUES ('128', '101');
INSERT INTO `y43zw_modules_menu` VALUES ('128', '281');
INSERT INTO `y43zw_modules_menu` VALUES ('128', '282');
INSERT INTO `y43zw_modules_menu` VALUES ('129', '320');
INSERT INTO `y43zw_modules_menu` VALUES ('130', '296');
INSERT INTO `y43zw_modules_menu` VALUES ('130', '383');
INSERT INTO `y43zw_modules_menu` VALUES ('130', '384');
INSERT INTO `y43zw_modules_menu` VALUES ('132', '392');
INSERT INTO `y43zw_modules_menu` VALUES ('133', '0');

-- ----------------------------
-- Table structure for `y43zw_newsfeeds`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_newsfeeds`;
CREATE TABLE `y43zw_newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(200) NOT NULL DEFAULT '',
  `filename` varchar(200) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_newsfeeds
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_overrider`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_overrider`;
CREATE TABLE `y43zw_overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` text NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_overrider
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload`;
CREATE TABLE `y43zw_phocadownload` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `sectionid` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(250) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filename_play` varchar(250) NOT NULL DEFAULT '',
  `filename_preview` varchar(250) NOT NULL DEFAULT '',
  `author` varchar(255) NOT NULL DEFAULT '',
  `author_email` varchar(255) NOT NULL DEFAULT '',
  `author_url` varchar(255) NOT NULL DEFAULT '',
  `license` varchar(255) NOT NULL DEFAULT '',
  `license_url` varchar(255) NOT NULL DEFAULT '',
  `video_filename` varchar(255) NOT NULL DEFAULT '',
  `image_filename` varchar(255) NOT NULL DEFAULT '',
  `image_filename_spec1` varchar(255) NOT NULL DEFAULT '',
  `image_filename_spec2` varchar(255) NOT NULL DEFAULT '',
  `image_download` varchar(255) NOT NULL DEFAULT '',
  `link_external` varchar(255) NOT NULL DEFAULT '',
  `mirror1link` varchar(255) NOT NULL DEFAULT '',
  `mirror1title` varchar(255) NOT NULL DEFAULT '',
  `mirror1target` varchar(10) NOT NULL DEFAULT '',
  `mirror2link` varchar(255) NOT NULL DEFAULT '',
  `mirror2title` varchar(255) NOT NULL DEFAULT '',
  `mirror2target` varchar(10) NOT NULL DEFAULT '',
  `description` text,
  `features` text,
  `changelog` text,
  `notes` text,
  `userid` int(11) NOT NULL DEFAULT '0',
  `version` varchar(255) NOT NULL DEFAULT '',
  `directlink` tinyint(1) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL DEFAULT '0',
  `textonly` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) unsigned NOT NULL DEFAULT '0',
  `confirm_license` int(11) NOT NULL DEFAULT '0',
  `unaccessible_file` int(11) NOT NULL DEFAULT '0',
  `params` text,
  `metakey` text,
  `metadesc` text,
  `metadata` text,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`,`published`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload
-- ----------------------------
INSERT INTO `y43zw_phocadownload` VALUES ('1', '1', '0', '69', '0', '1 RESOLUTION 20 SEPTEMBRE 2008', '1-resolution-20-septembre-2008', 'petrocaribe/1_RESOLUTION_20_SEPT_2008_Programme_urgence.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '69', '', '0', '2014-05-26 20:41:00', '2014-05-26 20:41:00', '0000-00-00 00:00:00', '3', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('2', '1', '0', '0', '0', '2 RESOLUTION 11 FEVRIER 2010', '2-resolution-11-fevrier-2010', 'petrocaribe/2_RESOLUTION_11_FEV_2010.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 20:46:30', '2014-05-26 20:46:30', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('3', '2', '0', '0', '0', 'CADRE DE GESTION ENVIRONNEMENTALE ET SOCIALE (CGES)', 'cadre-de-gestion-environnementale-et-sociale-cges', 'etudes_realisations/CGES_PRODEPUR_FA2.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">L\'application des sauvegardes dans le cadre de la mise en ouvre des opérations financées par le FA 2 continuera à se faire selon les dispositions et règles actuellement en vigueur pour le projet PRODEPUR telles que décrites dans le Cadre de Gestion Environnemental et Social du PRODEPUR (CGES) Financement Additionnel 2 publié le 07/04/2014. Ce document est proposé pour être consulté au même titre que le CGES.</span></p>', '', '', '', '0', '', '0', '2014-05-26 20:48:06', '2014-05-26 20:48:06', '0000-00-00 00:00:00', '1', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('4', '2', '0', '0', '0', 'CADRE DE POLITIQUE ET DE RÉINSTALLATION (CPR)<br>  PRODEPUR HABITAT ET PREKAD', 'ce-cadre-de-politique-et-de-reinstallation-du-prodepur-fa-et-du-prekad-cpr-ce-cadre-de-politique-et-de-reinstallation-du-prodepur-fa-et-du-prekad-cpr', 'etudes_realisations/CPR_PRODEPUR_A_ Avril14.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p>Ce CPR du PRODEPUR Habitat et du PREKAD est diffusé pour consultation sur le site du BMPAD.</p>', '', '', '', '0', '', '0', '2014-04-14 16:50:06', '2014-05-26 20:50:30', '0000-00-00 00:00:00', '1', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('5', '1', '0', '0', '0', '3 RESOLUTION 24 AOUT 2010', '3-resolution-24-aout-2010', 'petrocaribe/3_RESOLUTION_24_AOUT_2010.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:28:06', '2014-05-26 22:28:06', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('6', '1', '0', '0', '0', '4 RESOLUTION 12 MAI 2011', '4-resolution-12-mai-2011', 'petrocaribe/4_RESOLUTION_12_MAI_2011.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:28:28', '2014-05-26 22:28:28', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '4', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('7', '1', '0', '0', '0', '5 RESOLUTION 28 FEVRIER 2012', '5-resolution-28-fevrier-2012', 'petrocaribe/5_RESOLUTION_28_FEV_2012.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:28:46', '2014-05-26 22:28:46', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '5', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('8', '1', '0', '0', '0', '6 RESOLUTION 18 JUILLET 2012', '6-resolution-18-juillet-2012', 'petrocaribe/6_RESOLUTION_18_JUILLET_2012.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:28:58', '2014-05-26 22:28:58', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '6', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('9', '1', '0', '0', '0', '7 RESOLUTION 21 DECEMBRE 2012', '7-resolution-21-decembre-2012', 'petrocaribe/7_RESOLUTION_21_DEC_2012.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:29:15', '2014-05-26 22:29:15', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '7', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('10', '1', '0', '0', '0', '8 RESOLUTION 11 DECEMBRE 2013', '8-resolution-11-decembre-2013', 'petrocaribe/8_RESOLUTION_11_DEC_2013.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:29:27', '2014-05-26 22:29:27', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '8', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('11', '1', '0', '0', '0', 'Listes des projets par secteurs PETROCARIBE', 'listes-des-projets-par-secteurs-petrocaribe', 'petrocaribe/Liste_par_secteur.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:29:48', '2014-05-26 22:29:48', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '9', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('12', '1', '0', '0', '0', 'Listes des projets PETROCARIBE', 'listes-des-projets-petrocaribe', 'petrocaribe/Liste_pp.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:30:14', '2014-05-26 22:30:14', '0000-00-00 00:00:00', '1', '0', '1', '1', '0', '0000-00-00 00:00:00', '10', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('13', '1', '0', '0', '0', 'LES TRANSFERTS PAR RESOLUTION', 'les-transferts-par-resolution', 'petrocaribe/resume.xls', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-05-26 22:30:51', '2014-05-26 22:30:51', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '11', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('14', '2', '0', '0', '0', 'CAHIER DES CHARGES RUE LOUVERTURE - DELMAS 32 ', 'cahier-des-charges-rue-louverture-delmas-32', 'etudes_realisations/Cahier_Des_Charges_Rue_Louverture.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', 'projet_aiq_martissanr_baillergeau.gif', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-12 16:49:06', '2014-06-12 21:03:25', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '4', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('15', '2', '0', '0', '0', 'PLAN DE RECASEMENT RUE LOUVERTURE - DELMAS 32', 'plan-de-recasement-rue-louverture-delmas-32', 'etudes_realisations/PAR_Rue_Louverture_Publication.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Plan d\'Action de Recasement (PAR) de la rue Louverture, Delmas 32. Ce document rentre en conformité avec les procédures de la Banque Mondiale et sujet à consultation.</span></p>', '', '', '', '0', '', '0', '2014-06-12 16:49:06', '2014-06-12 21:45:36', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '5', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('16', '2', '0', '0', '0', 'CADRE DE GESTION DU PATRIMOINE CULTUREL PHYSIQUE', 'cadre-de-gestion-du-patrimoine-culturel-physique', 'etudes_realisations/lcr_pcr_p144614.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', 'projet_aiq_martissanr_baillergeau.gif', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-size: 12px;\">Document Complémentaire au Cadre de Gestion Environnemental et Social du PRODEPUR (CGES) Financement Additionnel 2</span></span></p>\r\n<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\"><span style=\"font-size: 12px;\"> </span></span></p>', '', '', '', '0', '', '0', '2014-06-12 16:49:06', '2014-06-12 16:54:07', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('17', '2', '0', '0', '0', 'CAHIER DES CHARGES RUE NORD ALEXIS - POUPELARD', 'cahier-des-charges-rue-nord-alexis-poupelard', 'etudes_realisations/Cahier_Des_Charges_Nord_Alexis_Revise_Juin2013.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Plan d\'Action de Recasement (PAR) de la rue Nord Alexis. Ce document rentre en conformité avec les procédures de la Banque Mondiale et sujet à consultation.</span></p>', '', '', '', '0', '', '0', '2014-06-12 21:37:13', '2014-06-12 21:39:47', '0000-00-00 00:00:00', '2', '0', '1', '1', '0', '0000-00-00 00:00:00', '6', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('18', '2', '0', '0', '0', 'PLAN DE RECASEMENT COMPLEXE DURAND - DELMAS 32', 'plan-de-recasement-complexe-durand-delmas-32', 'etudes_realisations/PAR_Complexe_Durand_Publication.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Plan d\'Action de Recasement (PAR) Complexe Durand. Ce document rentre en conformité avec les procédures de la Banque Mondiale et sujet à consultation.</span></p>', '', '', '', '0', '', '0', '2014-06-12 21:37:13', '2014-06-12 21:42:05', '0000-00-00 00:00:00', '2', '0', '1', '1', '0', '0000-00-00 00:00:00', '8', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('19', '2', '0', '0', '0', 'PLAN DE RECASEMENT RUE NORD ALEXIS - POUPELARD', 'plan-de-recasement-rue-nord-alexis-poupelard', 'etudes_realisations/PAR_Rue_Nord_Alexis_Revise_Juin2013.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">Plan d\'Action de Recasement (PAR) de la rue Nord Alexis. Ce document rentre en conformité avec les procédures de la Banque Mondiale et sujet à consultation.</span></p>', '', '', '', '0', '', '0', '2014-06-12 21:37:13', '2014-06-12 21:43:58', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '7', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('20', '2', '0', '0', '0', 'ETUDES AMÉNAGEMENT URBAIN CARREFOUR-FEUILLES', 'etudes-amenagement-urbain-carrefour-feuilles', 'etudes_realisations/cartes.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', 'http://web.bmpad.net/index.html\"  target=\"_blank', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '1', '2014-06-12 22:51:02', '2014-06-12 22:51:02', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '9', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('21', '10', '0', '0', '0', 'DOCUMENT ETUDE CARREFOUR-FEUILLES', 'document-etude-carrefour-feuilles', 'etudes_realisations/Document_etude_carrefour_feuilles.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-12 23:05:44', '2014-06-12 23:05:44', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '10', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('22', '10', '0', '0', '0', 'RESUME ETUDE CARREFOUR-FEUILLES', 'resume-etude-carrefour-feuilles', 'etudes_realisations/Resume_etude_carrefour_feuilles.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-12 23:12:37', '2014-06-12 23:12:37', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '11', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('23', '7', '0', '0', '0', 'PRODEPUR en action (sous-titre anglais)', 'prodepur-en-action', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://youtu.be/1x376fuTvew', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '<p>http://youtu.be/1x376fuTvew</p>', '', '', '', '0', '', '0', '2014-06-14 17:46:14', '2014-06-14 17:46:14', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '1', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('24', '7', '0', '0', '0', 'PRODEPUR en action (sous-titre créole)', 'prodepur-en-action-creole', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://youtu.be/CjvltjrcFZQ', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '<p>http://youtu.be/CjvltjrcFZQ</p>', '', '', '', '0', '', '0', '2014-06-14 18:10:44', '2014-06-14 18:10:44', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '2', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('25', '7', '0', '0', '0', 'PRODEPUR en action (sous-titre français)', 'prodepur-en-action-sous-titre-francais', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://youtu.be/CcOzL-hNj-w', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '<p>http://youtu.be/CcOzL-hNj-w</p>', '', '', '', '0', '', '0', '2014-06-14 18:15:43', '2014-06-14 18:15:43', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '3', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('26', '7', '0', '0', '0', 'Biwo monetizasyon pwogram èd pou devlopman yo BMPAD prezante bilan reyalizasyon yo nan kad amenajma', 'biwo-monetizasyon-pwogram-ed-pou-devlopman-yo-bmpad-prezante-bilan-reyalizasyon-yo-nan-kad-amenajma', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://www.youtube.com/watch?v=SnlQUL9lT00', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '<p>http://www.youtube.com/watch?v=SnlQUL9lT00</p>', '', '', '', '0', '', '0', '2014-06-14 18:20:51', '2014-06-14 18:20:51', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '4', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('27', '7', '0', '0', '0', 'BMPAD PetroCaribe Haiti Fr', 'bmpad-petrocaribe-haiti-fr', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://www.youtube.com/watch?v=B3a19xuaZhU', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-14 18:24:22', '2014-06-14 18:24:22', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '5', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('28', '2', '0', '0', '0', 'Monétisation de l\'Aide Alimentaire Japonaise (KR2007)', 'monetisation-de-l-aide-alimentaire-japonaise-kr2007', 'etudes_realisations/Rapport_KR_2007.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-23 19:48:41', '2014-06-23 19:48:41', '0000-00-00 00:00:00', '1', '0', '1', '1', '0', '0000-00-00 00:00:00', '10', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('29', '2', '0', '0', '0', 'Monétisation de l\'Aide Alimentaire Japonaise (KR2008)', 'monetisation-de-l-aide-alimentaire-japonaise-kr2008', 'etudes_realisations/Rapport_KR_2008.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-23 19:49:48', '2014-06-23 19:49:48', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '11', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('30', '2', '0', '0', '0', 'Monétisation de l\'Aide Alimentaire Japonaise (KR2011)', 'monetisation-de-l-aide-alimentaire-japonaise-kr2011', 'etudes_realisations/Rapport_KR_2011.pdf', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-23 19:50:32', '2014-06-23 19:50:32', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '12', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('31', '1', '0', '0', '0', 'PROJETS FINANCES PAR PLUSIEURS RESOLUTIONS', 'projets-finances-par-plusieurs-resolutions', 'petrocaribe/PROJETS_FINANCES_PAR_PLUSIEURS_RESOLUTIONS.xls', '0', '', '', '', '', '', '', '', '', '', '', '', 'fichier_excel.png', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-25 15:36:23', '2014-06-25 15:36:23', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '12', '1', '0', '0', null, '', '', null, '*');
INSERT INTO `y43zw_phocadownload` VALUES ('32', '7', '0', '0', '0', 'JSDF', 'jsdf', 'multimedia/video/video', '0', '', '', '', '', '', '', '', 'http://youtu.be/mtCMIqenPbU', 'fichier_video.png', '', '', '', '', '', '', '_self', '', '', '_self', '', '', '', '', '0', '', '0', '2014-06-25 23:33:40', '2014-06-25 23:33:40', '0000-00-00 00:00:00', '0', '0', '1', '1', '0', '0000-00-00 00:00:00', '6', '1', '0', '0', null, '', '', null, '*');

-- ----------------------------
-- Table structure for `y43zw_phocadownload_categories`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_categories`;
CREATE TABLE `y43zw_phocadownload_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `section` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `image_position` varchar(30) NOT NULL DEFAULT '',
  `description` text,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) unsigned NOT NULL DEFAULT '0',
  `uploaduserid` text,
  `accessuserid` text,
  `deleteuserid` text,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `count` int(11) NOT NULL DEFAULT '0',
  `params` text,
  `hits` int(11) NOT NULL DEFAULT '0',
  `metakey` text,
  `metadesc` text,
  `metadata` text,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_categories
-- ----------------------------
INSERT INTO `y43zw_phocadownload_categories` VALUES ('1', '0', '0', 'Rapports Petrocaribe', '', 'rapports-petrocaribe', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '1', '1', '0', '0', '0', '2014-05-26 20:16:08', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('2', '0', '0', 'Etudes et Réalisations', '', 'etudes-et-realisations', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '2', '1', '0', '0', '0', '2014-05-26 20:36:31', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('3', '0', '0', 'Appels d\'offre', '', 'appels-d-offre', '', '', '<p><span style=\"color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 12px; text-align: justify;\">C’est un ensemble de documents  comportant les directives, les dispositions et spécifications relatives aux prestations désirées, et préparés à l’intention des entreprises intéressées à soumissionner au titre d’une mise en concurrence.</span></p>', '1', '0', '0000-00-00 00:00:00', null, '3', '1', '0', '0', '0', '2014-06-12 19:09:45', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('4', '0', '0', 'Avis de recrutement', '', 'avis-de-recrutement', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '4', '1', '0', '0', '0', '2014-06-12 19:11:50', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('6', '0', '0', 'Multimédia', '', 'multimedia', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '6', '1', '0', '0', '0', '2014-06-12 20:57:49', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('7', '6', '0', 'Vidéo', '', 'video', '', '', '<p><a href=\"http://www.youtube.com/channel/UC4UeL-NYNdEvEdzDXiVQpPw\" target=\"_blank\">Voir la liste sur Youtube</a></p>', '1', '0', '0000-00-00 00:00:00', null, '7', '1', '0', '0', '0', '2014-06-12 20:58:18', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('8', '6', '0', 'Revue de presse', '', 'revue-de-presse', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '8', '1', '0', '0', '0', '2014-06-12 20:59:01', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('9', '6', '0', 'Autres', '', 'autres', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '9', '1', '0', '0', '0', '2014-06-12 20:59:12', '0', null, '0', '', '', null, '*');
INSERT INTO `y43zw_phocadownload_categories` VALUES ('10', '2', '0', 'Etude aménagement urbain Carrefour-feuilles', '', 'etudes-amenagement-urbain-carrefour-feuilles', '', '', '', '1', '0', '0000-00-00 00:00:00', null, '10', '1', '0', '0', '0', '2014-06-12 23:14:51', '0', null, '0', '', '', null, '*');

-- ----------------------------
-- Table structure for `y43zw_phocadownload_file_votes`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_file_votes`;
CREATE TABLE `y43zw_phocadownload_file_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rating` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_file_votes
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_file_votes_statistics`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_file_votes_statistics`;
CREATE TABLE `y43zw_phocadownload_file_votes_statistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `average` float(8,6) NOT NULL DEFAULT '0.000000',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_file_votes_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_layout`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_layout`;
CREATE TABLE `y43zw_phocadownload_layout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `categories` text,
  `category` text,
  `file` text,
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_layout
-- ----------------------------
INSERT INTO `y43zw_phocadownload_layout` VALUES ('1', '<div class=\"pd-categoriesbox\">\r\n<div class=\"pd-title\">{pdtitle}</div>\r\n{pdsubcategories} {pdclear}</div>', '<div class=\"pd-filebox\">{pdfiledesctop} {pdfile}\r\n<div class=\"pd-buttons\">{pdbuttondownload}</div>\r\n<div class=\"pd-buttons\">{pdbuttondetails}</div>\r\n<div class=\"pd-buttons\">{pdbuttonpreview}</div>\r\n<div class=\"pd-buttons\">{pdbuttonplay}</div>\r\n<div class=\"pd-mirrors\">{pdmirrorlink2} {pdmirrorlink1}</div>\r\n<div class=\"pd-rating\">{pdrating}</div>\r\n<div class=\"pd-tags\">{pdtags}</div>\r\n{pdfiledescbottom}\r\n<div class=\"pd-cb\"></div>\r\n</div>', '<div class=\"pd-filebox\">{pdimage} <span style=\"font-size: 13px;\">{pdfile} </span><span style=\"font-size: 13px;\">{pdfilesize} {pdversion} {pdlicense} {pdauthor} {pdauthoremail} {pdfiledate} {pddownloads} {pddescription} {pdfeatures} {pdchangelog} {pdnotes}</span></div>\r\n<div class=\"pd-filebox\">\r\n<div class=\"pd-mirrors\">{pdmirrorlink2} {pdmirrorlink1}</div>\r\n<div class=\"pd-report\">{pdreportlink}</div>\r\n<div class=\"pd-rating\">{pdrating}</div>\r\n<div class=\"pd-tags\">{pdtags}</div>\r\n<div class=\"pd-cb\"></div>\r\n</div>', '0', '0000-00-00 00:00:00', null);

-- ----------------------------
-- Table structure for `y43zw_phocadownload_licenses`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_licenses`;
CREATE TABLE `y43zw_phocadownload_licenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_licenses
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_logging`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_logging`;
CREATE TABLE `y43zw_phocadownload_logging` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `page` varchar(255) NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_logging
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_tags`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_tags`;
CREATE TABLE `y43zw_phocadownload_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `link_cat` int(11) NOT NULL DEFAULT '0',
  `link_ext` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_tags
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_tags_ref`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_tags_ref`;
CREATE TABLE `y43zw_phocadownload_tags_ref` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL DEFAULT '0',
  `tagid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `i_fileid` (`fileid`,`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_tags_ref
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_phocadownload_user_stat`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_phocadownload_user_stat`;
CREATE TABLE `y43zw_phocadownload_user_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_phocadownload_user_stat
-- ----------------------------
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('1', '1', '0', '3', '2014-06-19 21:59:06', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('2', '17', '0', '2', '2014-06-12 22:27:04', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('3', '18', '0', '2', '2014-06-12 22:27:21', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('4', '4', '0', '1', '2014-06-12 22:26:59', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('5', '3', '0', '1', '2014-06-12 22:34:53', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('6', '20', '0', '2', '2014-06-12 22:51:48', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('7', '28', '0', '1', '2014-06-23 21:07:54', '0', '0', '');
INSERT INTO `y43zw_phocadownload_user_stat` VALUES ('8', '12', '0', '1', '2014-06-25 15:02:49', '0', '0', '');

-- ----------------------------
-- Table structure for `y43zw_redirect_links`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_redirect_links`;
CREATE TABLE `y43zw_redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(255) NOT NULL,
  `new_url` varchar(255) NOT NULL,
  `referer` varchar(150) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_link_old` (`old_url`),
  KEY `idx_link_modifed` (`modified_date`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_redirect_links
-- ----------------------------
INSERT INTO `y43zw_redirect_links` VALUES ('1', 'http://localhost/sitebmpad3/index.php/component/content/?id=126&Itemid=184', '', 'http://localhost/sitebmpad3/index.php/ct-menu-item-7/ct-menu-item-9', '', '1', '-2', '2014-04-19 13:04:51', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('2', 'http://localhost/sitebmpad3/index.php/contacts-formulaire', '', 'http://localhost/sitebmpad3/index.php/ct-menu-item-58', '', '1', '-2', '2014-06-11 20:10:51', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('3', 'http://localhost/sitebmpad3/component/content/?id=19&Itemid=118', '', 'http://localhost/sitebmpad3/ct-menu-item-7.html', '', '3', '-2', '2014-06-12 18:24:19', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('4', 'http://192.168.1.133/sitebmpad3/administration', '', '', '', '1', '-2', '2014-06-13 12:27:29', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('5', 'http://192.168.1.133/sitebmpad3/component/content/?id=12&Itemid=111', '', 'http://192.168.1.133/sitebmpad3/ct-menu-item-7.html', '', '1', '-2', '2014-06-13 13:19:05', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('6', 'http://192.168.1.133/sitebmpad3/ct-menu-item-41.html', '', 'http://192.168.1.133/sitebmpad3/ct-menu-item-22/18-news-flash/156-news.html', '', '3', '-2', '2014-06-13 14:58:04', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('7', 'http://192.168.1.133/sitebmpad3/index.php/contacts-formulaire', '', 'http://192.168.1.133/sitebmpad3/ct-menu-item-58.html', '', '2', '-2', '2014-06-13 15:39:09', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('8', 'http://192.168.1.133/sitebmpad3/accueil.html', '', 'http://192.168.1.133/sitebmpad3/accueil.html', '', '1', '-2', '2014-06-13 16:24:03', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('9', 'http://localhost/sitebmpad3/ct-menu-item-22/18-news-flash/156-news.html', '', 'http://localhost/sitebmpad3/ct-menu-item-22.html', '', '1', '-2', '2014-06-13 17:01:33', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('10', 'http://localhost/sitebmpad3/ct-menu-item-22/ct-menu-item-25.html', '', 'http://localhost/sitebmpad3/ct-menu-item-22/ct-menu-item-24.html', '', '1', '-2', '2014-06-13 21:57:24', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('11', 'http://localhost/sitebmpad3/component/content/?id=13&Itemid=112', '', 'http://localhost/sitebmpad3/ct-menu-item-7.html', '', '1', '-2', '2014-06-19 22:08:36', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('12', 'http://localhost/sitebmpad3/contacts-formulaire.html', '', 'http://localhost/sitebmpad3/contacts.html', '', '1', '-2', '2014-06-22 02:29:30', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('13', 'http://localhost/sitebmpad3/component/content/?id=14&Itemid=113', '', 'http://localhost/sitebmpad3/ct-menu-item-7.html', '', '1', '0', '2014-06-22 18:08:33', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('14', 'http://localhost/sitebmpad3/ct-menu-item-44.html', '', 'http://localhost/sitebmpad3/partenaires/accords-bilateraux/japon.html', '', '1', '0', '2014-06-22 22:21:10', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('15', 'http://localhost/sitebmpad3/ct-menu-item-56.html', '', 'http://localhost/sitebmpad3/', '', '1', '0', '2014-06-22 22:32:55', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('16', 'http://localhost/sitebmpad3/cache/thumbs/51ca5bd033b3166fd9b426c521dd5885.html', '', 'http://localhost/sitebmpad3/partenaires.html', '', '1', '0', '2014-06-23 00:07:00', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('17', 'http://localhost/sitebmpad3/cache/thumbs/1cd1051bb566498d14d63b1011289fb3.html', '', 'http://localhost/sitebmpad3/partenaires.html', '', '1', '0', '2014-06-23 00:07:00', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('18', 'http://192.168.1.132/sitebmpad3/partenaires/accords-multilateraux/prodepad-cdd-urbain.html', '', 'http://192.168.1.132/sitebmpad3/partenaires/accords-multilateraux/prodepur-habitat-bm.html', '', '1', '0', '2014-06-23 21:50:16', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('19', 'http://192.168.1.18/sitebmpad3/passation-de-marche.html', '', 'http://192.168.1.18/sitebmpad3/petrocaribe/mecanisme-de-decaissement.html', '', '5', '0', '2014-06-25 19:07:14', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('20', 'http://192.168.1.18/sitebmpad3/component/content/?id=19&Itemid=118', '', 'http://192.168.1.18/sitebmpad3/partenaires.html', '', '3', '0', '2014-06-25 20:10:09', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('21', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux/prodepad-cdd-urbain.html', '', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux.html', '', '2', '0', '2014-06-26 23:26:34', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('22', 'http://192.168.1.18/sitebmpad3/photo/18-news-flash/156-news.html', '', 'http://192.168.1.18/sitebmpad3/photo.html', '', '1', '0', '2014-06-27 16:56:34', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('23', 'http://192.168.1.18/sitebmpad3/passation-de-marche/avis-de-recrutement.html', '', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux/prodepur-habitat-bm.html', '', '3', '0', '2014-06-27 17:43:25', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('24', 'http://192.168.1.18/sitebmpad3/projets/2014-06-25-23-01-9.html', '', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux/prodepur-habitat-bm.html', '', '2', '0', '2014-06-27 17:45:12', '0000-00-00 00:00:00');
INSERT INTO `y43zw_redirect_links` VALUES ('25', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux/prodepur-habitat-bm/22-articles/251-article-43.html', '', 'http://192.168.1.18/sitebmpad3/partenaires/accords-multilateraux/prodepur-habitat-bm.html', '', '1', '0', '2014-06-27 17:46:44', '0000-00-00 00:00:00');

-- ----------------------------
-- Table structure for `y43zw_schemas`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_schemas`;
CREATE TABLE `y43zw_schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_schemas
-- ----------------------------
INSERT INTO `y43zw_schemas` VALUES ('700', '2.5.19');

-- ----------------------------
-- Table structure for `y43zw_session`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_session`;
CREATE TABLE `y43zw_session` (
  `session_id` varchar(200) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `guest` tinyint(4) unsigned DEFAULT '1',
  `time` varchar(14) DEFAULT '',
  `data` mediumtext,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) DEFAULT '',
  `usertype` varchar(50) DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `whosonline` (`guest`,`usertype`),
  KEY `userid` (`userid`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_session
-- ----------------------------
INSERT INTO `y43zw_session` VALUES ('0af56dc25978b3e58bf666df40341e31', '1', '1', '1403892667', '__default|a:8:{s:15:\"session.counter\";i:1;s:19:\"session.timer.start\";i:1403892666;s:18:\"session.timer.last\";i:1403892666;s:17:\"session.timer.now\";i:1403892666;s:22:\"session.client.browser\";s:108:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.97 Safari/537.36\";s:8:\"registry\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:4:\"user\";O:5:\"JUser\":25:{s:9:\"\0*\0isRoot\";N;s:2:\"id\";i:0;s:4:\"name\";N;s:8:\"username\";N;s:5:\"email\";N;s:8:\"password\";N;s:14:\"password_clear\";s:0:\"\";s:8:\"usertype\";N;s:5:\"block\";N;s:9:\"sendEmail\";i:0;s:12:\"registerDate\";N;s:13:\"lastvisitDate\";N;s:10:\"activation\";N;s:6:\"params\";N;s:6:\"groups\";a:0:{}s:5:\"guest\";i:1;s:13:\"lastResetTime\";N;s:10:\"resetCount\";N;s:10:\"\0*\0_params\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:14:\"\0*\0_authGroups\";N;s:14:\"\0*\0_authLevels\";a:2:{i:0;i:1;i:1;i:1;}s:15:\"\0*\0_authActions\";N;s:12:\"\0*\0_errorMsg\";N;s:10:\"\0*\0_errors\";a:0:{}s:3:\"aid\";i:0;}s:13:\"session.token\";s:32:\"fbcaf4bff3b49e766536729eb1c4dd59\";}', '0', '', '');
INSERT INTO `y43zw_session` VALUES ('a4fklp98en7u0jhngo6rr22pp0', '0', '1', '1403892347', '__default|a:8:{s:15:\"session.counter\";i:97;s:19:\"session.timer.start\";i:1403890167;s:18:\"session.timer.last\";i:1403892339;s:17:\"session.timer.now\";i:1403892346;s:22:\"session.client.browser\";s:102:\"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.153 Safari/537.36\";s:8:\"registry\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:4:\"user\";O:5:\"JUser\":25:{s:9:\"\0*\0isRoot\";b:0;s:2:\"id\";i:0;s:4:\"name\";N;s:8:\"username\";N;s:5:\"email\";N;s:8:\"password\";N;s:14:\"password_clear\";s:0:\"\";s:8:\"usertype\";N;s:5:\"block\";N;s:9:\"sendEmail\";i:0;s:12:\"registerDate\";N;s:13:\"lastvisitDate\";N;s:10:\"activation\";N;s:6:\"params\";N;s:6:\"groups\";a:0:{}s:5:\"guest\";i:1;s:13:\"lastResetTime\";N;s:10:\"resetCount\";N;s:10:\"\0*\0_params\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:14:\"\0*\0_authGroups\";a:1:{i:0;i:1;}s:14:\"\0*\0_authLevels\";a:2:{i:0;i:1;i:1;i:1;}s:15:\"\0*\0_authActions\";N;s:12:\"\0*\0_errorMsg\";N;s:10:\"\0*\0_errors\";a:0:{}s:3:\"aid\";i:0;}s:13:\"session.token\";s:32:\"2d2e72a870aa8f915a9b37efd61dacdc\";}', '0', '', '');

-- ----------------------------
-- Table structure for `y43zw_template_styles`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_template_styles`;
CREATE TABLE `y43zw_template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_home` (`home`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_template_styles
-- ----------------------------
INSERT INTO `y43zw_template_styles` VALUES ('2', 'bluestork', '1', '1', 'Bluestork - Défault', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\"}');
INSERT INTO `y43zw_template_styles` VALUES ('5', 'hathor', '1', '0', 'Hathor - Défault', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}');
INSERT INTO `y43zw_template_styles` VALUES ('16', 'bmpadv451', '0', '1', 'bmpadv451 - Par défaut', '{\"siteTitle\":\"Bureau de Mon\\u00e9tisation <br>  des Programmes d\'Aide au D\\u00e9veloppement\",\"siteSlogan\":\"R\\u00e9publique d\'Ha\\u00efti\"}');

-- ----------------------------
-- Table structure for `y43zw_updates`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_updates`;
CREATE TABLE `y43zw_updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `categoryid` int(11) DEFAULT '0',
  `name` varchar(100) DEFAULT '',
  `description` text NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(10) DEFAULT '',
  `data` text NOT NULL,
  `detailsurl` text NOT NULL,
  `infourl` text NOT NULL,
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COMMENT='Available Updates';

-- ----------------------------
-- Records of y43zw_updates
-- ----------------------------
INSERT INTO `y43zw_updates` VALUES ('1', '3', '0', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '2.5.8.1', '', 'http://update.joomla.org/language/details/hy-AM_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('2', '3', '0', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/id-ID_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('3', '3', '0', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/da-DK_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('4', '3', '0', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/km-KH_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('5', '3', '0', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '2.5.10.1', '', 'http://update.joomla.org/language/details/sv-SE_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('6', '3', '0', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '2.5.14.1', '', 'http://update.joomla.org/language/details/hu-HU_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('7', '3', '0', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/bg-BG_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('9', '3', '0', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/it-IT_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('10', '3', '0', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/es-ES_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('11', '3', '0', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/nl-NL_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('12', '3', '0', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/tr-TR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('13', '3', '0', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '2.5.13.11', '', 'http://update.joomla.org/language/details/uk-UA_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('14', '3', '0', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/sk-SK_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('15', '3', '0', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '2.5.8.1', '', 'http://update.joomla.org/language/details/be-BY_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('16', '3', '0', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/lv-LV_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('17', '3', '0', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/et-EE_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('18', '3', '0', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '2.5.11.1', '', 'http://update.joomla.org/language/details/ro-RO_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('19', '3', '0', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/nl-BE_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('20', '3', '0', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/mk-MK_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('21', '3', '0', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/ja-JP_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('22', '3', '0', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/sr-YU_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('23', '3', '0', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/ar-AA_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('24', '3', '0', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/de-DE_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('25', '3', '0', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '2.5.16.1', '', 'http://update.joomla.org/language/details/nb-NO_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('26', '3', '0', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/en-AU_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('27', '3', '0', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/en-US_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('28', '3', '0', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/sr-RS_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('29', '3', '0', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/lt-LT_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('30', '3', '0', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '2.5.1.5', '', 'http://update.joomla.org/language/details/sq-AL_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('31', '3', '0', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/cs-CZ_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('32', '3', '0', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/fa-IR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('33', '3', '0', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '2.5.7.4', '', 'http://update.joomla.org/language/details/gl-ES_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('34', '3', '0', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/pl-PL_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('35', '3', '0', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '2.5.19.1', '', 'http://update.joomla.org/language/details/sy-IQ_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('36', '3', '0', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '2.5.8.1', '', 'http://update.joomla.org/language/details/pt-PT_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('37', '3', '0', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/ru-RU_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('38', '3', '0', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/he-IL_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('39', '3', '0', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/ca-ES_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('40', '3', '0', '0', 'Laotian', '', 'pkg_lo-LA', 'package', '', '0', '2.5.6.1', '', 'http://update.joomla.org/language/details/lo-LA_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('41', '3', '0', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '2.5.16.1', '', 'http://update.joomla.org/language/details/af-ZA_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('42', '3', '0', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/zh-CN_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('43', '3', '0', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '2.5.6.1', '', 'http://update.joomla.org/language/details/el-GR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('44', '3', '0', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '2.5.19.1', '', 'http://update.joomla.org/language/details/eo-XX_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('45', '3', '0', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/fi-FI_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('46', '3', '0', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '2.5.9.1', '', 'http://update.joomla.org/language/details/pt-BR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('47', '3', '0', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '2.5.19.1', '', 'http://update.joomla.org/language/details/zh-TW_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('48', '3', '0', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '2.5.8.1', '', 'http://update.joomla.org/language/details/vi-VN_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('49', '3', '0', '0', 'Kurdish Sorani', '', 'pkg_ckb-IQ', 'package', '', '0', '2.5.9.1', '', 'http://update.joomla.org/language/details/ckb-IQ_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('50', '3', '0', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '2.5.0.1', '', 'http://update.joomla.org/language/details/bn-BD_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('51', '3', '0', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/bs-BA_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('52', '3', '0', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '2.5.13.1', '', 'http://update.joomla.org/language/details/hr-HR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('53', '3', '0', '0', 'Azeri', '', 'pkg_az-AZ', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/az-AZ_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('54', '3', '0', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '2.5.8.1', '', 'http://update.joomla.org/language/details/nn-NO_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('55', '3', '0', '0', 'Tamil India', '', 'pkg_ta-IN', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/ta-IN_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('56', '3', '0', '0', 'Scottish Gaelic', '', 'pkg_gd-GB', 'package', '', '0', '2.5.7.1', '', 'http://update.joomla.org/language/details/gd-GB_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('57', '3', '0', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '2.5.20.1', '', 'http://update.joomla.org/language/details/th-TH_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('58', '3', '0', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '1.7.0.1', '', 'http://update.joomla.org/language/details/eu-ES_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('59', '3', '0', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '2.5.7.2', '', 'http://update.joomla.org/language/details/ug-CN_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('60', '3', '0', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '2.5.11.1', '', 'http://update.joomla.org/language/details/ko-KR_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('61', '3', '0', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '2.5.6.1', '', 'http://update.joomla.org/language/details/hi-IN_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('62', '3', '0', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '2.5.6.1', '', 'http://update.joomla.org/language/details/cy-GB_details.xml', '');
INSERT INTO `y43zw_updates` VALUES ('63', '3', '0', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '2.5.21.1', '', 'http://update.joomla.org/language/details/sw-KE_details.xml', '');

-- ----------------------------
-- Table structure for `y43zw_update_categories`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_update_categories`;
CREATE TABLE `y43zw_update_categories` (
  `categoryid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT '',
  `description` text NOT NULL,
  `parent` int(11) DEFAULT '0',
  `updatesite` int(11) DEFAULT '0',
  PRIMARY KEY (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Update Categories';

-- ----------------------------
-- Records of y43zw_update_categories
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_update_sites`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_update_sites`;
CREATE TABLE `y43zw_update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Update Sites';

-- ----------------------------
-- Records of y43zw_update_sites
-- ----------------------------
INSERT INTO `y43zw_update_sites` VALUES ('1', 'Joomla Core', 'collection', '', '0', '0');
INSERT INTO `y43zw_update_sites` VALUES ('2', 'Joomla Extension Directory', 'collection', 'http://update.joomla.org/jed/list.xml', '0', '1397840176');
INSERT INTO `y43zw_update_sites` VALUES ('3', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist.xml', '0', '1402589971');
INSERT INTO `y43zw_update_sites` VALUES ('4', 'Xmap Update Site', 'extension', 'https://raw.github.com/guilleva/Xmap/master/xmap-update.xml', '0', '1402694778');
INSERT INTO `y43zw_update_sites` VALUES ('5', 'JoomlaCK Editor Update Site', 'extension', 'http://www.joomlackeditor.com/upgrade/plg_jckeditor.xml', '1', '1403890216');

-- ----------------------------
-- Table structure for `y43zw_update_sites_extensions`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_update_sites_extensions`;
CREATE TABLE `y43zw_update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Links extensions to update sites';

-- ----------------------------
-- Records of y43zw_update_sites_extensions
-- ----------------------------
INSERT INTO `y43zw_update_sites_extensions` VALUES ('1', '700');
INSERT INTO `y43zw_update_sites_extensions` VALUES ('2', '700');
INSERT INTO `y43zw_update_sites_extensions` VALUES ('3', '600');
INSERT INTO `y43zw_update_sites_extensions` VALUES ('4', '602');
INSERT INTO `y43zw_update_sites_extensions` VALUES ('4', '10016');
INSERT INTO `y43zw_update_sites_extensions` VALUES ('5', '10024');

-- ----------------------------
-- Table structure for `y43zw_usergroups`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_usergroups`;
CREATE TABLE `y43zw_usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_usergroups
-- ----------------------------
INSERT INTO `y43zw_usergroups` VALUES ('1', '0', '1', '20', 'Public');
INSERT INTO `y43zw_usergroups` VALUES ('2', '1', '6', '17', 'Enregistré');
INSERT INTO `y43zw_usergroups` VALUES ('3', '2', '7', '14', 'Auteur');
INSERT INTO `y43zw_usergroups` VALUES ('4', '3', '8', '11', 'Rédacteur');
INSERT INTO `y43zw_usergroups` VALUES ('5', '4', '9', '10', 'Éditeur');
INSERT INTO `y43zw_usergroups` VALUES ('6', '1', '2', '5', 'Gestionnaire');
INSERT INTO `y43zw_usergroups` VALUES ('7', '6', '3', '4', 'Administrateur');
INSERT INTO `y43zw_usergroups` VALUES ('8', '1', '18', '19', 'Super Utilisateur');

-- ----------------------------
-- Table structure for `y43zw_users`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_users`;
CREATE TABLE `y43zw_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `usertype` varchar(25) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  PRIMARY KEY (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`),
  KEY `idx_block` (`block`),
  KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_users
-- ----------------------------
INSERT INTO `y43zw_users` VALUES ('69', 'Super User', 'jgorival', 'orimix@yahoo.fr', '$P$DlggErD.fpAJLHS/NcW/49rUq0Y6/50', 'deprecated', '0', '1', '2014-04-15 23:16:12', '2014-06-27 17:24:27', '0', '', '0000-00-00 00:00:00', '0');

-- ----------------------------
-- Table structure for `y43zw_user_notes`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_user_notes`;
CREATE TABLE `y43zw_user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_user_notes
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_user_profiles`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_user_profiles`;
CREATE TABLE `y43zw_user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` varchar(255) NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Simple user profile storage table';

-- ----------------------------
-- Records of y43zw_user_profiles
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_user_usergroup_map`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_user_usergroup_map`;
CREATE TABLE `y43zw_user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_user_usergroup_map
-- ----------------------------
INSERT INTO `y43zw_user_usergroup_map` VALUES ('69', '8');

-- ----------------------------
-- Table structure for `y43zw_viewlevels`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_viewlevels`;
CREATE TABLE `y43zw_viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_viewlevels
-- ----------------------------
INSERT INTO `y43zw_viewlevels` VALUES ('1', 'Accès Public', '0', '[1]');
INSERT INTO `y43zw_viewlevels` VALUES ('2', 'Accès Enregistré', '1', '[6,2,8]');
INSERT INTO `y43zw_viewlevels` VALUES ('3', 'Accès Spécial', '2', '[6,3,8]');

-- ----------------------------
-- Table structure for `y43zw_weblinks`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_weblinks`;
CREATE TABLE `y43zw_weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_weblinks
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_xmap_items`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_xmap_items`;
CREATE TABLE `y43zw_xmap_items` (
  `uid` varchar(100) NOT NULL,
  `itemid` int(11) NOT NULL,
  `view` varchar(10) NOT NULL,
  `sitemap_id` int(11) NOT NULL,
  `properties` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`uid`,`itemid`,`view`,`sitemap_id`),
  KEY `uid` (`uid`,`itemid`),
  KEY `view` (`view`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_xmap_items
-- ----------------------------

-- ----------------------------
-- Table structure for `y43zw_xmap_sitemap`
-- ----------------------------
DROP TABLE IF EXISTS `y43zw_xmap_sitemap`;
CREATE TABLE `y43zw_xmap_sitemap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `introtext` text,
  `metadesc` text,
  `metakey` text,
  `attribs` text,
  `selections` text,
  `excluded_items` text,
  `is_default` int(1) DEFAULT '0',
  `state` int(2) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `count_xml` int(11) DEFAULT NULL,
  `count_html` int(11) DEFAULT NULL,
  `views_xml` int(11) DEFAULT NULL,
  `views_html` int(11) DEFAULT NULL,
  `lastvisit_xml` int(11) DEFAULT NULL,
  `lastvisit_html` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of y43zw_xmap_sitemap
-- ----------------------------
INSERT INTO `y43zw_xmap_sitemap` VALUES ('1', 'Plan su site BMPAD', 'plan-su-site-bmpad', '', null, null, '{\"showintro\":\"1\",\"show_menutitle\":\"1\",\"classname\":\"\",\"columns\":\"\",\"exlinks\":\"img_blue.gif\",\"compress_xml\":\"1\",\"beautify_xml\":\"1\",\"include_link\":\"0\",\"news_publication_name\":\"\"}', '{\"ct-horizontal-menu\":{\"priority\":\"0.5\",\"changefreq\":\"weekly\",\"ordering\":0},\"ct-vertical-menu\":{\"priority\":\"0.5\",\"changefreq\":\"weekly\",\"ordering\":1}}', null, '1', '1', '1', '2014-06-13 13:31:37', '48', '54', '3', '43', '1403889489', '1403891926');
